/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveTldFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EffectiveTldFinder.class);
    public static final String ETLD_DATA = "/effective_tld_names.dat";
    public static final String COMMENT = "//";
    public static final String DOT_REGEX = "\\.";
    public static final String EXCEPTION = "!";
    public static final String WILD_CARD = "*.";
    public static final char DOT = '.';
    private static EffectiveTldFinder instance = null;
    private Map<String, EffectiveTLD> domains = null;
    private boolean configured = false;

    private EffectiveTldFinder() {
        this.initialize(null);
    }

    public static EffectiveTldFinder getInstance() {
        if (null == instance) {
            instance = new EffectiveTldFinder();
        }
        return instance;
    }

    public boolean initialize(InputStream effective_tld_data_stream) {
        this.domains = new HashMap<String, EffectiveTLD>();
        try {
            if (null == effective_tld_data_stream && null != this.getClass().getResource(ETLD_DATA)) {
                effective_tld_data_stream = this.getClass().getResourceAsStream(ETLD_DATA);
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(effective_tld_data_stream));
            String line = null;
            while (null != (line = input.readLine())) {
                if (line.length() == 0 || line.length() > 1 && line.startsWith(COMMENT)) continue;
                EffectiveTLD entry = new EffectiveTLD(line);
                this.domains.put(entry.getDomain(), entry);
            }
            this.configured = true;
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("EffectiveTldFinder configuration failed: ", (Throwable)e);
            }
            this.configured = false;
        }
        return this.configured;
    }

    public static Map<String, EffectiveTLD> getEffectiveTLDs() {
        return (Map)((HashMap)EffectiveTldFinder.getInstance().domains).clone();
    }

    public static EffectiveTLD getEffectiveTLD(String hostname) {
        if (EffectiveTldFinder.getInstance().domains.containsKey(hostname)) {
            return EffectiveTldFinder.getInstance().domains.get(hostname);
        }
        String[] parts = hostname.split(DOT_REGEX);
        if (!EffectiveTldFinder.getInstance().domains.containsKey(parts[parts.length - 1])) {
            return null;
        }
        for (int i = 1; i < parts.length; ++i) {
            Object[] slice = Arrays.copyOfRange(parts, i, parts.length);
            String tryTld = EffectiveTldFinder.join((String[])slice);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(hostname + " [" + i + ".." + parts.length + "]: " + Arrays.toString(slice) + " => " + tryTld);
            }
            if (!EffectiveTldFinder.getInstance().domains.containsKey(tryTld)) continue;
            EffectiveTLD foundTld = EffectiveTldFinder.getInstance().domains.get(tryTld);
            if (foundTld.isException() || !foundTld.isWild()) {
                return foundTld;
            }
            slice = Arrays.copyOfRange(parts, i - 1, parts.length);
            String retryTld = EffectiveTldFinder.join((String[])slice);
            foundTld = new EffectiveTLD(retryTld);
            return foundTld;
        }
        return null;
    }

    public static String getAssignedDomain(String hostname) {
        EffectiveTLD etld = EffectiveTldFinder.getEffectiveTLD(hostname);
        if (null == etld || etld.getDomain() == hostname.toLowerCase()) {
            return hostname.toLowerCase();
        }
        String domain = hostname.replaceFirst(".*?([^.]+\\.)" + etld.getDomain() + "$", "$1" + etld.getDomain());
        return domain;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private static String join(String[] ary) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ary.length; ++i) {
            sb.append(ary[i]).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static class EffectiveTLD {
        private boolean exception = false;
        private boolean wild = false;
        private String domain = null;

        public EffectiveTLD(String line) {
            if (line.startsWith(EffectiveTldFinder.EXCEPTION)) {
                this.exception = true;
                this.domain = line.substring(1, line.length());
            } else if (line.startsWith(EffectiveTldFinder.WILD_CARD)) {
                this.wild = true;
                this.domain = line.substring(2, line.length());
            } else {
                this.domain = line;
            }
            this.domain = this.normalize_name(this.domain);
        }

        private String normalize_name(String name) {
            String[] parts = name.split(EffectiveTldFinder.DOT_REGEX);
            if (parts.length < 2) {
                return name;
            }
            String[] ary = new String[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ary[i] = this.asciiConvert(parts[i]);
            }
            return EffectiveTldFinder.join(ary);
        }

        private String asciiConvert(String str) {
            if (this.isAscii(str)) {
                return str.toLowerCase();
            }
            return IDN.toASCII(str);
        }

        private boolean isAscii(String str) {
            char[] chars;
            for (char c : chars = str.toCharArray()) {
                if (c <= '\u007f') continue;
                return false;
            }
            return true;
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean isWild() {
            return this.wild;
        }

        public boolean isException() {
            return this.exception;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            sb.append("domain=").append(this.domain).append(",");
            sb.append("wild=").append(this.wild).append(",");
            sb.append("exception=").append(this.exception).append("]");
            return sb.toString();
        }
    }
}

