/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.url;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaidLevelDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaidLevelDomain.class);
    private static final String CC_TLDS = "ac ad ae af ag ai al am an ao aq ar as at au aw ax az ba bb bd be bf bg bh bi bj bl bm bn bo br bs bt bv bw by bz ca cc cd cf cg ch ci ck cl cm cn co cr cu cv cx cy cz de dj dk dm do dz ec ee eg eh er es et eu fi fj fk fm fo fr ga gb gd ge gf gg gh gi gl gm gn gp gq gr gs gt gu gw gy hk hm hn hr ht hu id ie il im in io iq ir is it je jm jo jp ke kg kh ki km kn kp kr kw ky kz la lb lc li lk lr ls lt lu lv ly ma mc md me mf mg mh mk ml mm mn mo mp mq mr ms mt mu mv mw mx my mz na nc ne nf ng ni nl no np nr nu nz om pa pe pf pg ph pk pl pm pn pr ps pt pw py qa re ro rs ru rw sa sb sc sd se sg sh si sj sk sl sm sn so sr st su sv sy sz tc td tf tg th tj tk tl tm tn to tp tr tt tv tw tz ua ug uk um us uy uz va vc ve vg vi vn vu wf ws ye yt yu za zm zw";
    private static final String G_TLDS = "aero arpa asia biz cat com coop edu gov info int jobs mil mobi museum name net org pro tel";
    private static final Set<String> ccTLDs = new HashSet<String>(Arrays.asList("ac ad ae af ag ai al am an ao aq ar as at au aw ax az ba bb bd be bf bg bh bi bj bl bm bn bo br bs bt bv bw by bz ca cc cd cf cg ch ci ck cl cm cn co cr cu cv cx cy cz de dj dk dm do dz ec ee eg eh er es et eu fi fj fk fm fo fr ga gb gd ge gf gg gh gi gl gm gn gp gq gr gs gt gu gw gy hk hm hn hr ht hu id ie il im in io iq ir is it je jm jo jp ke kg kh ki km kn kp kr kw ky kz la lb lc li lk lr ls lt lu lv ly ma mc md me mf mg mh mk ml mm mn mo mp mq mr ms mt mu mv mw mx my mz na nc ne nf ng ni nl no np nr nu nz om pa pe pf pg ph pk pl pm pn pr ps pt pw py qa re ro rs ru rw sa sb sc sd se sg sh si sj sk sl sm sn so sr st su sv sy sz tc td tf tg th tj tk tl tm tn to tp tr tt tv tw tz ua ug uk um us uy uz va vc ve vg vi vn vu wf ws ye yt yu za zm zw".split(" ")));
    private static final Set<String> gTLDs = new HashSet<String>(Arrays.asList("aero arpa asia biz cat com coop edu gov info int jobs mil mobi museum name net org pro tel".split(" ")));
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");

    public static String getPLD(String hostname) {
        if (hostname.startsWith("[") && hostname.endsWith("]")) {
            return hostname;
        }
        String[] subNames = hostname.split("\\.");
        int numPieces = subNames.length;
        if (numPieces <= 2) {
            return hostname;
        }
        if (numPieces == 4 && IPV4_ADDRESS_PATTERN.matcher(hostname).matches()) {
            return hostname;
        }
        int firstHostPiece = 0;
        if (ccTLDs.contains(subNames[numPieces - 1].toLowerCase())) {
            firstHostPiece = subNames[numPieces - 2].length() <= 2 ? numPieces - 3 : (gTLDs.contains(subNames[numPieces - 2].toLowerCase()) ? numPieces - 3 : numPieces - 2);
        } else if (gTLDs.contains(subNames[numPieces - 1].toLowerCase())) {
            firstHostPiece = ccTLDs.contains(subNames[numPieces - 2].toLowerCase()) ? numPieces - 3 : numPieces - 2;
        } else {
            LOGGER.debug("Unknown format for hostname: " + hostname);
        }
        if (firstHostPiece == 0) {
            return hostname;
        }
        StringBuilder result = new StringBuilder();
        for (int i = firstHostPiece; i < numPieces; ++i) {
            result.append(subNames[i]);
            result.append('.');
        }
        return result.deleteCharAt(result.length() - 1).toString();
    }

    public static String getPLD(URL url) {
        return PaidLevelDomain.getPLD(url.getHost());
    }
}

