/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.security.DHPubKey;
import org.xbill.DNS.security.DSAPubKey;
import org.xbill.DNS.security.RSAPubKey;

public class KEYConverter {
    private static final BigInteger DHPRIME768 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger DHPRIME1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger TWO = new BigInteger("2", 16);

    static int BigIntegerLength(BigInteger i) {
        byte[] b = i.toByteArray();
        return b[0] == 0 ? b.length - 1 : b.length;
    }

    static BigInteger readBigInteger(DataInputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        int n = in.read(b);
        if (n < len) {
            throw new IOException("end of input");
        }
        return new BigInteger(1, b);
    }

    static void writeBigInteger(ByteArrayOutputStream out, BigInteger val) {
        byte[] b = val.toByteArray();
        if (b[0] == 0) {
            out.write(b, 1, b.length - 1);
        } else {
            out.write(b, 0, b.length);
        }
    }

    static void writeShort(ByteArrayOutputStream out, int i) {
        out.write(i >> 8 & 0xFF);
        out.write(i & 0xFF);
    }

    static RSAPublicKey parseRSA(DataInputStream in) throws IOException {
        int exponentLength = in.readUnsignedByte();
        if (exponentLength == 0) {
            exponentLength = in.readUnsignedShort();
        }
        BigInteger exponent = KEYConverter.readBigInteger(in, exponentLength);
        int modulusLength = in.available();
        BigInteger modulus = KEYConverter.readBigInteger(in, modulusLength);
        RSAPubKey rsa = new RSAPubKey(modulus, exponent);
        return rsa;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DHPublicKey parseDH(DataInputStream in) throws IOException {
        BigInteger g;
        BigInteger p;
        int special = 0;
        int pLength = in.readUnsignedShort();
        if (pLength < 16 && pLength != 1 && pLength != 2) {
            return null;
        }
        if (pLength == 1 || pLength == 2) {
            special = pLength == 1 ? in.readUnsignedByte() : in.readUnsignedShort();
            if (special != 1 && special != 2) {
                return null;
            }
            p = special == 1 ? DHPRIME768 : DHPRIME1024;
        } else {
            p = KEYConverter.readBigInteger(in, pLength);
        }
        int gLength = in.readUnsignedShort();
        if (gLength == 0) {
            if (special == 0) return null;
            g = TWO;
        } else {
            g = KEYConverter.readBigInteger(in, gLength);
        }
        int yLength = in.readUnsignedShort();
        BigInteger y = KEYConverter.readBigInteger(in, yLength);
        return new DHPubKey(p, g, y);
    }

    static DSAPublicKey parseDSA(DataInputStream in) throws IOException {
        byte t = in.readByte();
        BigInteger q = KEYConverter.readBigInteger(in, 20);
        BigInteger p = KEYConverter.readBigInteger(in, 64 + t * 8);
        BigInteger g = KEYConverter.readBigInteger(in, 64 + t * 8);
        BigInteger y = KEYConverter.readBigInteger(in, 64 + t * 8);
        DSAPubKey dsa = new DSAPubKey(p, q, g, y);
        return dsa;
    }

    static PublicKey parseRecord(int alg, byte[] data) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(bytes);
        try {
            switch (alg) {
                case 1: 
                case 5: {
                    return KEYConverter.parseRSA(in);
                }
                case 2: {
                    return KEYConverter.parseDH(in);
                }
                case 3: {
                    return KEYConverter.parseDSA(in);
                }
            }
            return null;
        }
        catch (IOException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println(e);
            }
            return null;
        }
    }

    public static PublicKey parseRecord(DNSKEYRecord r) {
        int alg = r.getAlgorithm();
        byte[] data = r.getKey();
        return KEYConverter.parseRecord(alg, data);
    }

    public static PublicKey parseRecord(KEYRecord r) {
        int alg = r.getAlgorithm();
        byte[] data = r.getKey();
        return KEYConverter.parseRecord(alg, data);
    }

    static byte[] buildRSA(RSAPublicKey key) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BigInteger exponent = key.getPublicExponent();
        BigInteger modulus = key.getModulus();
        int exponentLength = KEYConverter.BigIntegerLength(exponent);
        if (exponentLength < 256) {
            out.write(exponentLength);
        } else {
            out.write(0);
            KEYConverter.writeShort(out, exponentLength);
        }
        KEYConverter.writeBigInteger(out, exponent);
        KEYConverter.writeBigInteger(out, modulus);
        return out.toByteArray();
    }

    static byte[] buildDH(DHPublicKey key) {
        int gLength;
        int pLength;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BigInteger p = key.getParams().getP();
        BigInteger g = key.getParams().getG();
        BigInteger y = key.getY();
        if (g.equals(TWO) && (p.equals(DHPRIME768) || p.equals(DHPRIME1024))) {
            pLength = 1;
            gLength = 0;
        } else {
            pLength = KEYConverter.BigIntegerLength(p);
            gLength = KEYConverter.BigIntegerLength(g);
        }
        int yLength = KEYConverter.BigIntegerLength(y);
        KEYConverter.writeShort(out, pLength);
        if (pLength == 1) {
            if (p.bitLength() == 768) {
                out.write(1);
            } else {
                out.write(2);
            }
        } else {
            KEYConverter.writeBigInteger(out, p);
        }
        KEYConverter.writeShort(out, gLength);
        if (gLength > 0) {
            KEYConverter.writeBigInteger(out, g);
        }
        KEYConverter.writeShort(out, yLength);
        KEYConverter.writeBigInteger(out, y);
        return out.toByteArray();
    }

    static byte[] buildDSA(DSAPublicKey key) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BigInteger q = key.getParams().getQ();
        BigInteger p = key.getParams().getP();
        BigInteger g = key.getParams().getG();
        BigInteger y = key.getY();
        int t = (p.toByteArray().length - 64) / 8;
        out.write(t);
        KEYConverter.writeBigInteger(out, q);
        KEYConverter.writeBigInteger(out, p);
        KEYConverter.writeBigInteger(out, g);
        KEYConverter.writeBigInteger(out, y);
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static KEYRecord buildRecord(Name name, int dclass, long ttl, int flags, int proto, PublicKey key) {
        void var7_6;
        int alg;
        if (key instanceof RSAPublicKey) {
            alg = 1;
        } else if (key instanceof DHPublicKey) {
            alg = 2;
        } else if (key instanceof DSAPublicKey) {
            alg = 3;
        } else {
            return null;
        }
        return (KEYRecord)KEYConverter.buildRecord(name, 25, dclass, ttl, flags, proto, (int)var7_6, key);
    }

    /*
     * WARNING - void declaration
     */
    public static Record buildRecord(Name name, int type, int dclass, long ttl, int flags, int proto, int alg, PublicKey key) {
        void var9_8;
        byte[] data;
        if (type != 25 && type != 48) {
            throw new IllegalArgumentException("type must be KEY or DNSKEY");
        }
        if (key instanceof RSAPublicKey) {
            data = KEYConverter.buildRSA((RSAPublicKey)key);
        } else if (key instanceof DHPublicKey) {
            data = KEYConverter.buildDH((DHPublicKey)key);
        } else if (key instanceof DSAPublicKey) {
            data = KEYConverter.buildDSA((DSAPublicKey)key);
        } else {
            return null;
        }
        if (var9_8 == null) {
            return null;
        }
        if (type == 48) {
            return new DNSKEYRecord(name, dclass, ttl, flags, proto, alg, (byte[])var9_8);
        }
        return new KEYRecord(name, dclass, ttl, flags, proto, alg, (byte[])var9_8);
    }
}

