/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.metadata;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;

public class MetadataIndexer
implements IndexingFilter {
    private Configuration conf;
    private HashMap<String, String[]> staticfields;
    private static String[] dbFieldnames;
    private static String[] parseFieldnames;
    private static String[] contentFieldnames;
    private static final String db_CONF_PROPERTY = "index.db.md";
    private static final String parse_CONF_PROPERTY = "index.parse.md";
    private static final String content_CONF_PROPERTY = "index.content.md";

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        if (doc == null) {
            return doc;
        }
        if (dbFieldnames != null) {
            for (String metatag : dbFieldnames) {
                Text metadata = (Text)datum.getMetaData().get((Object)new Text(metatag));
                if (metadata == null) continue;
                doc.add(metatag, (Object)metadata.toString());
            }
        }
        if (parseFieldnames != null) {
            for (String metatag : parseFieldnames) {
                for (String value : parse.getData().getParseMeta().getValues(metatag)) {
                    if (value == null) continue;
                    doc.add(metatag, (Object)value);
                }
            }
        }
        if (contentFieldnames != null) {
            for (String metatag : contentFieldnames) {
                for (String value : parse.getData().getContentMeta().getValues(metatag)) {
                    if (value == null) continue;
                    doc.add(metatag, (Object)value);
                }
            }
        }
        return doc;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        dbFieldnames = conf.getStrings(db_CONF_PROPERTY);
        parseFieldnames = conf.getStrings(parse_CONF_PROPERTY);
        contentFieldnames = conf.getStrings(content_CONF_PROPERTY);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

