/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.LeaseRenewer;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.StringUtils;
import sun.net.util.IPAddressUtil;

public class DFSClient
implements FSConstants,
Closeable {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public static final int MAX_BLOCK_ACQUIRE_FAILURES = 3;
    private static final int TCP_WINDOW_SIZE = 131072;
    public final ClientProtocol namenode;
    final ClientProtocol rpcNamenode;
    private final InetSocketAddress nnAddress;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    static Random r = new Random();
    final String clientName;
    private Configuration conf;
    private long defaultBlockSize;
    private short defaultReplication;
    private SocketFactory socketFactory;
    private int socketTimeout;
    private int datanodeWriteTimeout;
    private int timeoutValue;
    final int writePacketSize;
    private final FileSystem.Statistics stats;
    private int maxBlockAcquireFailures;
    private boolean shortCircuitLocalReads;
    private boolean connectToDnViaHostname;
    private SocketAddress[] localInterfaceAddrs;
    private volatile boolean serverSupportsHdfs630 = true;
    private volatile boolean serverSupportsHdfs200 = true;
    final int hdfsTimeout;
    private final String authority;
    private final Map<String, DFSOutputStream> filesBeingWritten = new HashMap<String, DFSOutputStream>();
    private static Map<String, Boolean> localAddrMap = Collections.synchronizedMap(new HashMap());

    public static ClientProtocol createNamenode(Configuration conf) throws IOException {
        return DFSClient.createNamenode(NameNode.getAddress(conf), conf);
    }

    public static ClientProtocol createNamenode(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        return DFSClient.createNamenode(DFSClient.createRPCNamenode(nameNodeAddr, conf, UserGroupInformation.getCurrentUser()), conf);
    }

    private static ClientProtocol createRPCNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, 61L, nameNodeAddr, ugi, conf, NetUtils.getSocketFactory(conf, ClientProtocol.class), 0, RetryUtils.getMultipleLinearRandomRetry(conf, "dfs.client.retry.policy.enabled", false, "dfs.client.retry.policy.spec", "10000,6,60000,10"), false);
    }

    private static ClientProtocol createNamenode(ClientProtocol rpcNamenode, Configuration conf) throws IOException {
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy(conf, "dfs.client.retry.policy.enabled", false, "dfs.client.retry.policy.spec", "10000,6,60000,10", SafeModeException.class);
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(5, 60000L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException(defaultPolicy, remoteExceptionToPolicyMap));
        RetryPolicy methodPolicy = RetryPolicies.retryByException(defaultPolicy, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("create", methodPolicy);
        ClientProtocol cp = (ClientProtocol)RetryProxy.create(ClientProtocol.class, rpcNamenode, defaultPolicy, methodNameToPolicyMap);
        RPC.checkVersion(ClientProtocol.class, 61L, cp);
        return cp;
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeInfo di, Configuration conf, Block block, Token<BlockTokenIdentifier> token, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnName = di.getNameWithIpcPort(connectToDnViaHostname);
        LOG.debug((Object)("Connecting to " + dnName));
        InetSocketAddress addr = NetUtils.createSocketAddr(dnName);
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser(block.toString());
        ticket.addToken(token);
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, 4L, addr, ticket, conf, NetUtils.getDefaultSocketFactory(conf), socketTimeout);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeInfo di, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnName = di.getNameWithIpcPort(connectToDnViaHostname);
        LOG.debug((Object)("Connecting to " + dnName));
        InetSocketAddress addr = NetUtils.createSocketAddr(dnName);
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        return (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, 4L, addr, conf, NetUtils.getDefaultSocketFactory(conf), socketTimeout);
    }

    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        this(nameNodeAddr, conf, null);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeAddr, null, conf, stats);
    }

    DFSClient(InetSocketAddress nameNodeAddr, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        String[] localInterfaces;
        this.conf = conf;
        this.stats = stats;
        this.nnAddress = nameNodeAddr;
        this.socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
        this.datanodeWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.timeoutValue = this.socketTimeout;
        this.socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
        this.writePacketSize = conf.getInt("dfs.write.packet.size", 65536);
        this.maxBlockAcquireFailures = DFSClient.getMaxBlockAcquireFailures(conf);
        this.hdfsTimeout = Client.getTimeout(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.authority = nameNodeAddr == null ? "null" : nameNodeAddr.getHostName() + ":" + nameNodeAddr.getPort();
        String taskId = conf.get("mapred.task.id", "NONMAPREDUCE");
        this.clientName = "DFSClient_" + taskId + "_" + r.nextInt() + "_" + Thread.currentThread().getId();
        this.defaultBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        if (nameNodeAddr != null && rpcNamenode == null) {
            this.rpcNamenode = DFSClient.createRPCNamenode(nameNodeAddr, conf, this.ugi);
            this.namenode = DFSClient.createNamenode(this.rpcNamenode, conf);
        } else if (nameNodeAddr == null && rpcNamenode != null) {
            this.namenode = this.rpcNamenode = rpcNamenode;
        } else {
            throw new IllegalArgumentException("Expecting exactly one of nameNodeAddr and rpcNamenode being null: nameNodeAddr=" + nameNodeAddr + ", rpcNamenode=" + rpcNamenode);
        }
        this.shortCircuitLocalReads = conf.getBoolean("dfs.client.read.shortcircuit", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Short circuit read is " + this.shortCircuitLocalReads));
        }
        this.connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connect to datanode via hostname is " + this.connectToDnViaHostname));
        }
        if (null == (localInterfaces = conf.getStrings("dfs.client.local.interfaces"))) {
            localInterfaces = new String[]{};
        }
        this.localInterfaceAddrs = DFSClient.getLocalInterfaceAddrs(localInterfaces);
        if (LOG.isDebugEnabled() && 0 != localInterfaces.length) {
            LOG.debug((Object)("Using local interfaces [" + StringUtils.join((CharSequence)",", localInterfaces) + "] with addresses [" + StringUtils.join((CharSequence)",", this.localInterfaceAddrs) + "]"));
        }
    }

    static int getMaxBlockAcquireFailures(Configuration conf) {
        return conf.getInt("dfs.client.max.block.acquire.failures", 3);
    }

    private void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    public synchronized LeaseRenewer getLeaseRenewer() throws IOException {
        return LeaseRenewer.getInstance(this.authority, this.ugi, this);
    }

    private void beginFileLease(String src, DFSOutputStream out) throws IOException {
        this.getLeaseRenewer().put(src, out, this);
    }

    void endFileLease(String src) throws IOException {
        this.getLeaseRenewer().closeFile(src, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFileBeingWritten(String src, DFSOutputStream out) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(src, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBeingWritten(String src) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFilesBeingWrittenEmpty() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.isEmpty();
        }
    }

    boolean renewLease() throws IOException {
        if (this.clientRunning && !this.isFilesBeingWrittenEmpty()) {
            this.namenode.renewLease(this.clientName);
            return true;
        }
        return false;
    }

    void abort() {
        this.clientRunning = false;
        this.closeAllFilesBeingWritten(true);
        try {
            this.getLeaseRenewer().closeClient(this);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Exception occurred while aborting the client. " + ioe));
        }
        RPC.stopProxy(this.rpcNamenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllFilesBeingWritten(boolean abort) {
        while (true) {
            DFSOutputStream out;
            String src;
            Map<String, DFSOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    return;
                }
                src = this.filesBeingWritten.keySet().iterator().next();
                out = this.filesBeingWritten.remove(src);
            }
            if (out == null) continue;
            try {
                if (abort) {
                    out.abort();
                    continue;
                }
                out.close();
                continue;
            }
            catch (IOException ie) {
                LOG.error((Object)("Failed to " + (abort ? "abort" : "close") + " file " + src), (Throwable)ie);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(false);
            this.clientRunning = false;
            this.getLeaseRenewer().closeClient(this);
            RPC.stopProxy(this.rpcNamenode);
        }
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getBlockSize(String f) throws IOException {
        try {
            return this.namenode.getPreferredBlockSize(f);
        }
        catch (IOException ie) {
            LOG.warn((Object)("Problem getting block size: " + StringUtils.stringifyException(ie)));
            throw ie;
        }
    }

    public static String stringifyToken(Token<DelegationTokenIdentifier> token) throws IOException {
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        ident.readFields(in);
        String str = ident.getKind() + " token " + ident.getSequenceNumber() + " for " + ident.getUser().getShortUserName();
        if (token.getService().getLength() > 0) {
            return str + " on " + token.getService();
        }
        return str;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.namenode.getDelegationToken(renewer);
        SecurityUtil.setTokenService(result, this.nnAddress);
        LOG.info((Object)("Created " + DFSClient.stringifyToken(result)));
        return result;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            return token.renew(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    private BlockReader getLocalBlockReader(Configuration conf, String src, Block blk, Token<BlockTokenIdentifier> accessToken, DatanodeInfo chosenNode, int socketTimeout, long offsetIntoBlock) throws SecretManager.InvalidToken, IOException {
        try {
            return BlockReaderLocal.newBlockReader(conf, src, blk, accessToken, chosenNode, socketTimeout, offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.connectToDnViaHostname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    private static boolean isLocalAddress(InetSocketAddress targetAddr) {
        boolean local;
        InetAddress addr = targetAddr.getAddress();
        Boolean cached = localAddrMap.get(addr.getHostAddress());
        if (cached != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Address " + targetAddr + (cached != false ? " is local" : " is not local")));
            }
            return cached;
        }
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Address " + targetAddr + (local ? " is local" : " is not local")));
        }
        localAddrMap.put(addr.getHostAddress(), local);
        return local;
    }

    private static boolean tokenRefetchNeeded(IOException ex, InetSocketAddress targetAddr) {
        if (ex instanceof InvalidBlockTokenException || ex instanceof SecretManager.InvalidToken) {
            LOG.info((Object)("Access token was invalid when connecting to " + targetAddr + " : " + ex));
            return true;
        }
        return false;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            LOG.info((Object)("Cancelling " + DFSClient.stringifyToken(token)));
            this.namenode.cancelDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    @Deprecated
    public String[][] getHints(String src, long start, long length) throws IOException {
        BlockLocation[] blkLocations = this.getBlockLocations(src, start, length);
        if (blkLocations == null || blkLocations.length == 0) {
            return new String[0][];
        }
        int blkCount = blkLocations.length;
        String[][] hints = new String[blkCount][];
        for (int i = 0; i < blkCount; ++i) {
            String[] hosts = blkLocations[i].getHosts();
            hints[i] = new String[hosts.length];
            hints[i] = hosts;
        }
        return hints;
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException {
        LocatedBlocks blocks = DFSClient.callGetBlockLocations(this.namenode, src, start, length);
        return DFSUtil.locatedBlocks2Locations(blocks);
    }

    public DFSInputStream open(String src) throws IOException {
        return this.open(src, this.conf.getInt("io.file.buffer.size", 4096), true, null);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException {
        this.checkOpen();
        return new DFSInputStream(src, buffersize, verifyChecksum);
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.conf.getInt("io.file.buffer.size", 4096));
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getDefault(), overwrite, replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, permission, overwrite, true, replication, blockSize, progress, buffersize);
    }

    public OutputStream create(String src, FsPermission permission, boolean overwrite, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        DFSOutputStream result = new DFSOutputStream(src, masked, overwrite, createParent, replication, blockSize, progress, buffersize, this.conf.getInt("io.bytes.per.checksum", 512));
        this.beginFileLease(src, result);
        return result;
    }

    boolean recoverLease(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.recoverLease(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class);
        }
    }

    public boolean isFileClosed(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.isFileClosed(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public FSDataOutputStream append(String src, int buffersize, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, progress);
        return new FSDataOutputStream(out, statistics, out.getInitialLen());
    }

    private DFSOutputStream append(String src, int buffersize, Progressable progress) throws IOException {
        this.checkOpen();
        HdfsFileStatus stat = null;
        LocatedBlock lastBlock = null;
        try {
            stat = this.getFileInfo(src);
            lastBlock = this.namenode.append(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
        DFSOutputStream result = new DFSOutputStream(src, buffersize, progress, lastBlock, stat, this.conf.getInt("io.bytes.per.checksum", 512));
        this.beginFileLease(src, result);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.namenode.setReplication(src, replication);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    public void concat(String trg, String[] srcs) throws IOException {
        this.checkOpen();
        try {
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.rename(src, dst);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.namenode.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.delete(src, recursive);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    @Deprecated
    public boolean isDirectory(String src) throws IOException {
        HdfsFileStatus fs = this.getFileInfo(src);
        if (fs != null) {
            return fs.isDir();
        }
        throw new FileNotFoundException("File does not exist: " + src);
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getListing(src, startAfter);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    private static SocketAddress[] getLocalInterfaceAddrs(String[] interfaceNames) throws UnknownHostException {
        ArrayList<InetSocketAddress> localAddrs = new ArrayList<InetSocketAddress>();
        for (String interfaceName : interfaceNames) {
            if (IPAddressUtil.isIPv4LiteralAddress(interfaceName)) {
                localAddrs.add(new InetSocketAddress(interfaceName, 0));
                continue;
            }
            if (NetUtils.isValidSubnet(interfaceName)) {
                for (InetAddress addr : NetUtils.getIPs(interfaceName, false)) {
                    localAddrs.add(new InetSocketAddress(addr, 0));
                }
                continue;
            }
            for (String ip : DNS.getIPs(interfaceName, false)) {
                localAddrs.add(new InetSocketAddress(ip, 0));
            }
        }
        return localAddrs.toArray(new SocketAddress[localAddrs.size()]);
    }

    private SocketAddress getRandomLocalInterfaceAddr() {
        if (this.localInterfaceAddrs.length == 0) {
            return null;
        }
        int idx = r.nextInt(this.localInterfaceAddrs.length);
        SocketAddress addr = this.localInterfaceAddrs[idx];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using local interface " + addr));
        }
        return addr;
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(String src) throws IOException {
        this.checkOpen();
        return DFSClient.getFileChecksum(src, this.namenode, this.socketFactory, this.socketTimeout, this.connectToDnViaHostname);
    }

    public static MD5MD5CRC32FileChecksum getFileChecksum(String src, ClientProtocol namenode, SocketFactory socketFactory, int socketTimeout) throws IOException {
        return DFSClient.getFileChecksum(src, namenode, socketFactory, socketTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MD5MD5CRC32FileChecksum getFileChecksum(String src, ClientProtocol namenode, SocketFactory socketFactory, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        LocatedBlocks blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, Long.MAX_VALUE);
        if (null == blockLocations) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        List<LocatedBlock> locatedblocks = blockLocations.getLocatedBlocks();
        DataOutputBuffer md5out = new DataOutputBuffer();
        int bytesPerCRC = 0;
        long crcPerBlock = 0L;
        boolean refetchBlocks = false;
        int lastRetriedIndex = -1;
        int i = 0;
        while (true) {
            if (i >= locatedblocks.size()) {
                MD5Hash fileMD5 = MD5Hash.digest(md5out.getData());
                return new MD5MD5CRC32FileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
            }
            if (refetchBlocks) {
                blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, Long.MAX_VALUE);
                if (null == blockLocations) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                locatedblocks = blockLocations.getLocatedBlocks();
                refetchBlocks = false;
            }
            LocatedBlock lb = locatedblocks.get(i);
            Block block = lb.getBlock();
            DatanodeInfo[] datanodes = lb.getLocations();
            int timeout = socketTimeout > 0 ? socketTimeout + 3000 * datanodes.length : 0;
            boolean done = false;
            for (int j = 0; !done && j < datanodes.length; ++j) {
                DataInputStream in;
                DataOutputStream out;
                Socket sock;
                block22: {
                    String dnName = datanodes[j].getName(connectToDnViaHostname);
                    sock = null;
                    out = null;
                    in = null;
                    try {
                        sock = socketFactory.createSocket();
                        LOG.debug((Object)("Connecting to " + dnName));
                        NetUtils.connect(sock, NetUtils.createSocketAddr(dnName), timeout);
                        sock.setSoTimeout(timeout);
                        out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(sock), DataNode.SMALL_BUFFER_SIZE));
                        in = new DataInputStream(NetUtils.getInputStream(sock));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("write to " + dnName + ": " + 85 + ", block=" + block));
                        }
                        out.writeShort(17);
                        out.write(85);
                        out.writeLong(block.getBlockId());
                        out.writeLong(block.getGenerationStamp());
                        lb.getBlockToken().write(out);
                        out.flush();
                        short reply = in.readShort();
                        if (reply != 0) {
                            if (reply != 5) throw new IOException("Bad response " + reply + " for block " + block + " from datanode " + dnName);
                            if (i <= lastRetriedIndex) throw new IOException("Bad response " + reply + " for block " + block + " from datanode " + dnName);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Got access token error in response to OP_BLOCK_CHECKSUM for file " + src + " for block " + block + " from datanode " + dnName + ". Will retry the block once."));
                            }
                            lastRetriedIndex = i--;
                            done = true;
                            refetchBlocks = true;
                            IOUtils.closeStream(in);
                            break block22;
                        }
                        int bpc = in.readInt();
                        if (i == 0) {
                            bytesPerCRC = bpc;
                        } else if (bpc != bytesPerCRC) {
                            throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + bytesPerCRC);
                        }
                        long cpb = in.readLong();
                        if (locatedblocks.size() > 1 && i == 0) {
                            crcPerBlock = cpb;
                        }
                        MD5Hash md5 = MD5Hash.read(in);
                        md5.write(md5out);
                        done = true;
                        if (LOG.isDebugEnabled()) {
                            if (i == 0) {
                                LOG.debug((Object)("set bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock));
                            }
                            LOG.debug((Object)("got reply from " + dnName + ": md5=" + md5));
                        }
                        IOUtils.closeStream(in);
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("src=" + src + ", datanodes[" + j + "]=" + dnName), (Throwable)ie);
                        continue;
                    }
                }
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
                break;
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
                continue;
                finally {
                    IOUtils.closeStream(in);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket(sock);
                }
            }
            if (!done) {
                throw new IOException("Fail to get block MD5 for " + block);
            }
            ++i;
        }
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public DistributedFileSystem.DiskStatus getDiskStatus() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return new DistributedFileSystem.DiskStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long totalRawCapacity() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[0];
    }

    public long totalRawUsed() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[1];
    }

    public long getMissingBlocksCount() throws IOException {
        return this.namenode.getStats()[5];
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.namenode.getStats()[3];
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.namenode.getStats()[4];
    }

    public DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        return this.namenode.getDatanodeReport(type);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namenode.setSafeMode(action);
    }

    void saveNamespace() throws AccessControlException, IOException {
        try {
            this.namenode.saveNamespace();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namenode.setBalancerBandwidth(bandwidth);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namenode.distributedUpgradeProgress(action);
    }

    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null);
    }

    public boolean mkdirs(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        try {
            return this.namenode.mkdirs(src, masked);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        try {
            return this.namenode.getContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    void setQuota(String src, long namespaceQuota, long diskspaceQuota) throws IOException {
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || diskspaceQuota <= 0L && diskspaceQuota != Long.MAX_VALUE && diskspaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + diskspaceQuota);
        }
        try {
            this.namenode.setQuota(src, namespaceQuota, diskspaceQuota);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    private DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    void reportChecksumFailure(String file, Block blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ".  Error repairing corrupt blocks.  Bad blocks remain. " + StringUtils.stringifyException(ie)));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    static /* synthetic */ long access$100(DFSClient x0) {
        return x0.defaultBlockSize;
    }

    class DFSOutputStream
    extends FSOutputSummer
    implements Syncable {
        private Socket s;
        boolean closed;
        private String src;
        private DataOutputStream blockStream;
        private DataInputStream blockReplyStream;
        private Block block;
        private Token<BlockTokenIdentifier> accessToken;
        private final long blockSize;
        private DataChecksum checksum;
        private LinkedList<Packet> dataQueue;
        private LinkedList<Packet> ackQueue;
        private Packet currentPacket;
        private int maxPackets;
        private DataStreamer streamer;
        private ResponseProcessor response;
        private long currentSeqno;
        private long lastQueuedSeqno;
        private long lastAckedSeqno;
        private long bytesCurBlock;
        private int packetSize;
        private int chunksPerPacket;
        private DatanodeInfo[] nodes;
        private ArrayList<DatanodeInfo> excludedNodes;
        private volatile boolean hasError;
        private volatile int errorIndex;
        private volatile IOException lastException;
        private long artificialSlowdown;
        private long lastFlushOffset;
        private boolean persistBlocks;
        private int recoveryErrorCount;
        private int maxRecoveryErrorCount;
        private volatile boolean appendChunk;
        private long initialFileSize;
        private Progressable progress;
        private short blockReplication;

        Token<BlockTokenIdentifier> getAccessToken() {
            return this.accessToken;
        }

        private void setLastException(IOException e) {
            if (this.lastException == null) {
                this.lastException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processDatanodeError(boolean hasError, boolean isAppend) {
            if (!hasError) {
                return false;
            }
            if (this.response != null) {
                LOG.info((Object)("Error Recovery for " + this.block + " waiting for responder to exit. "));
                return true;
            }
            if (this.errorIndex >= 0) {
                LOG.warn((Object)("Error Recovery for " + this.block + " bad datanode[" + this.errorIndex + "] " + (this.nodes == null ? "nodes == null" : this.nodes[this.errorIndex].getName())));
            }
            if (this.blockStream != null) {
                IOUtils.cleanup(LOG, this.blockStream, this.blockReplyStream);
            }
            this.blockStream = null;
            this.blockReplyStream = null;
            LinkedList<Packet> linkedList = this.ackQueue;
            synchronized (linkedList) {
                this.dataQueue.addAll(0, this.ackQueue);
                this.ackQueue.clear();
            }
            boolean success = false;
            while (!success && DFSClient.this.clientRunning) {
                DatanodeInfo[] newnodes = null;
                if (this.nodes == null) {
                    String msg = "Could not get block locations. Source file \"" + this.src + "\" - Aborting...";
                    LOG.warn((Object)msg);
                    this.setLastException(new IOException(msg));
                    this.closed = true;
                    if (this.streamer != null) {
                        this.streamer.close();
                    }
                    return false;
                }
                StringBuilder pipelineMsg = new StringBuilder();
                for (int j = 0; j < this.nodes.length; ++j) {
                    pipelineMsg.append(this.nodes[j].getName());
                    if (j >= this.nodes.length - 1) continue;
                    pipelineMsg.append(", ");
                }
                if (this.errorIndex < 0) {
                    newnodes = this.nodes;
                } else {
                    if (this.nodes.length <= 1) {
                        this.lastException = new IOException("All datanodes " + pipelineMsg + " are bad. Aborting...");
                        this.closed = true;
                        if (this.streamer != null) {
                            this.streamer.close();
                        }
                        return false;
                    }
                    LOG.warn((Object)("Error Recovery for block " + this.block + " in pipeline " + pipelineMsg + ": bad datanode " + this.nodes[this.errorIndex].getName()));
                    newnodes = new DatanodeInfo[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, this.errorIndex);
                    System.arraycopy(this.nodes, this.errorIndex + 1, newnodes, this.errorIndex, newnodes.length - this.errorIndex);
                }
                LocatedBlock newBlock = null;
                ClientDatanodeProtocol primary = null;
                DatanodeInfo primaryNode = null;
                try {
                    primaryNode = Collections.min(Arrays.asList(newnodes));
                    int recoveryTimeout = (newnodes.length * 2 + 2) * DFSClient.this.socketTimeout;
                    primary = DFSClient.createClientDatanodeProtocolProxy(primaryNode, DFSClient.this.conf, this.block, this.accessToken, recoveryTimeout, DFSClient.this.connectToDnViaHostname);
                    newBlock = primary.recoverBlock(this.block, isAppend, newnodes);
                }
                catch (IOException e) {
                    block23: {
                        block24: {
                            boolean j;
                            try {
                                LOG.warn((Object)("Failed recovery attempt #" + this.recoveryErrorCount + " from primary datanode " + primaryNode), (Throwable)e);
                                ++this.recoveryErrorCount;
                                if (this.recoveryErrorCount <= this.maxRecoveryErrorCount) break block23;
                                if (this.nodes.length <= 1) break block24;
                                for (j = false; j < this.nodes.length; j += 1) {
                                    if (!this.nodes[j].equals(primaryNode)) continue;
                                    this.errorIndex = j;
                                }
                                newnodes = new DatanodeInfo[this.nodes.length - 1];
                                System.arraycopy(this.nodes, 0, newnodes, 0, this.errorIndex);
                                System.arraycopy(this.nodes, this.errorIndex + 1, newnodes, this.errorIndex, newnodes.length - this.errorIndex);
                                this.nodes = newnodes;
                                LOG.warn((Object)("Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Marking primary datanode as bad."));
                                this.recoveryErrorCount = 0;
                                this.errorIndex = -1;
                                j = true;
                            }
                            catch (Throwable throwable) {
                                RPC.stopProxy(primary);
                                throw throwable;
                            }
                            RPC.stopProxy(primary);
                            return j;
                        }
                        String emsg = "Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Aborting...";
                        LOG.warn((Object)emsg);
                        this.lastException = new IOException(emsg);
                        this.closed = true;
                        if (this.streamer != null) {
                            this.streamer.close();
                        }
                        boolean bl = false;
                        RPC.stopProxy(primary);
                        return bl;
                    }
                    LOG.warn((Object)("Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + primaryNode + " failed " + this.recoveryErrorCount + " times. " + " Pipeline was " + pipelineMsg + ". Will retry..."));
                    boolean bl = true;
                    RPC.stopProxy(primary);
                    return bl;
                }
                RPC.stopProxy(primary);
                this.recoveryErrorCount = 0;
                this.block = newBlock.getBlock();
                this.accessToken = newBlock.getBlockToken();
                this.nodes = newBlock.getLocations();
                this.hasError = false;
                this.lastException = null;
                this.errorIndex = 0;
                success = this.createBlockOutputStream(this.nodes, DFSClient.this.clientName, true);
            }
            this.response = new ResponseProcessor(this.nodes);
            this.response.start();
            return false;
        }

        private void isClosed() throws IOException {
            if (this.closed && this.lastException != null) {
                throw this.lastException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DatanodeInfo[] getPipeline() {
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                if (this.nodes == null) {
                    return null;
                }
                DatanodeInfo[] value = new DatanodeInfo[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    value[i] = this.nodes[i];
                }
                return value;
            }
        }

        private DFSOutputStream(String src, long blockSize, Progressable progress, int bytesPerChecksum, short replication) throws IOException {
            super(new PureJavaCrc32(), bytesPerChecksum, 4);
            this.closed = false;
            this.dataQueue = new LinkedList();
            this.ackQueue = new LinkedList();
            this.currentPacket = null;
            this.maxPackets = 80;
            this.streamer = new DataStreamer();
            this.response = null;
            this.currentSeqno = 0L;
            this.lastQueuedSeqno = -1L;
            this.lastAckedSeqno = -1L;
            this.bytesCurBlock = 0L;
            this.packetSize = 0;
            this.chunksPerPacket = 0;
            this.nodes = null;
            this.excludedNodes = new ArrayList();
            this.hasError = false;
            this.errorIndex = 0;
            this.lastException = null;
            this.artificialSlowdown = 0L;
            this.lastFlushOffset = 0L;
            this.persistBlocks = false;
            this.recoveryErrorCount = 0;
            this.maxRecoveryErrorCount = 5;
            this.appendChunk = false;
            this.initialFileSize = 0L;
            this.src = src;
            this.blockSize = blockSize;
            this.blockReplication = replication;
            this.progress = progress;
            if (progress != null) {
                LOG.debug((Object)("Set non-null progress callback on DFSOutputStream " + src));
            }
            if (bytesPerChecksum < 1 || blockSize % (long)bytesPerChecksum != 0L) {
                throw new IOException("io.bytes.per.checksum(" + bytesPerChecksum + ") and blockSize(" + blockSize + ") do not match. " + "blockSize should be a " + "multiple of io.bytes.per.checksum");
            }
            this.checksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
        }

        DFSOutputStream(String src, FsPermission masked, boolean overwrite, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, int bytesPerChecksum) throws IOException {
            this(src, blockSize, progress, bytesPerChecksum, replication);
            this.computePacketChunkSize(dFSClient.writePacketSize, bytesPerChecksum);
            try {
                if (createParent) {
                    dFSClient.namenode.create(src, masked, dFSClient.clientName, overwrite, replication, blockSize);
                } else {
                    dFSClient.namenode.create(src, masked, dFSClient.clientName, overwrite, false, replication, blockSize);
                }
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, FileAlreadyExistsException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
            }
            this.streamer.start();
        }

        DFSOutputStream(String src, int buffersize, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, int bytesPerChecksum) throws IOException {
            this(src, stat.getBlockSize(), progress, bytesPerChecksum, stat.getReplication());
            this.initialFileSize = stat.getLen();
            if (lastBlock != null) {
                this.block = lastBlock.getBlock();
                this.accessToken = lastBlock.getBlockToken();
                long usedInLastBlock = stat.getLen() % this.blockSize;
                int freeInLastBlock = (int)(this.blockSize - usedInLastBlock);
                int usedInCksum = (int)(stat.getLen() % (long)bytesPerChecksum);
                int freeInCksum = bytesPerChecksum - usedInCksum;
                if ((long)freeInLastBlock > this.blockSize) {
                    throw new IOException("The last block for file " + src + " is full.");
                }
                this.bytesCurBlock = lastBlock.getBlockSize();
                if (usedInCksum > 0 && freeInCksum > 0) {
                    this.computePacketChunkSize(0, freeInCksum);
                    this.resetChecksumChunk(freeInCksum);
                    this.appendChunk = true;
                } else {
                    this.computePacketChunkSize(Math.min(dFSClient.writePacketSize, freeInLastBlock), bytesPerChecksum);
                }
                this.nodes = lastBlock.getLocations();
                this.errorIndex = -1;
                if (this.nodes.length < 1) {
                    throw new IOException("Unable to retrieve blocks locations for append to last block " + this.block + " of file " + src);
                }
                while (this.processDatanodeError(true, true)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.lastException != null) {
                    throw this.lastException;
                }
                this.streamer.start();
            } else {
                this.computePacketChunkSize(dFSClient.writePacketSize, bytesPerChecksum);
                this.streamer.start();
            }
        }

        private void computePacketChunkSize(int psize, int csize) {
            int chunkSize = csize + this.checksum.getChecksumSize();
            int n = 25;
            this.chunksPerPacket = Math.max((psize - n + chunkSize - 1) / chunkSize, 1);
            this.packetSize = n + chunkSize * this.chunksPerPacket;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("computePacketChunkSize: src=" + this.src + ", chunkSize=" + chunkSize + ", chunksPerPacket=" + this.chunksPerPacket + ", packetSize=" + this.packetSize));
            }
        }

        private DatanodeInfo[] nextBlockOutputStream() throws IOException {
            boolean success;
            DatanodeInfo[] nodes;
            LocatedBlock lb = null;
            boolean retry = false;
            int count = DFSClient.this.conf.getInt("dfs.client.block.write.retries", 3);
            do {
                this.hasError = false;
                this.lastException = null;
                this.errorIndex = 0;
                retry = false;
                nodes = null;
                success = false;
                long startTime = System.currentTimeMillis();
                DatanodeInfo[] excluded = this.excludedNodes.toArray(new DatanodeInfo[0]);
                lb = this.locateFollowingBlock(startTime, (DatanodeInfo[])(excluded.length > 0 ? excluded : null));
                this.block = lb.getBlock();
                this.accessToken = lb.getBlockToken();
                nodes = lb.getLocations();
                success = this.createBlockOutputStream(nodes, DFSClient.this.clientName, false);
                if (success) continue;
                LOG.info((Object)("Abandoning " + this.block));
                DFSClient.this.namenode.abandonBlock(this.block, this.src, DFSClient.this.clientName);
                if (this.errorIndex < nodes.length) {
                    LOG.info((Object)("Excluding datanode " + nodes[this.errorIndex]));
                    this.excludedNodes.add(nodes[this.errorIndex]);
                }
                retry = true;
            } while (retry && --count >= 0);
            if (!success) {
                throw new IOException("Unable to create new block.");
            }
            return nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createBlockOutputStream(DatanodeInfo[] nodes, String client, boolean recoveryFlag) {
            short pipelineStatus = 0;
            String firstBadLink = "";
            if (LOG.isDebugEnabled()) {
                for (int i = 0; i < nodes.length; ++i) {
                    LOG.debug((Object)("pipeline = " + nodes[i].getName()));
                }
            }
            this.persistBlocks = true;
            boolean result = false;
            try {
                String dnName = nodes[0].getName(DFSClient.this.connectToDnViaHostname);
                InetSocketAddress target = NetUtils.createSocketAddr(dnName);
                this.s = DFSClient.this.socketFactory.createSocket();
                DFSClient.this.timeoutValue = DFSClient.this.socketTimeout > 0 ? 3000 * nodes.length + DFSClient.this.socketTimeout : 0;
                LOG.debug((Object)("Connecting to " + dnName));
                NetUtils.connect(this.s, target, DFSClient.this.getRandomLocalInterfaceAddr(), DFSClient.this.timeoutValue);
                this.s.setSoTimeout(DFSClient.this.timeoutValue);
                this.s.setSendBufferSize(131072);
                LOG.debug((Object)("Send buf size " + this.s.getSendBufferSize()));
                long writeTimeout = DFSClient.this.datanodeWriteTimeout > 0 ? (long)(5000 * nodes.length + DFSClient.this.datanodeWriteTimeout) : 0L;
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.s, writeTimeout), DataNode.SMALL_BUFFER_SIZE));
                this.blockReplyStream = new DataInputStream(NetUtils.getInputStream(this.s));
                out.writeShort(17);
                out.write(80);
                out.writeLong(this.block.getBlockId());
                out.writeLong(this.block.getGenerationStamp());
                out.writeInt(nodes.length);
                out.writeBoolean(recoveryFlag);
                Text.writeString(out, client);
                out.writeBoolean(false);
                out.writeInt(nodes.length - 1);
                for (int i = 1; i < nodes.length; ++i) {
                    nodes[i].write(out);
                }
                this.accessToken.write(out);
                this.checksum.writeHeader(out);
                out.flush();
                pipelineStatus = this.blockReplyStream.readShort();
                firstBadLink = Text.readString(this.blockReplyStream);
                if (pipelineStatus != 0) {
                    if (pipelineStatus == 5) {
                        throw new InvalidBlockTokenException("Got access token error for connect ack with firstBadLink as " + firstBadLink);
                    }
                    throw new IOException("Bad connect ack with firstBadLink as " + firstBadLink);
                }
                this.blockStream = out;
                result = true;
            }
            catch (IOException ie) {
                LOG.info((Object)("Exception in createBlockOutputStream " + nodes[0].getName() + " " + ie));
                if (firstBadLink.length() != 0) {
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!nodes[i].getName().equals(firstBadLink)) continue;
                        this.errorIndex = i;
                        break;
                    }
                }
                this.hasError = true;
                this.setLastException(ie);
                this.blockReplyStream = null;
                result = false;
            }
            finally {
                if (!result) {
                    IOUtils.closeSocket(this.s);
                    this.s = null;
                }
            }
            return result;
        }

        private LocatedBlock locateFollowingBlock(long start, DatanodeInfo[] excludedNodes) throws IOException {
            int retries = DFSClient.this.conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
            long sleeptime = 400L;
            long localstart = System.currentTimeMillis();
            while (true) {
                try {
                    if (DFSClient.this.serverSupportsHdfs630) {
                        return DFSClient.this.namenode.addBlock(this.src, DFSClient.this.clientName, excludedNodes);
                    }
                    return DFSClient.this.namenode.addBlock(this.src, DFSClient.this.clientName);
                }
                catch (RemoteException e) {
                    IOException ue = e.unwrapRemoteException(FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
                    if (ue != e) {
                        throw ue;
                    }
                    if (e.getMessage().startsWith("java.io.IOException: java.lang.NoSuchMethodException: org.apache.hadoop.hdfs.protocol.ClientProtocol.addBlock(java.lang.String, java.lang.String, [Lorg.apache.hadoop.hdfs.protocol.DatanodeInfo;)")) {
                        DFSClient.this.serverSupportsHdfs630 = false;
                        continue;
                    }
                    if (NotReplicatedYetException.class.getName().equals(e.getClassName())) {
                        if (retries == 0) {
                            throw e;
                        }
                        --retries;
                        LOG.info((Object)StringUtils.stringifyException(e));
                        if (System.currentTimeMillis() - localstart > 5000L) {
                            LOG.info((Object)("Waiting for replication for " + (System.currentTimeMillis() - localstart) / 1000L + " seconds"));
                        }
                        try {
                            LOG.warn((Object)("NotReplicatedYetException sleeping " + this.src + " retries left " + retries));
                            Thread.sleep(sleeptime);
                            sleeptime *= 2L;
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum) throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            int cklen = checksum.length;
            int bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (len > bytesPerChecksum) {
                throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + bytesPerChecksum);
            }
            if (checksum.length != this.checksum.getChecksumSize()) {
                throw new IOException("writeChunk() checksum size is supposed to be " + this.checksum.getChecksumSize() + " but found to be " + checksum.length);
            }
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                while (!this.closed && this.dataQueue.size() + this.ackQueue.size() > this.maxPackets) {
                    try {
                        this.dataQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this.isClosed();
                if (this.currentPacket == null) {
                    this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("DFSClient writeChunk allocating new packet seqno=" + this.currentPacket.seqno + ", src=" + this.src + ", packetSize=" + this.packetSize + ", chunksPerPacket=" + this.chunksPerPacket + ", bytesCurBlock=" + this.bytesCurBlock));
                    }
                }
                this.currentPacket.writeChecksum(checksum, 0, cklen);
                this.currentPacket.writeData(b, offset, len);
                ++this.currentPacket.numChunks;
                this.bytesCurBlock += (long)len;
                if (this.currentPacket.numChunks == this.currentPacket.maxChunks || this.bytesCurBlock == this.blockSize) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("DFSClient writeChunk packet full seqno=" + this.currentPacket.seqno + ", src=" + this.src + ", bytesCurBlock=" + this.bytesCurBlock + ", blockSize=" + this.blockSize + ", appendChunk=" + this.appendChunk));
                    }
                    if (this.bytesCurBlock == this.blockSize) {
                        this.currentPacket.lastPacketInBlock = true;
                        this.bytesCurBlock = 0L;
                        this.lastFlushOffset = 0L;
                    }
                    this.enqueueCurrentPacket();
                    if (this.appendChunk) {
                        this.appendChunk = false;
                        this.resetChecksumChunk(bytesPerChecksum);
                    }
                    int psize = Math.min((int)(this.blockSize - this.bytesCurBlock), DFSClient.this.writePacketSize);
                    this.computePacketChunkSize(psize, bytesPerChecksum);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void enqueueCurrentPacket() {
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                if (this.currentPacket == null) {
                    return;
                }
                this.dataQueue.addLast(this.currentPacket);
                this.dataQueue.notifyAll();
                this.lastQueuedSeqno = this.currentPacket.seqno;
                this.currentPacket = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() throws IOException {
            block20: {
                DFSClient.this.checkOpen();
                if (this.closed) {
                    throw new IOException("DFSOutputStream is closed");
                }
                try {
                    boolean willPersist;
                    long toWaitFor;
                    DFSOutputStream dFSOutputStream = this;
                    synchronized (dFSOutputStream) {
                        long saveOffset = this.bytesCurBlock;
                        Packet oldCurrentPacket = this.currentPacket;
                        this.flushBuffer(true);
                        if (this.lastFlushOffset != this.bytesCurBlock) {
                            assert (this.bytesCurBlock > this.lastFlushOffset);
                            this.lastFlushOffset = this.bytesCurBlock;
                            this.enqueueCurrentPacket();
                        } else {
                            if (oldCurrentPacket == null && this.currentPacket != null) {
                                --this.currentSeqno;
                            }
                            this.currentPacket = null;
                        }
                        this.bytesCurBlock = saveOffset;
                        toWaitFor = this.lastQueuedSeqno;
                    }
                    this.waitForAckedSeqno(toWaitFor);
                    DFSOutputStream saveOffset = this;
                    synchronized (saveOffset) {
                        willPersist = this.persistBlocks && !this.closed;
                        this.persistBlocks = false;
                    }
                    if (!willPersist) break block20;
                    try {
                        DFSClient.this.namenode.fsync(this.src, DFSClient.this.clientName);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to persist blocks in hflush for " + this.src), (Throwable)ioe);
                        this.isClosed();
                        if (this.closed) {
                            throw new IOException("DFSOutputStream is closed");
                        }
                        throw ioe;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error while syncing", (Throwable)e);
                    DFSOutputStream dFSOutputStream = this;
                    synchronized (dFSOutputStream) {
                        if (!this.closed) {
                            this.lastException = new IOException("IOException flush:" + e);
                            this.closed = true;
                            this.closeThreads();
                        }
                    }
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumCurrentReplicas() throws IOException {
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                if (this.nodes == null) {
                    return this.blockReplication;
                }
                return this.nodes.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushInternal() throws IOException {
            long toWaitFor;
            this.isClosed();
            DFSClient.this.checkOpen();
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                this.enqueueCurrentPacket();
                toWaitFor = this.lastQueuedSeqno;
            }
            this.waitForAckedSeqno(toWaitFor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAckedSeqno(long seqnumToWaitFor) throws IOException {
            LinkedList<Packet> linkedList = this.ackQueue;
            synchronized (linkedList) {
                while (!this.closed) {
                    this.isClosed();
                    if (this.lastAckedSeqno >= seqnumToWaitFor) break;
                    try {
                        this.ackQueue.wait();
                    }
                    catch (InterruptedException ie) {}
                }
            }
            this.isClosed();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                IOException e = this.lastException;
                if (e == null) {
                    return;
                }
                throw e;
            }
            this.closeInternal();
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            DFSClient.this.endFileLease(this.src);
        }

        void abortForTests() throws IOException {
            this.streamer.close();
            this.response.close();
            this.closed = true;
        }

        synchronized void abort() throws IOException {
            if (this.closed) {
                return;
            }
            this.setLastException(new IOException("Lease timeout of " + DFSClient.this.hdfsTimeout / 1000 + " seconds expired."));
            this.closeThreads();
            DFSClient.this.endFileLease(this.src);
        }

        private void closeThreads() throws IOException {
            try {
                this.streamer.close();
                this.streamer.join();
                if (this.response != null) {
                    this.response.close();
                    this.response.join();
                    this.response = null;
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to shutdown response thread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void closeInternal() throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            try {
                this.flushBuffer();
                LinkedList<Packet> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.currentPacket == null && this.bytesCurBlock != 0L) {
                        this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    }
                    if (this.currentPacket != null) {
                        this.currentPacket.lastPacketInBlock = true;
                    }
                }
                this.flushInternal();
                this.isClosed();
                this.closed = true;
                this.closeThreads();
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.blockStream != null) {
                        this.blockStream.writeInt(0);
                        IOUtils.cleanup(LOG, this.blockStream, this.blockReplyStream);
                    }
                    if (this.s != null) {
                        this.s.close();
                        this.s = null;
                    }
                }
                this.streamer = null;
                this.blockStream = null;
                this.blockReplyStream = null;
                long localstart = System.currentTimeMillis();
                boolean fileComplete = false;
                while (!fileComplete) {
                    fileComplete = DFSClient.this.namenode.complete(this.src, DFSClient.this.clientName);
                    if (fileComplete) continue;
                    if (!DFSClient.this.clientRunning || DFSClient.this.hdfsTimeout > 0 && localstart + (long)DFSClient.this.hdfsTimeout < System.currentTimeMillis()) {
                        String msg = "Unable to close file because dfsclient  was unable to contact the HDFS servers. clientRunning " + DFSClient.this.clientRunning + " hdfsTimeout " + DFSClient.this.hdfsTimeout;
                        LOG.info((Object)msg);
                        throw new IOException(msg);
                    }
                    try {
                        Thread.sleep(400L);
                        if (System.currentTimeMillis() - localstart <= 5000L) continue;
                        LOG.info((Object)("Could not complete " + this.src + " retrying..."));
                    }
                    catch (InterruptedException ie) {}
                }
            }
            finally {
                this.closed = true;
            }
        }

        void setArtificialSlowdown(long period) {
            this.artificialSlowdown = period;
        }

        synchronized void setChunksPerPacket(int value) {
            this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
            this.packetSize = 25 + (this.checksum.getBytesPerChecksum() + this.checksum.getChecksumSize()) * this.chunksPerPacket;
        }

        synchronized void setTestFilename(String newname) {
            this.src = newname;
        }

        long getInitialLen() {
            return this.initialFileSize;
        }

        static /* synthetic */ DatanodeInfo[] access$2502(DFSOutputStream x0, DatanodeInfo[] x1) {
            x0.nodes = x1;
            return x1;
        }

        private class ResponseProcessor
        extends Thread {
            private volatile boolean closed = false;
            private DatanodeInfo[] targets = null;
            private boolean lastPacketInBlock = false;

            ResponseProcessor(DatanodeInfo[] targets) {
                this.targets = targets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("ResponseProcessor for block " + DFSOutputStream.this.block);
                DataTransferProtocol.PipelineAck ack = new DataTransferProtocol.PipelineAck();
                while (!this.closed && DFSClient.this.clientRunning && !this.lastPacketInBlock) {
                    block21: {
                        try {
                            ack.readFields(DFSOutputStream.this.blockReplyStream);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("DFSClient for block " + DFSOutputStream.this.block + " " + ack));
                            }
                            for (int i = ack.getNumOfReplies() - 1; i >= 0 && DFSClient.this.clientRunning; --i) {
                                short reply = ack.getReply(i);
                                if (reply == 0) continue;
                                DFSOutputStream.this.errorIndex = i;
                                throw new IOException("Bad response " + reply + " for block " + DFSOutputStream.this.block + " from datanode " + this.targets[i].getName());
                            }
                            long seqno = ack.getSeqno();
                            assert (seqno != -2L) : "Ack for unkown seqno should be a failed ack: " + ack;
                            if (seqno == -1L) continue;
                            Packet one = null;
                            LinkedList linkedList = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList) {
                                one = (Packet)DFSOutputStream.this.ackQueue.getFirst();
                            }
                            if (one.seqno != seqno) {
                                throw new IOException("Responseprocessor: Expecting seqno  for block " + DFSOutputStream.this.block + " " + one.seqno + " but received " + seqno);
                            }
                            this.lastPacketInBlock = one.lastPacketInBlock;
                            linkedList = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList) {
                                assert (ack.getSeqno() == DFSOutputStream.this.lastAckedSeqno + 1L);
                                DFSOutputStream.this.lastAckedSeqno = ack.getSeqno();
                                DFSOutputStream.this.ackQueue.removeFirst();
                                DFSOutputStream.this.ackQueue.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            if (this.closed) break block21;
                            DFSOutputStream.this.hasError = true;
                            if (e instanceof IOException) {
                                DFSOutputStream.this.setLastException((IOException)e);
                            }
                            LOG.warn((Object)("DFSOutputStream ResponseProcessor exception  for block " + DFSOutputStream.this.block + StringUtils.stringifyException(e)));
                            this.closed = true;
                        }
                    }
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.dataQueue.notifyAll();
                    }
                    linkedList = DFSOutputStream.this.ackQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.ackQueue.notifyAll();
                    }
                }
            }

            void close() {
                this.closed = true;
                this.interrupt();
            }
        }

        private class DataStreamer
        extends Daemon {
            private volatile boolean closed = false;

            private DataStreamer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lastPacket = 0L;
                while (!this.closed && DFSClient.this.clientRunning) {
                    if (DFSOutputStream.this.hasError && DFSOutputStream.this.response != null) {
                        try {
                            DFSOutputStream.this.response.close();
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    Packet one = null;
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        boolean doSleep = DFSOutputStream.this.processDatanodeError(DFSOutputStream.this.hasError, false);
                        long now = System.currentTimeMillis();
                        while (!this.closed && !DFSOutputStream.this.hasError && DFSClient.this.clientRunning && DFSOutputStream.this.dataQueue.size() == 0 && (DFSOutputStream.this.blockStream == null || DFSOutputStream.this.blockStream != null && now - lastPacket < (long)(DFSClient.this.timeoutValue / 2)) || doSleep) {
                            long timeout = (long)(DFSClient.this.timeoutValue / 2) - (now - lastPacket);
                            timeout = timeout <= 0L ? 1000L : timeout;
                            try {
                                DFSOutputStream.this.dataQueue.wait(timeout);
                                now = System.currentTimeMillis();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            doSleep = false;
                        }
                        if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) {
                            continue;
                        }
                        try {
                            one = DFSOutputStream.this.dataQueue.isEmpty() ? new Packet() : (Packet)DFSOutputStream.this.dataQueue.getFirst();
                            long offsetInBlock = one.offsetInBlock;
                            if (DFSOutputStream.this.blockStream == null) {
                                LOG.debug((Object)"Allocating new block");
                                DFSOutputStream.access$2502(DFSOutputStream.this, DFSOutputStream.this.nextBlockOutputStream());
                                this.setName("DataStreamer for file " + DFSOutputStream.this.src + " block " + DFSOutputStream.this.block);
                                DFSOutputStream.this.response = new ResponseProcessor(DFSOutputStream.this.nodes);
                                DFSOutputStream.this.response.start();
                            }
                            if (offsetInBlock >= DFSOutputStream.this.blockSize) {
                                throw new IOException("BlockSize " + DFSOutputStream.this.blockSize + " is smaller than data size. " + " Offset of packet in block " + offsetInBlock + " Aborting file " + DFSOutputStream.this.src);
                            }
                            ByteBuffer buf = one.getBuffer();
                            if (!one.isHeartbeatPacket()) {
                                DFSOutputStream.this.dataQueue.removeFirst();
                                DFSOutputStream.this.dataQueue.notifyAll();
                                LinkedList linkedList2 = DFSOutputStream.this.ackQueue;
                                synchronized (linkedList2) {
                                    DFSOutputStream.this.ackQueue.addLast(one);
                                    DFSOutputStream.this.ackQueue.notifyAll();
                                }
                            }
                            DFSOutputStream.this.blockStream.write(buf.array(), buf.position(), buf.remaining());
                            if (one.lastPacketInBlock) {
                                DFSOutputStream.this.blockStream.writeInt(0);
                            }
                            DFSOutputStream.this.blockStream.flush();
                            lastPacket = System.currentTimeMillis();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("DataStreamer block " + DFSOutputStream.this.block + " wrote packet seqno:" + one.seqno + " size:" + buf.remaining() + " offsetInBlock:" + one.offsetInBlock + " lastPacketInBlock:" + one.lastPacketInBlock));
                            }
                        }
                        catch (Throwable e) {
                            LOG.warn((Object)("DataStreamer Exception: " + StringUtils.stringifyException(e)));
                            if (e instanceof IOException) {
                                DFSOutputStream.this.setLastException((IOException)e);
                            }
                            DFSOutputStream.this.hasError = true;
                        }
                    }
                    if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                    if (one.lastPacketInBlock) {
                        linkedList = DFSOutputStream.this.ackQueue;
                        synchronized (linkedList) {
                            while (!DFSOutputStream.this.hasError && DFSOutputStream.this.ackQueue.size() != 0 && DFSClient.this.clientRunning) {
                                try {
                                    DFSOutputStream.this.ackQueue.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        LOG.debug((Object)("Closing old block " + DFSOutputStream.this.block));
                        this.setName("DataStreamer for file " + DFSOutputStream.this.src);
                        DFSOutputStream.this.response.close();
                        try {
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                        LinkedList e = DFSOutputStream.this.dataQueue;
                        synchronized (e) {
                            IOUtils.cleanup(LOG, DFSOutputStream.this.blockStream, DFSOutputStream.this.blockReplyStream);
                            DFSOutputStream.access$2502(DFSOutputStream.this, null);
                            DFSOutputStream.this.response = null;
                            DFSOutputStream.this.blockStream = null;
                            DFSOutputStream.this.blockReplyStream = null;
                        }
                    }
                    if (DFSOutputStream.this.progress != null) {
                        DFSOutputStream.this.progress.progress();
                    }
                    if (DFSOutputStream.this.artificialSlowdown == 0L || !DFSClient.this.clientRunning) continue;
                    LOG.debug((Object)("Sleeping for artificial slowdown of " + DFSOutputStream.this.artificialSlowdown + "ms"));
                    try {
                        Thread.sleep(DFSOutputStream.this.artificialSlowdown);
                    }
                    catch (InterruptedException e) {}
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                this.closed = true;
                LinkedList linkedList = DFSOutputStream.this.dataQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.dataQueue.notifyAll();
                }
                linkedList = DFSOutputStream.this.ackQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.ackQueue.notifyAll();
                }
                this.interrupt();
            }
        }

        private class Packet {
            ByteBuffer buffer;
            byte[] buf;
            long seqno;
            long offsetInBlock;
            boolean lastPacketInBlock = false;
            int numChunks = 0;
            int maxChunks;
            int dataStart;
            int dataPos;
            int checksumStart;
            int checksumPos;
            private static final long HEART_BEAT_SEQNO = -1L;

            Packet() {
                this.offsetInBlock = 0L;
                this.seqno = -1L;
                this.buffer = null;
                int packetSize = 25;
                this.buf = new byte[packetSize];
                this.checksumPos = this.checksumStart = (this.dataStart = packetSize);
                this.dataPos = this.dataStart;
                this.maxChunks = 0;
            }

            Packet(int pktSize, int chunksPerPkt, long offsetInBlock) {
                this.offsetInBlock = offsetInBlock;
                this.seqno = DFSOutputStream.this.currentSeqno;
                DFSOutputStream.this.currentSeqno++;
                this.buffer = null;
                this.buf = new byte[pktSize];
                this.checksumPos = this.checksumStart = 25;
                this.dataPos = this.dataStart = this.checksumStart + chunksPerPkt * DFSOutputStream.this.checksum.getChecksumSize();
                this.maxChunks = chunksPerPkt;
            }

            void writeData(byte[] inarray, int off, int len) {
                if (this.dataPos + len > this.buf.length) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.dataPos, len);
                this.dataPos += len;
            }

            void writeChecksum(byte[] inarray, int off, int len) {
                if (this.checksumPos + len > this.dataStart) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.checksumPos, len);
                this.checksumPos += len;
            }

            ByteBuffer getBuffer() {
                if (this.buffer != null) {
                    return this.buffer;
                }
                int dataLen = this.dataPos - this.dataStart;
                int checksumLen = this.checksumPos - this.checksumStart;
                if (this.checksumPos != this.dataStart) {
                    System.arraycopy(this.buf, this.checksumStart, this.buf, this.dataStart - checksumLen, checksumLen);
                }
                int pktLen = 4 + dataLen + checksumLen;
                this.buffer = ByteBuffer.wrap(this.buf, this.dataStart - this.checksumPos, 21 + pktLen);
                this.buf = null;
                this.buffer.mark();
                this.buffer.putInt(pktLen);
                this.buffer.putLong(this.offsetInBlock);
                this.buffer.putLong(this.seqno);
                this.buffer.put((byte)(this.lastPacketInBlock ? 1 : 0));
                this.buffer.putInt(dataLen);
                this.buffer.reset();
                return this.buffer;
            }

            private boolean isHeartbeatPacket() {
                return this.seqno == -1L;
            }
        }
    }

    public static class DFSDataInputStream
    extends FSDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }

        public DatanodeInfo getCurrentDatanode() {
            return ((DFSInputStream)this.in).getCurrentDatanode();
        }

        public Block getCurrentBlock() {
            return ((DFSInputStream)this.in).getCurrentBlock();
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return ((DFSInputStream)this.in).getAllBlocks();
        }

        public long getVisibleLength() throws IOException {
            return ((DFSInputStream)this.in).getFileLength();
        }
    }

    public class DFSInputStream
    extends FSInputStream {
        private Socket s = null;
        private boolean closed = false;
        private String src;
        private long prefetchSize = 10L * DFSClient.access$100(DFSClient.this);
        private BlockReader blockReader = null;
        private boolean verifyChecksum;
        private LocatedBlocks locatedBlocks = null;
        private DatanodeInfo currentNode = null;
        private Block currentBlock = null;
        private long pos = 0L;
        private long blockEnd = -1L;
        private int failures = 0;
        private ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
        private int buffersize = 1;
        private byte[] oneByteBuf = new byte[1];

        void addToDeadNodes(DatanodeInfo dnInfo) {
            this.deadNodes.put(dnInfo, dnInfo);
        }

        DFSInputStream(String src, int buffersize, boolean verifyChecksum) throws IOException {
            this.verifyChecksum = verifyChecksum;
            this.buffersize = buffersize;
            this.src = src;
            this.prefetchSize = DFSClient.this.conf.getLong("dfs.read.prefetch.size", this.prefetchSize);
            this.openInfo();
        }

        synchronized void openInfo() throws IOException {
            for (int retries = 3; retries > 0; --retries) {
                if (this.fetchLocatedBlocks()) {
                    return;
                }
                LOG.warn((Object)("Last block locations unavailable. Datanodes might not have reported blocks completely. Will retry for " + retries + " times"));
                this.waitFor(4000);
            }
            throw new IOException("Could not obtain the last block locations.");
        }

        private void waitFor(int waitTime) throws InterruptedIOException {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted while getting the last block length.");
            }
        }

        private boolean fetchLocatedBlocks() throws IOException, FileNotFoundException {
            LocatedBlocks newInfo = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, 0L, this.prefetchSize);
            if (newInfo == null) {
                throw new FileNotFoundException("File does not exist: " + this.src);
            }
            if (this.locatedBlocks != null && !this.locatedBlocks.isUnderConstruction() && !newInfo.isUnderConstruction()) {
                Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
                Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
                while (oldIter.hasNext() && newIter.hasNext()) {
                    if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                    throw new IOException("Blocklist for " + this.src + " has changed!");
                }
            }
            boolean isBlkInfoUpdated = this.updateBlockInfo(newInfo);
            this.locatedBlocks = newInfo;
            this.currentNode = null;
            return isBlkInfoUpdated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateBlockInfo(LocatedBlocks newInfo) throws IOException {
            boolean lastBlockInFile;
            if (!DFSClient.this.serverSupportsHdfs200 || !newInfo.isUnderConstruction() || newInfo.locatedBlockCount() <= 0) {
                return true;
            }
            LocatedBlock last = newInfo.get(newInfo.locatedBlockCount() - 1);
            boolean bl = lastBlockInFile = last.getStartOffset() + last.getBlockSize() == newInfo.getFileLength();
            if (!lastBlockInFile) {
                return true;
            }
            if (last.getLocations().length == 0) {
                return false;
            }
            ClientDatanodeProtocol primary = null;
            Block newBlock = null;
            for (int i = 0; i < last.getLocations().length && newBlock == null; ++i) {
                DatanodeInfo datanode = last.getLocations()[i];
                try {
                    primary = DFSClient.createClientDatanodeProtocolProxy(datanode, DFSClient.this.conf, last.getBlock(), last.getBlockToken(), DFSClient.this.socketTimeout, DFSClient.this.connectToDnViaHostname);
                    newBlock = primary.getBlockInfo(last.getBlock());
                    if (primary == null) continue;
                }
                catch (IOException e) {
                    try {
                        if (e.getMessage().startsWith("java.io.IOException: java.lang.NoSuchMethodException: org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol.getBlockInfo")) {
                            DFSClient.this.serverSupportsHdfs200 = false;
                        } else {
                            LOG.info((Object)("Failed to get block info from " + datanode.getHostName() + " probably does not have " + last.getBlock()), (Throwable)e);
                        }
                        if (primary == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (primary != null) {
                            RPC.stopProxy(primary);
                        }
                        throw throwable;
                    }
                    RPC.stopProxy(primary);
                    continue;
                }
                RPC.stopProxy(primary);
                continue;
            }
            if (newBlock == null) {
                if (!DFSClient.this.serverSupportsHdfs200) {
                    return true;
                }
                throw new IOException("Failed to get block info from any of the DN in pipeline: " + Arrays.toString(last.getLocations()));
            }
            long newBlockSize = newBlock.getNumBytes();
            long delta = newBlockSize - last.getBlockSize();
            last.getBlock().setNumBytes(newBlockSize);
            long newlength = newInfo.getFileLength() + delta;
            newInfo.setFileLength(newlength);
            LOG.debug((Object)("DFSClient setting last block " + last + " to length " + newBlockSize + " filesize is now " + newInfo.getFileLength()));
            return true;
        }

        public synchronized long getFileLength() {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength();
        }

        private synchronized boolean blockUnderConstruction() {
            return this.locatedBlocks.isUnderConstruction();
        }

        public DatanodeInfo getCurrentDatanode() {
            return this.currentNode;
        }

        public Block getCurrentBlock() {
            return this.currentBlock;
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return this.getBlockRange(0L, this.getFileLength());
        }

        private synchronized LocatedBlock getBlockAt(long offset, boolean updatePosition) throws IOException {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, offset, this.prefetchSize);
                assert (newBlocks != null) : "Could not find target position " + offset;
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            LocatedBlock blk = this.locatedBlocks.get(targetBlockIdx);
            if (updatePosition) {
                this.pos = offset;
                this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
                this.currentBlock = blk.getBlock();
            }
            return blk;
        }

        private synchronized void fetchBlockAt(long offset) throws IOException {
            LocatedBlocks newBlocks;
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
            }
            if ((newBlocks = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, offset, this.prefetchSize)) == null) {
                throw new IOException("Could not find target position " + offset);
            }
            this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
        }

        private synchronized List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
            int blockIdx = this.locatedBlocks.findBlock(offset);
            if (blockIdx < 0) {
                blockIdx = LocatedBlocks.getInsertIndex(blockIdx);
            }
            long remaining = length;
            long curOff = offset;
            while (remaining > 0L) {
                LocatedBlock blk = null;
                if (blockIdx < this.locatedBlocks.locatedBlockCount()) {
                    blk = this.locatedBlocks.get(blockIdx);
                }
                if (blk == null || curOff < blk.getStartOffset()) {
                    LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(DFSClient.this.namenode, this.src, curOff, remaining);
                    this.locatedBlocks.insertRange(blockIdx, newBlocks.getLocatedBlocks());
                    continue;
                }
                assert (curOff >= blk.getStartOffset()) : "Block not found";
                blockRange.add(blk);
                long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
                remaining -= bytesRead;
                curOff += bytesRead;
                ++blockIdx;
            }
            return blockRange;
        }

        private boolean shouldTryShortCircuitRead(InetSocketAddress targetAddr) throws IOException {
            return DFSClient.this.shortCircuitLocalReads && !this.blockUnderConstruction() && DFSClient.isLocalAddress(targetAddr);
        }

        private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
            if (target >= this.getFileLength()) {
                throw new IOException("Attempted to read past end of file");
            }
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            DatanodeInfo chosenNode = null;
            int refetchToken = 1;
            while (true) {
                LocatedBlock targetBlock = this.getBlockAt(target, true);
                assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
                long offsetIntoBlock = target - targetBlock.getStartOffset();
                DNAddrPair retval = this.chooseDataNode(targetBlock);
                chosenNode = retval.info;
                InetSocketAddress targetAddr = retval.addr;
                Block blk = targetBlock.getBlock();
                Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
                if (this.shouldTryShortCircuitRead(targetAddr)) {
                    try {
                        this.blockReader = DFSClient.this.getLocalBlockReader(DFSClient.this.conf, this.src, blk, accessToken, chosenNode, DFSClient.this.socketTimeout, offsetIntoBlock);
                        return chosenNode;
                    }
                    catch (AccessControlException ex) {
                        LOG.warn((Object)"Short circuit access failed ", (Throwable)ex);
                        DFSClient.this.shortCircuitLocalReads = false;
                    }
                    catch (IOException ex) {
                        if (refetchToken > 0 && DFSClient.tokenRefetchNeeded(ex, targetAddr)) {
                            --refetchToken;
                            this.fetchBlockAt(target);
                            continue;
                        }
                        LOG.info((Object)("Failed to read " + targetBlock.getBlock() + " on local machine" + StringUtils.stringifyException(ex)));
                        LOG.info((Object)("Try reading via the datanode on " + targetAddr));
                    }
                }
                try {
                    this.s = DFSClient.this.socketFactory.createSocket();
                    LOG.debug((Object)("Connecting to " + targetAddr));
                    NetUtils.connect(this.s, targetAddr, DFSClient.this.getRandomLocalInterfaceAddr(), DFSClient.this.socketTimeout);
                    this.s.setSoTimeout(DFSClient.this.socketTimeout);
                    this.blockReader = RemoteBlockReader.newBlockReader(this.s, this.src, blk.getBlockId(), accessToken, blk.getGenerationStamp(), offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.buffersize, this.verifyChecksum, DFSClient.this.clientName);
                    return chosenNode;
                }
                catch (IOException ex) {
                    if (refetchToken > 0 && DFSClient.tokenRefetchNeeded(ex, targetAddr)) {
                        --refetchToken;
                        this.fetchBlockAt(target);
                    } else {
                        LOG.warn((Object)("Failed to connect to " + targetAddr + ", add to deadNodes and continue" + ex));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Connection failure", (Throwable)ex);
                        }
                        this.addToDeadNodes(chosenNode);
                    }
                    if (this.s != null) {
                        try {
                            this.s.close();
                        }
                        catch (IOException iex) {
                            // empty catch block
                        }
                    }
                    this.s = null;
                    continue;
                }
                break;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            DFSClient.this.checkOpen();
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            super.close();
            this.closed = true;
        }

        @Override
        public synchronized int read() throws IOException {
            int ret = this.read(this.oneByteBuf, 0, 1);
            return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
        }

        private synchronized int readBuffer(byte[] buf, int off, int len) throws IOException {
            boolean retryCurrentNode = true;
            while (true) {
                IOException ioe;
                try {
                    return this.blockReader.read(buf, off, len);
                }
                catch (ChecksumException ce) {
                    LOG.warn((Object)("Found Checksum error for " + this.currentBlock + " from " + this.currentNode.getName() + " at " + ce.getPos()));
                    DFSClient.this.reportChecksumFailure(this.src, this.currentBlock, this.currentNode);
                    ioe = ce;
                    retryCurrentNode = false;
                }
                catch (IOException e) {
                    if (!retryCurrentNode) {
                        LOG.warn((Object)("Exception while reading from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException(e)));
                    }
                    ioe = e;
                }
                boolean sourceFound = false;
                if (retryCurrentNode) {
                    sourceFound = this.seekToBlockSource(this.pos);
                } else {
                    this.addToDeadNodes(this.currentNode);
                    sourceFound = this.seekToNewSource(this.pos);
                }
                if (!sourceFound) {
                    throw ioe;
                }
                retryCurrentNode = false;
            }
        }

        @Override
        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.failures = 0;
            if (this.pos < this.getFileLength()) {
                int retries = 2;
                while (retries > 0) {
                    try {
                        int realLen;
                        int result;
                        if (this.pos > this.blockEnd) {
                            this.currentNode = this.blockSeekTo(this.pos);
                        }
                        if ((result = this.readBuffer(buf, off, realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L))) >= 0) {
                            this.pos += (long)result;
                        } else {
                            throw new IOException("Unexpected EOS from the reader");
                        }
                        if (DFSClient.this.stats != null && result != -1) {
                            DFSClient.this.stats.incrementBytesRead(result);
                        }
                        return result;
                    }
                    catch (ChecksumException ce) {
                        throw ce;
                    }
                    catch (IOException e) {
                        if (retries == 1) {
                            LOG.warn((Object)("DFS Read: " + StringUtils.stringifyException(e)));
                        }
                        this.blockEnd = -1L;
                        if (this.currentNode != null) {
                            this.addToDeadNodes(this.currentNode);
                        }
                        if (--retries != 0) continue;
                        throw e;
                    }
                }
            }
            return -1;
        }

        private DNAddrPair chooseDataNode(LocatedBlock block) throws IOException {
            while (true) {
                DatanodeInfo[] nodes = block.getLocations();
                try {
                    DatanodeInfo chosenNode = DFSClient.this.bestNode(nodes, this.deadNodes);
                    InetSocketAddress targetAddr = NetUtils.createSocketAddr(chosenNode.getName(DFSClient.this.connectToDnViaHostname));
                    return new DNAddrPair(chosenNode, targetAddr);
                }
                catch (IOException ie) {
                    String blockInfo = block.getBlock() + " file=" + this.src;
                    if (this.failures >= DFSClient.this.maxBlockAcquireFailures) {
                        throw new IOException("Could not obtain block: " + blockInfo);
                    }
                    if (nodes == null || nodes.length == 0) {
                        LOG.info((Object)("No node available for: " + blockInfo));
                    }
                    LOG.info((Object)("Could not obtain " + block.getBlock() + " from any node: " + ie + ". Will get new block locations from namenode and retry..."));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    this.deadNodes.clear();
                    this.openInfo();
                    block = this.getBlockAt(block.getStartOffset(), false);
                    ++this.failures;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset) throws IOException {
            Socket dn = null;
            int refetchToken = 1;
            while (true) {
                BlockReader reader;
                DatanodeInfo chosenNode;
                block13: {
                    block = this.getBlockAt(block.getStartOffset(), false);
                    DNAddrPair retval = this.chooseDataNode(block);
                    chosenNode = retval.info;
                    InetSocketAddress targetAddr = retval.addr;
                    reader = null;
                    try {
                        int len;
                        block12: {
                            Token<BlockTokenIdentifier> accessToken = block.getBlockToken();
                            len = (int)(end - start + 1L);
                            if (this.shouldTryShortCircuitRead(targetAddr)) {
                                try {
                                    reader = DFSClient.this.getLocalBlockReader(DFSClient.this.conf, this.src, block.getBlock(), accessToken, chosenNode, DFSClient.this.socketTimeout, start);
                                    break block12;
                                }
                                catch (AccessControlException ex) {
                                    LOG.warn((Object)"Short circuit access failed ", (Throwable)ex);
                                    DFSClient.this.shortCircuitLocalReads = false;
                                    IOUtils.closeStream(reader);
                                    IOUtils.closeSocket(dn);
                                    continue;
                                }
                            }
                            dn = DFSClient.this.socketFactory.createSocket();
                            LOG.debug((Object)("Connecting to " + targetAddr));
                            NetUtils.connect(dn, targetAddr, DFSClient.this.getRandomLocalInterfaceAddr(), DFSClient.this.socketTimeout);
                            dn.setSoTimeout(DFSClient.this.socketTimeout);
                            reader = RemoteBlockReader.newBlockReader(dn, this.src, block.getBlock().getBlockId(), accessToken, block.getBlock().getGenerationStamp(), start, len, this.buffersize, this.verifyChecksum, DFSClient.this.clientName);
                        }
                        int nread = reader.readAll(buf, offset, len);
                        if (nread == len) break block13;
                        throw new IOException("truncated return from reader.read(): excpected " + len + ", got " + nread);
                    }
                    catch (ChecksumException e) {
                        LOG.warn((Object)("fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + chosenNode.getName()));
                        DFSClient.this.reportChecksumFailure(this.src, block.getBlock(), chosenNode);
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeStream(reader);
                                IOUtils.closeSocket(dn);
                                throw throwable;
                            }
                        }
                        IOUtils.closeStream(reader);
                        IOUtils.closeSocket(dn);
                        catch (IOException e2) {
                            block15: {
                                block14: {
                                    if (refetchToken <= 0 || !DFSClient.tokenRefetchNeeded(e2, targetAddr)) break block14;
                                    --refetchToken;
                                    this.fetchBlockAt(block.getStartOffset());
                                    IOUtils.closeStream(reader);
                                    IOUtils.closeSocket(dn);
                                    continue;
                                }
                                LOG.warn((Object)("Failed to connect to " + targetAddr + " for file " + this.src + " for block " + block.getBlock() + ":" + e2));
                                if (!LOG.isDebugEnabled()) break block15;
                                LOG.debug((Object)"Connection failure ", (Throwable)e2);
                            }
                            IOUtils.closeStream(reader);
                            IOUtils.closeSocket(dn);
                        }
                    }
                }
                IOUtils.closeStream(reader);
                IOUtils.closeSocket(dn);
                return;
                this.addToDeadNodes(chosenNode);
            }
        }

        @Override
        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.failures = 0;
            long filelen = this.getFileLength();
            if (position < 0L || position >= filelen) {
                return -1;
            }
            int realLen = length;
            if (position + (long)length > filelen) {
                realLen = (int)(filelen - position);
            }
            List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
            int remaining = realLen;
            for (LocatedBlock blk : blockRange) {
                long targetStart = position - blk.getStartOffset();
                long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
                this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset);
                remaining = (int)((long)remaining - bytesToRead);
                position += bytesToRead;
                offset = (int)((long)offset + bytesToRead);
            }
            assert (remaining == 0) : "Wrong number of bytes read.";
            if (DFSClient.this.stats != null) {
                DFSClient.this.stats.incrementBytesRead(realLen);
            }
            return realLen;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > 0L) {
                long fileLen;
                long curPos = this.getPos();
                if (n + curPos > (fileLen = this.getFileLength())) {
                    n = fileLen - curPos;
                }
                this.seek(curPos + n);
                return n;
            }
            return n < 0L ? -1L : 0L;
        }

        @Override
        public synchronized void seek(long targetPos) throws IOException {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            boolean done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                try {
                    this.pos += this.blockReader.skip(diff);
                    if (this.pos == targetPos) {
                        done = true;
                    }
                }
                catch (IOException e) {
                    LOG.debug((Object)("Exception while seek to " + targetPos + " from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException(e)));
                }
            }
            if (!done) {
                this.pos = targetPos;
                this.blockEnd = -1L;
            }
        }

        private synchronized boolean seekToBlockSource(long targetPos) throws IOException {
            this.currentNode = this.blockSeekTo(targetPos);
            return true;
        }

        @Override
        public synchronized boolean seekToNewSource(long targetPos) throws IOException {
            boolean markedDead = this.deadNodes.containsKey(this.currentNode);
            this.addToDeadNodes(this.currentNode);
            DatanodeInfo oldNode = this.currentNode;
            DatanodeInfo newNode = this.blockSeekTo(targetPos);
            if (!markedDead) {
                this.deadNodes.remove(oldNode);
            }
            if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
                this.currentNode = newNode;
                return true;
            }
            return false;
        }

        @Override
        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            return (int)(this.getFileLength() - this.pos);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readLimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark/reset not supported");
        }
    }

    public static class RemoteBlockReader
    extends FSInputChecker
    implements BlockReader {
        private Socket dnSock;
        private DataInputStream in;
        private DataChecksum checksum;
        private long lastChunkOffset = -1L;
        private long lastChunkLen = -1L;
        private long lastSeqNo = -1L;
        private long startOffset;
        private long firstChunkOffset;
        private int bytesPerChecksum;
        private int checksumSize;
        private boolean gotEOS = false;
        byte[] skipBuf = null;
        ByteBuffer checksumBytes = null;
        int dataLeft = 0;
        boolean isLastPacket = false;

        @Override
        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            if (this.lastChunkLen < 0L && this.startOffset > this.firstChunkOffset && len > 0) {
                int toSkip = (int)(this.startOffset - this.firstChunkOffset);
                if (this.skipBuf == null) {
                    this.skipBuf = new byte[this.bytesPerChecksum];
                }
                if (super.read(this.skipBuf, 0, toSkip) != toSkip) {
                    throw new IOException("Could not skip required number of bytes");
                }
            }
            boolean eosBefore = this.gotEOS;
            int nRead = super.read(buf, off, len);
            if (this.dnSock != null && this.gotEOS && !eosBefore && nRead >= 0 && this.needChecksum()) {
                this.checksumOk(this.dnSock);
            }
            return nRead;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long nSkipped;
            int ret;
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            for (nSkipped = 0L; nSkipped < n; nSkipped += (long)ret) {
                int toSkip = (int)Math.min(n - nSkipped, (long)this.skipBuf.length);
                ret = this.read(this.skipBuf, 0, toSkip);
                if (ret > 0) continue;
                return nSkipped;
            }
            return nSkipped;
        }

        @Override
        public int read() throws IOException {
            throw new IOException("read() is not expected to be invoked. Use read(buf, off, len) instead.");
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new IOException("Seek() is not supported in BlockInputChecker");
        }

        @Override
        protected long getChunkPosition(long pos) {
            throw new RuntimeException("getChunkPosition() is not supported, since seek is not required");
        }

        private void adjustChecksumBytes(int dataLen) {
            int requiredSize = (dataLen + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
            if (this.checksumBytes == null || requiredSize > this.checksumBytes.capacity()) {
                this.checksumBytes = ByteBuffer.wrap(new byte[requiredSize]);
            } else {
                this.checksumBytes.clear();
            }
            this.checksumBytes.limit(requiredSize);
        }

        @Override
        protected synchronized int readChunk(long pos, byte[] buf, int offset, int len, byte[] checksumBuf) throws IOException {
            int chunkLen;
            if (this.gotEOS) {
                if (this.startOffset < 0L) {
                    throw new IOException("BlockRead: already got EOS or an error");
                }
                this.startOffset = -1L;
                return -1;
            }
            long chunkOffset = this.lastChunkOffset;
            if (this.lastChunkLen > 0L) {
                chunkOffset += this.lastChunkLen;
            }
            if (pos + this.firstChunkOffset != chunkOffset) {
                throw new IOException("Mismatch in pos : " + pos + " + " + this.firstChunkOffset + " != " + chunkOffset);
            }
            if (this.dataLeft <= 0) {
                int dataLen;
                int packetLen = this.in.readInt();
                long offsetInBlock = this.in.readLong();
                long seqno = this.in.readLong();
                boolean lastPacketInBlock = this.in.readBoolean();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("DFSClient readChunk got seqno " + seqno + " offsetInBlock " + offsetInBlock + " lastPacketInBlock " + lastPacketInBlock + " packetLen " + packetLen));
                }
                if ((dataLen = this.in.readInt()) < 0 || dataLen % this.bytesPerChecksum != 0 && !lastPacketInBlock || seqno != this.lastSeqNo + 1L) {
                    throw new IOException("BlockReader: error in packet header(chunkOffset : " + chunkOffset + ", dataLen : " + dataLen + ", seqno : " + seqno + " (last: " + this.lastSeqNo + "))");
                }
                this.lastSeqNo = seqno;
                this.isLastPacket = lastPacketInBlock;
                this.dataLeft = dataLen;
                this.adjustChecksumBytes(dataLen);
                if (dataLen > 0) {
                    IOUtils.readFully(this.in, this.checksumBytes.array(), 0, this.checksumBytes.limit());
                }
            }
            if ((chunkLen = Math.min(this.dataLeft, this.bytesPerChecksum)) > 0) {
                IOUtils.readFully(this.in, buf, offset, chunkLen);
                this.checksumBytes.get(checksumBuf, 0, this.checksumSize);
            }
            this.dataLeft -= chunkLen;
            this.lastChunkOffset = chunkOffset;
            this.lastChunkLen = chunkLen;
            if (this.dataLeft == 0 && this.isLastPacket || chunkLen == 0) {
                this.gotEOS = true;
            }
            if (chunkLen == 0) {
                return -1;
            }
            return chunkLen;
        }

        private RemoteBlockReader(String file, long blockId, DataInputStream in, DataChecksum checksum, boolean verifyChecksum, long startOffset, long firstChunkOffset, Socket dnSock) {
            super(new Path("/blk_" + blockId + ":of:" + file), 1, verifyChecksum, checksum.getChecksumSize() > 0 ? checksum : null, checksum.getBytesPerChecksum(), checksum.getChecksumSize());
            this.dnSock = dnSock;
            this.in = in;
            this.checksum = checksum;
            this.startOffset = Math.max(startOffset, 0L);
            this.firstChunkOffset = firstChunkOffset;
            this.lastChunkOffset = firstChunkOffset;
            this.lastChunkLen = -1L;
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            this.checksumSize = this.checksum.getChecksumSize();
        }

        RemoteBlockReader(Path file, int numRetries) {
            super(file, numRetries);
        }

        protected RemoteBlockReader(Path file, int numRetries, DataChecksum checksum, boolean verifyChecksum) {
            super(file, numRetries, verifyChecksum, checksum.getChecksumSize() > 0 ? checksum : null, checksum.getBytesPerChecksum(), checksum.getChecksumSize());
        }

        public static BlockReader newBlockReader(Socket sock, String file, long blockId, Token<BlockTokenIdentifier> accessToken, long genStamp, long startOffset, long len, int bufferSize) throws IOException {
            return RemoteBlockReader.newBlockReader(sock, file, blockId, accessToken, genStamp, startOffset, len, bufferSize, true);
        }

        public static BlockReader newBlockReader(Socket sock, String file, long blockId, Token<BlockTokenIdentifier> accessToken, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum) throws IOException {
            return RemoteBlockReader.newBlockReader(sock, file, blockId, accessToken, genStamp, startOffset, len, bufferSize, verifyChecksum, "");
        }

        public static BlockReader newBlockReader(Socket sock, String file, long blockId, Token<BlockTokenIdentifier> accessToken, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(sock, 480000L)));
            out.writeShort(17);
            out.write(81);
            out.writeLong(blockId);
            out.writeLong(genStamp);
            out.writeLong(startOffset);
            out.writeLong(len);
            Text.writeString(out, clientName);
            accessToken.write(out);
            out.flush();
            DataInputStream in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(sock), bufferSize));
            short status = in.readShort();
            if (status != 0) {
                if (status == 5) {
                    throw new InvalidBlockTokenException("Got access token error for OP_READ_BLOCK, self=" + sock.getLocalSocketAddress() + ", remote=" + sock.getRemoteSocketAddress() + ", for file " + file + ", for block " + blockId + "_" + genStamp);
                }
                throw new IOException("Got error for OP_READ_BLOCK, self=" + sock.getLocalSocketAddress() + ", remote=" + sock.getRemoteSocketAddress() + ", for file " + file + ", for block " + blockId + "_" + genStamp);
            }
            DataChecksum checksum = DataChecksum.newDataChecksum(in);
            long firstChunkOffset = in.readLong();
            if (firstChunkOffset < 0L || firstChunkOffset > startOffset || firstChunkOffset >= startOffset + (long)checksum.getBytesPerChecksum()) {
                throw new IOException("BlockReader: error in first chunk offset (" + firstChunkOffset + ") startOffset is " + startOffset + " for file " + file);
            }
            return new RemoteBlockReader(file, blockId, in, checksum, verifyChecksum, startOffset, firstChunkOffset, sock);
        }

        @Override
        public synchronized void close() throws IOException {
            this.startOffset = -1L;
            this.checksum = null;
        }

        @Override
        public int readAll(byte[] buf, int offset, int len) throws IOException {
            return RemoteBlockReader.readFully(this, buf, offset, len);
        }

        private void checksumOk(Socket sock) {
            try {
                OutputStream out = NetUtils.getOutputStream(sock, 480000L);
                byte[] buf = new byte[]{0, 6};
                out.write(buf);
                out.flush();
            }
            catch (IOException e) {
                LOG.debug((Object)("Could not write to datanode " + sock.getInetAddress() + ": " + e.getMessage()));
            }
        }
    }

    private static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        @Override
        public boolean handleKind(Text kind) {
            return DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals(kind);
        }

        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException {
            Token<DelegationTokenIdentifier> delToken = token;
            LOG.info((Object)("Renewing " + DFSClient.stringifyToken(delToken)));
            InetSocketAddress addr = SecurityUtil.getTokenServiceAddr(token);
            ClientProtocol nn = DFSClient.createRPCNamenode(addr, conf, UserGroupInformation.getCurrentUser());
            try {
                return nn.renewDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
            }
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            Token<DelegationTokenIdentifier> delToken = token;
            LOG.info((Object)("Cancelling " + DFSClient.stringifyToken(delToken)));
            InetSocketAddress addr = SecurityUtil.getTokenServiceAddr(token);
            ClientProtocol nn = DFSClient.createRPCNamenode(addr, conf, UserGroupInformation.getCurrentUser());
            try {
                nn.cancelDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
            }
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }
    }
}

