/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.urlmeta;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMetaIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(URLMetaIndexingFilter.class);
    private static final String CONF_PROPERTY = "urlmeta.tags";
    private static String[] urlMetaTags;
    private Configuration conf;

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        if (this.conf != null) {
            this.setConf(this.conf);
        }
        if (urlMetaTags == null || doc == null) {
            return doc;
        }
        for (String metatag : urlMetaTags) {
            Text metadata = (Text)datum.getMetaData().get((Object)new Text(metatag));
            if (metadata == null) continue;
            doc.add(metatag, (Object)metadata.toString());
        }
        return doc;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (conf == null) {
            return;
        }
        urlMetaTags = conf.getStrings(CONF_PROPERTY);
    }
}

