/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.urlmeta;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMetaScoringFilter
extends Configured
implements ScoringFilter {
    private static final Logger LOG = LoggerFactory.getLogger(URLMetaScoringFilter.class);
    private static final String CONF_PROPERTY = "urlmeta.tags";
    private static String[] urlMetaTags;
    private Configuration conf;

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        if (urlMetaTags == null || targets == null || parseData == null) {
            return adjust;
        }
        for (Map.Entry<Text, CrawlDatum> nextTarget : targets) {
            for (String metatag : urlMetaTags) {
                String metaFromParse = parseData.getMeta(metatag);
                if (metaFromParse == null) continue;
                nextTarget.getValue().getMetaData().put((Writable)new Text(metatag), (Writable)new Text(metaFromParse));
            }
        }
        return adjust;
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) {
        if (urlMetaTags == null || content == null || datum == null) {
            return;
        }
        for (String metatag : urlMetaTags) {
            Text metaFromDatum = (Text)datum.getMetaData().get((Object)new Text(metatag));
            if (metaFromDatum == null) continue;
            content.getMetadata().set(metatag, metaFromDatum.toString());
        }
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) {
        if (urlMetaTags == null || content == null || parse == null) {
            return;
        }
        for (String metatag : urlMetaTags) {
            String metaFromContent = content.getMetadata().get(metatag);
            if (metaFromContent == null) continue;
            parse.getData().getParseMeta().set(metatag, metaFromContent);
        }
    }

    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        return initSort;
    }

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        return initScore;
    }

    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
    }

    public void injectedScore(Text url, CrawlDatum datum) throws ScoringFilterException {
    }

    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinked) throws ScoringFilterException {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        urlMetaTags = conf.getStrings(CONF_PROPERTY);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

