/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.depth;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;

public class DepthScoringFilter
extends Configured
implements ScoringFilter {
    private static final Log LOG = LogFactory.getLog(DepthScoringFilter.class);
    public static final String DEPTH_KEY = "_depth_";
    public static final Text DEPTH_KEY_W = new Text("_depth_");
    public static final String MAX_DEPTH_KEY = "_maxdepth_";
    public static final Text MAX_DEPTH_KEY_W = new Text("_maxdepth_");
    public static final int DEFAULT_MAX_DEPTH = 1000;
    private int defaultMaxDepth;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.defaultMaxDepth = conf.getInt("scoring.depth.max", 1000);
        if (this.defaultMaxDepth <= 0) {
            this.defaultMaxDepth = 1000;
        }
    }

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        String depthString = parseData.getMeta(DEPTH_KEY);
        if (depthString == null) {
            LOG.warn((Object)("Missing depth, removing all outlinks from url " + fromUrl));
            targets.clear();
            return adjust;
        }
        int curDepth = Integer.parseInt(depthString);
        int curMaxDepth = this.defaultMaxDepth;
        IntWritable customMaxDepth = null;
        String maxDepthString = parseData.getMeta(MAX_DEPTH_KEY);
        if (maxDepthString != null) {
            curMaxDepth = Integer.parseInt(maxDepthString);
            customMaxDepth = new IntWritable(curMaxDepth);
        }
        if (curDepth >= curMaxDepth) {
            LOG.info((Object)("Depth limit (" + curMaxDepth + ") reached, ignoring outlinks for " + fromUrl));
            targets.clear();
            return adjust;
        }
        for (Map.Entry<Text, CrawlDatum> e : targets) {
            e.getValue().getMetaData().put((Writable)DEPTH_KEY_W, (Writable)new IntWritable(curDepth + 1));
            if (customMaxDepth == null) continue;
            e.getValue().getMetaData().put((Writable)MAX_DEPTH_KEY_W, (Writable)customMaxDepth);
        }
        return adjust;
    }

    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        IntWritable maxDepth = (IntWritable)datum.getMetaData().get((Object)MAX_DEPTH_KEY_W);
        int curMaxDepth = maxDepth != null ? maxDepth.get() : this.defaultMaxDepth;
        IntWritable depth = (IntWritable)datum.getMetaData().get((Object)DEPTH_KEY_W);
        int curDepth = depth == null ? curMaxDepth : depth.get();
        int mul = curMaxDepth - curDepth;
        return initSort * (float)(1 + mul);
    }

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        return initScore;
    }

    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        if (datum.getMetaData().get((Object)MAX_DEPTH_KEY_W) == null) {
            datum.getMetaData().put((Writable)MAX_DEPTH_KEY_W, (Writable)new IntWritable(this.defaultMaxDepth));
        }
        if (datum.getMetaData().get((Object)DEPTH_KEY_W) == null) {
            datum.getMetaData().put((Writable)DEPTH_KEY_W, (Writable)new IntWritable(1));
        }
    }

    public void injectedScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        if (datum.getMetaData().get((Object)MAX_DEPTH_KEY_W) != null) {
            String depthString = datum.getMetaData().get((Object)MAX_DEPTH_KEY_W).toString();
            datum.getMetaData().remove((Object)MAX_DEPTH_KEY_W);
            int depth = Integer.parseInt(depthString);
            datum.getMetaData().put((Writable)MAX_DEPTH_KEY_W, (Writable)new IntWritable(depth));
        } else {
            datum.getMetaData().put((Writable)MAX_DEPTH_KEY_W, (Writable)new IntWritable(this.defaultMaxDepth));
        }
        datum.getMetaData().put((Writable)DEPTH_KEY_W, (Writable)new IntWritable(1));
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) throws ScoringFilterException {
        String maxdepth;
        String depth = content.getMetadata().get(DEPTH_KEY);
        if (depth != null) {
            parse.getData().getParseMeta().set(DEPTH_KEY, depth);
        }
        if ((maxdepth = content.getMetadata().get(MAX_DEPTH_KEY)) != null) {
            parse.getData().getParseMeta().set(MAX_DEPTH_KEY, maxdepth);
        }
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) throws ScoringFilterException {
        IntWritable maxdepth;
        IntWritable depth = (IntWritable)datum.getMetaData().get((Object)DEPTH_KEY_W);
        if (depth != null) {
            content.getMetadata().set(DEPTH_KEY, depth.toString());
        }
        if ((maxdepth = (IntWritable)datum.getMetaData().get((Object)MAX_DEPTH_KEY_W)) != null) {
            content.getMetadata().set(MAX_DEPTH_KEY, maxdepth.toString());
        }
    }

    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinked) throws ScoringFilterException {
        int newDepth = 1000;
        if (old != null) {
            IntWritable oldDepth = (IntWritable)old.getMetaData().get((Object)DEPTH_KEY_W);
            if (oldDepth != null) {
                newDepth = oldDepth.get();
            } else {
                this.initialScore(url, old);
            }
        }
        for (CrawlDatum lnk : inlinked) {
            IntWritable depth = (IntWritable)lnk.getMetaData().get((Object)DEPTH_KEY_W);
            if (depth == null || depth.get() >= newDepth) continue;
            newDepth = depth.get();
        }
        datum.getMetaData().put((Writable)DEPTH_KEY_W, (Writable)new IntWritable(newDepth));
    }
}

