/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.indexwriter.solr.SolrMappingReader;
import org.apache.nutch.indexwriter.solr.SolrUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
implements IndexWriter {
    public static final Logger LOG = LoggerFactory.getLogger(SolrIndexWriter.class);
    private SolrServer solr;
    private SolrMappingReader solrMapping;
    private ModifiableSolrParams params;
    private Configuration config;
    private final List<SolrInputDocument> inputDocs = new ArrayList<SolrInputDocument>();
    private int batchSize;
    private int numDeletes = 0;
    private boolean delete = false;

    public void open(JobConf job, String name) throws IOException {
        CommonsHttpSolrServer server = SolrUtils.getCommonsHttpSolrServer(job);
        this.init((SolrServer)server, job);
    }

    void init(SolrServer server, JobConf job) throws IOException {
        this.solr = server;
        this.batchSize = job.getInt("solr.commit.size", 1000);
        this.solrMapping = SolrMappingReader.getInstance((Configuration)job);
        this.delete = job.getBoolean("indexer.delete", false);
        this.params = new ModifiableSolrParams();
        String paramString = job.get("indexer.additional.params");
        if (paramString != null) {
            String[] values;
            for (String v : values = paramString.split("&")) {
                String[] kv = v.split("=");
                if (kv.length < 2) continue;
                this.params.add(kv[0], new String[]{kv[1]});
            }
        }
    }

    public void delete(String key) throws IOException {
        if (this.delete) {
            try {
                this.solr.deleteById(key);
                ++this.numDeletes;
            }
            catch (SolrServerException e) {
                throw SolrIndexWriter.makeIOException(e);
            }
        }
    }

    public void update(NutchDocument doc) throws IOException {
        this.write(doc);
    }

    public void write(NutchDocument doc) throws IOException {
        SolrInputDocument inputDoc = new SolrInputDocument();
        for (Map.Entry e : doc) {
            Iterator i$ = ((NutchField)e.getValue()).getValues().iterator();
            while (i$.hasNext()) {
                Object val;
                Object val2 = val = i$.next();
                if (val instanceof Date) {
                    val2 = DateUtil.getThreadLocalDateFormat().format(val);
                }
                if (((String)e.getKey()).equals("content") || ((String)e.getKey()).equals("title")) {
                    val2 = SolrUtils.stripNonCharCodepoints((String)val);
                }
                inputDoc.addField(this.solrMapping.mapKey((String)e.getKey()), val2, ((NutchField)e.getValue()).getWeight());
                String sCopy = this.solrMapping.mapCopyKey((String)e.getKey());
                if (sCopy == e.getKey()) continue;
                inputDoc.addField(sCopy, val);
            }
        }
        inputDoc.setDocumentBoost(doc.getWeight());
        this.inputDocs.add(inputDoc);
        if (this.inputDocs.size() + this.numDeletes >= this.batchSize) {
            try {
                LOG.info("Indexing " + Integer.toString(this.inputDocs.size()) + " documents");
                LOG.info("Deleting " + Integer.toString(this.numDeletes) + " documents");
                this.numDeletes = 0;
                UpdateRequest req = new UpdateRequest();
                req.add(this.inputDocs);
                req.setParams(this.params);
                req.process(this.solr);
            }
            catch (SolrServerException e) {
                throw SolrIndexWriter.makeIOException(e);
            }
            this.inputDocs.clear();
        }
    }

    public void close() throws IOException {
        try {
            if (!this.inputDocs.isEmpty()) {
                LOG.info("Indexing " + Integer.toString(this.inputDocs.size()) + " documents");
                if (this.numDeletes > 0) {
                    LOG.info("Deleting " + Integer.toString(this.numDeletes) + " documents");
                }
                UpdateRequest req = new UpdateRequest();
                req.add(this.inputDocs);
                req.setParams(this.params);
                req.process(this.solr);
                this.inputDocs.clear();
            }
        }
        catch (SolrServerException e) {
            throw SolrIndexWriter.makeIOException(e);
        }
    }

    public void commit() throws IOException {
        try {
            this.solr.commit();
        }
        catch (SolrServerException e) {
            throw SolrIndexWriter.makeIOException(e);
        }
    }

    public static IOException makeIOException(SolrServerException e) {
        IOException ioe = new IOException();
        ioe.initCause(e);
        return ioe;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        String serverURL = conf.get("solr.server.url");
        if (serverURL == null) {
            String message = "Missing SOLR URL. Should be set via -D solr.server.url";
            message = message + "\n" + this.describe();
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }

    public String describe() {
        StringBuffer sb = new StringBuffer("SOLRIndexWriter\n");
        sb.append("\t").append("solr.server.url").append(" : URL of the SOLR instance (mandatory)\n");
        sb.append("\t").append("solr.commit.size").append(" : buffer size when sending to SOLR (default 1000)\n");
        sb.append("\t").append("solr.mapping.file").append(" : name of the mapping file for fields (default solrindex-mapping.xml)\n");
        sb.append("\t").append("solr.auth").append(" : use authentication (default false)\n");
        sb.append("\t").append("solr.auth.username").append(" : use authentication (default false)\n");
        sb.append("\t").append("solr.auth").append(" : username for authentication\n");
        sb.append("\t").append("solr.auth.password").append(" : password for authentication\n");
        return sb.toString();
    }
}

