/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.solr;

import java.net.MalformedURLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.hadoop.mapred.JobConf;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrUtils {
    public static Logger LOG = LoggerFactory.getLogger(SolrUtils.class);

    public static CommonsHttpSolrServer getCommonsHttpSolrServer(JobConf job) throws MalformedURLException {
        HttpClient client = new HttpClient();
        if (job.getBoolean("solr.auth", false)) {
            String username = job.get("solr.auth.username");
            LOG.info("Authenticating as: " + username);
            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            client.getState().setCredentials(scope, (Credentials)new UsernamePasswordCredentials(username, job.get("solr.auth.password")));
            HttpClientParams params = client.getParams();
            params.setAuthenticationPreemptive(true);
            client.setParams(params);
        }
        String serverURL = job.get("solr.server.url");
        return new CommonsHttpSolrServer(serverURL, client);
    }

    public static String stripNonCharCodepoints(String input) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch % 65536 == 65535 || ch % 65536 == 65534 || ch > '\ufdd0' && ch < '\ufdef' || ch <= '\u001f' && ch != '\t' && ch != '\n' && ch != '\r') continue;
            retval.append(ch);
        }
        return retval.toString();
    }
}

