/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class Base64 {
    public static final String _rcsid = "@(#)$Id: Base64.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final char[] base64CharacterArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] mapArray = new byte[128];
    private static final char base64PadCharacter = '=';
    protected char[] characterBuffer = new char[4];
    protected byte[] byteBuffer = new byte[3];

    public boolean decodeNextWord(Reader inputBuffer, OutputStream outputBuffer) throws ManifoldCFException {
        try {
            int bufferIndex = 0;
            while (bufferIndex < this.characterBuffer.length) {
                int character = inputBuffer.read();
                if (character == -1) {
                    if (bufferIndex != 0) {
                        throw new ManifoldCFException("Unexpected end of base64 input");
                    }
                    return false;
                }
                char ch = (char)character;
                if (ch != '=' && (ch >= mapArray.length || mapArray[ch] == 127)) continue;
                this.characterBuffer[bufferIndex++] = ch;
            }
            int outlen = 3;
            if (this.characterBuffer[3] == '=') {
                outlen = 2;
            }
            if (this.characterBuffer[2] == '=') {
                outlen = 1;
            }
            byte b0 = mapArray[this.characterBuffer[0]];
            byte b1 = mapArray[this.characterBuffer[1]];
            byte b2 = mapArray[this.characterBuffer[2]];
            byte b3 = mapArray[this.characterBuffer[3]];
            switch (outlen) {
                case 1: {
                    outputBuffer.write((byte)(b0 << 2 & 0xFC | b1 >> 4 & 3));
                    break;
                }
                case 2: {
                    outputBuffer.write((byte)(b0 << 2 & 0xFC | b1 >> 4 & 3));
                    outputBuffer.write((byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF));
                    break;
                }
                case 3: {
                    outputBuffer.write((byte)(b0 << 2 & 0xFC | b1 >> 4 & 3));
                    outputBuffer.write((byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF));
                    outputBuffer.write((byte)(b2 << 6 & 0xC0 | b3 & 0x3F));
                    break;
                }
                default: {
                    throw new RuntimeException("Should never occur");
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error converting from base 64", e);
        }
    }

    public void decodeStream(Reader inputBuffer, OutputStream outputBuffer) throws ManifoldCFException {
        while (this.decodeNextWord(inputBuffer, outputBuffer)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] decodeString(String inputString) throws ManifoldCFException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream((inputString.length() >> 2) * 3 + 3);
            try {
                byte[] byArray;
                StringReader reader = new StringReader(inputString);
                try {
                    this.decodeStream(reader, outputStream);
                    outputStream.flush();
                    byArray = outputStream.toByteArray();
                }
                catch (Throwable throwable) {
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return byArray;
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("Error streaming through base64 decoder", e);
        }
    }

    public boolean encodeNextWord(InputStream inputStream, Writer outputWriter) throws ManifoldCFException {
        try {
            int actualLength = inputStream.read(this.byteBuffer);
            if (actualLength == -1) {
                return false;
            }
            switch (actualLength) {
                case 0: {
                    throw new ManifoldCFException("Read 0 bytes!");
                }
                case 1: {
                    int i = this.byteBuffer[0] & 0xFF;
                    outputWriter.write(base64CharacterArray[i >> 2]);
                    outputWriter.write(base64CharacterArray[i << 4 & 0x3F]);
                    outputWriter.write(61);
                    outputWriter.write(61);
                    break;
                }
                case 2: {
                    int i = ((this.byteBuffer[0] & 0xFF) << 8) + (this.byteBuffer[1] & 0xFF);
                    outputWriter.write(base64CharacterArray[i >> 10]);
                    outputWriter.write(base64CharacterArray[i >> 4 & 0x3F]);
                    outputWriter.write(base64CharacterArray[i << 2 & 0x3F]);
                    outputWriter.write(61);
                    break;
                }
                case 3: {
                    int i = ((this.byteBuffer[0] & 0xFF) << 16) + ((this.byteBuffer[1] & 0xFF) << 8) + (this.byteBuffer[2] & 0xFF);
                    outputWriter.write(base64CharacterArray[i >> 18]);
                    outputWriter.write(base64CharacterArray[i >> 12 & 0x3F]);
                    outputWriter.write(base64CharacterArray[i >> 6 & 0x3F]);
                    outputWriter.write(base64CharacterArray[i & 0x3F]);
                    break;
                }
                default: {
                    throw new RuntimeException("Should never get here");
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error encoding in base64", e);
        }
    }

    public void encodeStream(InputStream inputStream, Writer outputWriter) throws ManifoldCFException {
        while (this.encodeNextWord(inputStream, outputWriter)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String encodeByteArray(byte[] inputByteArray) throws ManifoldCFException {
        try {
            StringWriter writer = new StringWriter(inputByteArray.length * 4 / 3 + 4);
            try {
                String string;
                ByteArrayInputStream is = new ByteArrayInputStream(inputByteArray);
                try {
                    this.encodeStream(is, writer);
                    ((Writer)writer).flush();
                    string = ((Object)writer).toString();
                }
                catch (Throwable throwable) {
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return string;
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("Error streaming through base64 encoder", e);
        }
    }

    static {
        int i = 0;
        while (i < mapArray.length) {
            Base64.mapArray[i++] = 127;
        }
        for (i = 0; i < base64CharacterArray.length; ++i) {
            Base64.mapArray[Base64.base64CharacterArray[i]] = (byte)i;
        }
    }
}

