/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import com.bitmechanic.sql.ConnectionPool;
import com.bitmechanic.sql.ConnectionPoolManager;
import com.bitmechanic.sql.PooledConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class ConnectionFactory {
    public static final String _rcsid = "@(#)$Id: ConnectionFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final int defaultMaxDBConnections = 50;
    private static final int defaultTimeoutValue = 86400;
    private static HashMap checkedOutConnections = new HashMap();
    private static PoolManager poolManager = new PoolManager();

    private ConnectionFactory() {
    }

    public static Connection getConnection(String jdbcUrl, String jdbcDriver, String database, String userName, String password) throws ManifoldCFException {
        ConnectionPoolManager _pool = poolManager.ensurePoolExists(jdbcDriver);
        try {
            ConnectionPool cp = null;
            try {
                cp = _pool.getPool(database);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cp == null) {
                String handleMax = ManifoldCF.getProperty("org.apache.manifoldcf.database.maxhandles");
                int maxDBConnections = 50;
                if (handleMax != null && handleMax.length() > 0) {
                    maxDBConnections = Integer.parseInt(handleMax);
                }
                String timeoutValueString = ManifoldCF.getProperty("org.apache.manifoldcf.database.handletimeout");
                int timeoutValue = 86400;
                if (timeoutValueString != null && timeoutValueString.length() > 0) {
                    timeoutValue = Integer.parseInt(timeoutValueString);
                }
                _pool.addAlias(database, jdbcDriver, jdbcUrl, userName, password, maxDBConnections, 300, timeoutValue, 30, false);
                cp = _pool.getPool(database);
            }
            Connection rval = ConnectionFactory.getConnectionWithRetries("jdbc:bitmechanic:pool:" + database, null, null);
            return rval;
        }
        catch (Exception e) {
            throw new ManifoldCFException("Error getting connection", e, 1);
        }
    }

    public static void releaseConnection(Connection c) throws ManifoldCFException {
        try {
            c.close();
        }
        catch (Exception e) {
            throw new ManifoldCFException("Error releasing connection", e, 1);
        }
    }

    public static void releaseAll() {
        if (poolManager != null) {
            poolManager.releaseAll();
        }
    }

    protected static Connection getConnectionWithRetries(String dbURL, String userName, String password) throws Exception {
        int retryCount = 3;
        while (true) {
            try {
                Connection rval = userName != null && userName.length() > 0 ? DriverManager.getConnection(dbURL, userName, password) : DriverManager.getConnection(dbURL);
                return rval;
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    throw e;
                }
                --retryCount;
                try {
                    ManifoldCF.sleep(10000L);
                }
                catch (InterruptedException e2) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkConnections(long currentTime) {
        HashMap hashMap = checkedOutConnections;
        synchronized (hashMap) {
            for (Object key : checkedOutConnections.keySet()) {
                ConnectionTracker ct = (ConnectionTracker)checkedOutConnections.get(key);
                if (!ct.hasExpired(currentTime)) continue;
                ct.printDetails();
            }
        }
    }

    protected static class ConnectionTracker {
        protected Connection theConnection;
        protected long checkoutTime;
        protected Exception theTrace;

        public ConnectionTracker(Connection theConnection) {
            this.theConnection = theConnection;
            this.checkoutTime = System.currentTimeMillis();
            this.theTrace = new Exception("Stack trace");
        }

        public boolean hasExpired(long currentTime) {
            return this.checkoutTime + 300000L < currentTime;
        }

        public void printDetails() {
            Logging.db.error((Object)("Connection handle may have been abandoned: " + this.theConnection.toString()), (Throwable)this.theTrace);
        }
    }

    protected static class ConnectionCloseThread
    extends Thread {
        protected PooledConnection connection;
        protected Throwable exception = null;

        public ConnectionCloseThread(PooledConnection connection) {
            this.setDaemon(true);
            this.connection = connection;
        }

        public void run() {
            try {
                this.connection.run();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected static class PoolManager {
        private Integer poolExistenceLock = new Integer(0);
        private ConnectionPoolManager _pool = null;

        private PoolManager() {
        }

        public ConnectionPoolManager ensurePoolExists(String jdbcDriver) throws ManifoldCFException {
            Integer n = this.poolExistenceLock;
            synchronized (n) {
                if (this._pool != null) {
                    return this._pool;
                }
                try {
                    Class.forName(jdbcDriver);
                }
                catch (Exception e) {
                    throw new ManifoldCFException("Unable to load database driver: " + e.getMessage(), e, 3);
                }
                try {
                    String handleMax = ManifoldCF.getProperty("org.apache.manifoldcf.database.maxhandles");
                    int maxDBConnections = 50;
                    if (handleMax != null && handleMax.length() > 0) {
                        maxDBConnections = Integer.parseInt(handleMax);
                    }
                    this._pool = new ConnectionPoolManager(maxDBConnections);
                    return this._pool;
                }
                catch (Exception e) {
                    throw new ManifoldCFException("Unable to initialize database handle pool: " + e.getMessage(), e, 3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseAll() {
            Integer n = this.poolExistenceLock;
            synchronized (n) {
                if (this._pool == null) {
                    return;
                }
            }
            Enumeration enumeration = this._pool.getPools();
            ArrayList<ConnectionCloseThread> connectionShutdownThreads = new ArrayList<ConnectionCloseThread>();
            while (enumeration.hasMoreElements()) {
                ConnectionPool pool = (ConnectionPool)enumeration.nextElement();
                try {
                    int count = pool.size();
                    for (int i = 0; i < count; ++i) {
                        PooledConnection p = (PooledConnection)pool.getConnection();
                        ConnectionCloseThread t = new ConnectionCloseThread(p);
                        t.start();
                        connectionShutdownThreads.add(t);
                    }
                }
                catch (Exception e) {
                }
            }
            for (int k = 0; k < 15; ++k) {
                ConnectionCloseThread t;
                int j;
                for (j = 0; j < connectionShutdownThreads.size() && !(t = (ConnectionCloseThread)connectionShutdownThreads.get(j)).isAlive(); ++j) {
                }
                if (j >= connectionShutdownThreads.size()) break;
                try {
                    ManifoldCF.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.releaseAll();
            }
            finally {
                super.finalize();
            }
        }
    }
}

