/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class DBInterfaceDerby
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceDerby.java 1001023 2010-09-24 18:41:28Z kwright $";
    protected static final String _url = "jdbc:derby:";
    protected static final String _driver = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String databasePathProperty = "org.apache.manifoldcf.derbydatabasepath";
    protected ILockManager lockManager;
    protected String userName;
    protected String password;
    protected String cacheKey;
    protected int serializableDepth = 0;
    int depthCount = 0;
    boolean inTransaction = false;
    protected ArrayList tablesToAnalyze = new ArrayList();
    protected ArrayList tablesToReindex = new ArrayList();
    protected static Map currentReindexStatistics = new HashMap();
    protected static Map reindexThresholds = new HashMap();
    protected static Map currentAnalyzeStatistics = new HashMap();
    protected static Map analyzeThresholds = new HashMap();
    protected static final int commitThreshold = 100;
    protected static final String statslockReindexPrefix = "statslock-reindex-";
    protected static final String statsReindexPrefix = "stats-reindex-";
    protected static final String statslockAnalyzePrefix = "statslock-analyze-";
    protected static final String statsAnalyzePrefix = "stats-analyze-";

    protected static String getFullDatabasePath(String databaseName) throws ManifoldCFException {
        File path = ManifoldCF.getFileProperty(databasePathProperty);
        if (path == null) {
            throw new ManifoldCFException("Derby database requires 'org.apache.manifoldcf.derbydatabasepath' property, containing a relative path");
        }
        String pathString = path.toString().replace("\\\\", "/");
        if (!pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        return pathString + databaseName;
    }

    public DBInterfaceDerby(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, _url + DBInterfaceDerby.getFullDatabasePath(databaseName) + ";user=" + userName + ";password=" + password, _driver, DBInterfaceDerby.getFullDatabasePath(databaseName), userName, password);
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
        this.lockManager = LockManagerFactory.make(tc);
        this.userName = userName;
        this.password = password;
    }

    public void openDatabase() throws ManifoldCFException {
        try {
            Class.forName(_driver).newInstance();
            DriverManager.getConnection(_url + this.databaseName + ";create=true;user=" + this.userName + ";password=" + this.password, this.userName, this.password).close();
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), e, 3);
        }
    }

    public void closeDatabase() throws ManifoldCFException {
        try {
            Class.forName(_driver).newInstance();
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
        try {
            DriverManager.getConnection(_url + this.databaseName + ";shutdown=true;user=" + this.userName + ";password=" + this.password, this.userName, this.password).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    public void performLock(String tableName) throws ManifoldCFException {
        this.performModification("LOCK TABLE " + tableName + " IN EXCLUSIVE MODE", null, null);
    }

    public void performInsert(String tableName, Map parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList paramArray = new ArrayList();
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuffer values = new StringBuffer(" VALUES (");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append(values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performUpdate(String tableName, Map parameterMap, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performDelete(String tableName, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    public void performCreate(String tableName, Map columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        boolean constraintNumber = false;
        StringBuffer queryBuffer = new StringBuffer("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            ColumnDescription cd = (ColumnDescription)columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            this.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected void appendDescription(StringBuffer queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) throws ManifoldCFException {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfaceDerby.mapType(cd.getTypeString()));
        if (!forceNull && !cd.getIsNull()) {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" CONSTRAINT c" + IDFactory.make(this.context) + " PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" CONSTRAINT c" + IDFactory.make(this.context) + " REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    public void performAlter(String tableName, Map columnMap, Map columnModifyMap, ArrayList columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            ColumnDescription cd;
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = (String)columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    cd = (ColumnDescription)columnModifyMap.get(columnName);
                    String renameColumn = "__temp__";
                    this.performModification("RENAME COLUMN " + tableName + "." + columnName + " TO " + renameColumn, null, invalidateKeys);
                    StringBuffer sb = new StringBuffer();
                    this.appendDescription(sb, columnName, cd, true);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + columnName + "=" + renameColumn, null, invalidateKeys);
                    if (!cd.getIsNull()) {
                        this.performModification("ALTER TABLE " + tableName + " ALTER " + columnName + " SET NOT NULL", null, invalidateKeys);
                    }
                    this.performModification("ALTER TABLE " + tableName + " DROP " + renameColumn, null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    cd = (ColumnDescription)columnMap.get(columnName);
                    StringBuffer sb = new StringBuffer();
                    this.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "CLOB";
        }
        return inputType;
    }

    public void addTableIndex(String tableName, boolean unique, ArrayList columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (String)columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuffer queryBuffer = new StringBuffer("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    public void performRemoveIndex(String indexName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    protected int readDatum(String datumName) throws ManifoldCFException {
        byte[] bytes = this.lockManager.readData(datumName);
        if (bytes == null) {
            return 0;
        }
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    protected void writeDatum(String datumName, int value) throws ManifoldCFException {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.lockManager.writeData(datumName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockAnalyzePrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = (TableStatistics)currentAnalyzeStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsAnalyzePrefix + tableName;
                this.analyzeTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockReindexPrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = (TableStatistics)currentReindexStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsReindexPrefix + tableName;
                this.reindexTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    protected void analyzeTableInternal(String tableName) throws ManifoldCFException {
        if (this.getTransactionID() == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("APP");
            list.add(tableName.toUpperCase());
            this.performModification("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS(?,?,null)", list, null);
        } else {
            this.tablesToAnalyze.add(tableName);
        }
    }

    protected void reindexTableInternal(String tableName) throws ManifoldCFException {
        block10: {
            if (this.getTransactionID() == null) {
                long sleepAmt = 0L;
                while (true) {
                    try {
                        Map x = this.getTableIndexes(tableName, null, null);
                        for (String indexName : x.keySet()) {
                            IndexDescription id = (IndexDescription)x.get(indexName);
                            this.performRemoveIndex(indexName);
                            this.performAddIndex(indexName, tableName, id);
                        }
                        break block10;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 6) {
                            sleepAmt = this.getSleepAmt();
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            this.tablesToReindex.add(tableName);
        }
    }

    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        Database rootDatabase;
        block3: {
            rootDatabase = new Database(this.context, _url + this.databaseName, _driver, this.databaseName, "", "");
            IResultSet set = rootDatabase.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.user." + this.userName + "')", null, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                rootDatabase.executeQuery("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user." + this.userName + "', '" + this.password + "')", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("CREATE SCHEMA " + this.userName + " AUTHORIZATION " + this.userName, null, invalidateKeys, null, null, false, 0, null, null);
            }
            try {
                rootDatabase.executeQuery("DROP FUNCTION CASEINSENSITIVEREGULAREXPRESSIONCOMPARE", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASESENSITIVEREGULAREXPRESSIONCOMPARE", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASEINSENSITIVESUBSTRING", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASESENSITIVESUBSTRING", null, invalidateKeys, null, null, false, 0, null, null);
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() != 2) break block3;
                throw e;
            }
        }
        rootDatabase.executeQuery("CREATE FUNCTION CASEINSENSITIVEREGULAREXPRESSIONCOMPARE (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseInsensitiveRegularExpressionCompare'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASESENSITIVEREGULAREXPRESSIONCOMPARE (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseSensitiveRegularExpressionCompare'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASEINSENSITIVESUBSTRING (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseInsensitiveSubstring'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASESENSITIVESUBSTRING (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseSensitiveSubstring'", null, invalidateKeys, null, null, false, 0, null, null);
    }

    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        File f = new File(this.databaseName);
        if (f.exists()) {
            ConnectionFactory.releaseAll();
            this.closeDatabase();
            DBInterfaceDerby.recursiveDelete(f);
        }
    }

    protected static void recursiveDelete(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File newf;
                if ((newf = files[i++]).isDirectory()) {
                    DBInterfaceDerby.recursiveDelete(newf);
                    continue;
                }
                newf.delete();
            }
        }
        if (!f.delete()) {
            System.out.println("Failed to delete file " + f.toString());
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("23505") && this.inTransaction) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    public void performModification(String query, ArrayList params, StringSet invalidateKeys) throws ManifoldCFException {
        while (true) {
            try {
                this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
                return;
            }
            catch (ManifoldCFException e) {
                try {
                    throw this.reinterpretException(e);
                }
                catch (ManifoldCFException e2) {
                    if (e2.getErrorCode() != 6) {
                        throw e2;
                    }
                    if (this.inTransaction) {
                        throw e2;
                    }
                    try {
                        ManifoldCF.sleep(1000L);
                    }
                    catch (InterruptedException e22) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                }
            }
        }
    }

    public Map getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        String query = "SELECT CAST(t0.columnname AS VARCHAR(128)) AS columnname,CAST(t0.columndatatype AS VARCHAR(128)) AS columndatatype FROM sys.syscolumns t0, sys.systables t1 WHERE t0.referenceid=t1.tableid AND CAST(t1.tablename AS VARCHAR(128))=? ORDER BY t0.columnnumber ASC";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName.toUpperCase());
        IResultSet set = this.performQuery(query, list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = ((String)row.getValue("columnname")).toLowerCase();
            String type = (String)row.getValue("columndatatype");
            boolean isNull = false;
            boolean isPrimaryKey = false;
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    public Map getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT t0.conglomeratename FROM sys.sysconglomerates t0,sys.systables t1 WHERE t0.tableid=t1.tableid AND t0.isindex IS NOT NULL AND CAST(t1.tablename AS VARCHAR(128))=?";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName);
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String indexName = (String)row.getValue("conglomeratename");
            rval.put(indexName, new IndexDescription(false, new String[0]));
        }
        return rval;
    }

    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT CAST(tablename AS VARCHAR(128)) FROM sys.systables WHERE table_type='T'", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "tablename";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        if (caseInsensitive) {
            return "CASEINSENSITIVEREGULAREXPRESSIONCOMPARE(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")='true'";
        }
        return "CASESENSITIVEREGULAREXPRESSIONCOMPARE(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")='true'";
    }

    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        if (caseInsensitive) {
            return "CASEINSENSITIVESUBSTRING(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")";
        }
        return "CASESENSITIVESUBSTRING(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")";
    }

    public String constructOffsetLimitClause(int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset)).append(" ROWS");
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("FETCH NEXT ").append(Integer.toString(limit)).append(" ROWS ONLY");
        }
        return sb.toString();
    }

    public String constructDistinctOnClause(ArrayList outputParameters, String baseQuery, ArrayList baseParameters, String[] distinctFields, Map otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = (String)otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        return sb.toString();
    }

    public int getMaxInClause() {
        return 100;
    }

    public int getMaxOrClause() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteModifications(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
        block23: {
            int oldEventCount;
            String eventDatum;
            TableStatistics ts;
            Integer threshold;
            String tableStatisticsLock;
            int eventCount;
            block22: {
                eventCount = modifyCount + deleteCount;
                tableStatisticsLock = statslockReindexPrefix + tableName;
                this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
                try {
                    int reindexThreshold;
                    threshold = (Integer)reindexThresholds.get(tableName);
                    if (threshold == null) {
                        reindexThreshold = ManifoldCF.getIntProperty("org.apache.manifold.db.derby.reindex." + tableName, 250000);
                        reindexThresholds.put(tableName, new Integer(reindexThreshold));
                    } else {
                        reindexThreshold = threshold;
                    }
                    ts = (TableStatistics)currentReindexStatistics.get(tableName);
                    if (ts == null) {
                        ts = new TableStatistics();
                        currentReindexStatistics.put(tableName, ts);
                    }
                    ts.add(eventCount);
                    if (ts.getEventCount() < 100) break block22;
                    this.lockManager.enterWriteLock(tableStatisticsLock);
                    try {
                        eventDatum = statsReindexPrefix + tableName;
                        oldEventCount = this.readDatum(eventDatum);
                        if ((oldEventCount += ts.getEventCount()) >= reindexThreshold) {
                            this.reindexTableInternal(tableName);
                            this.writeDatum(eventDatum, 0);
                        } else {
                            this.writeDatum(eventDatum, oldEventCount);
                        }
                        ts.reset();
                    }
                    finally {
                        this.lockManager.leaveWriteLock(tableStatisticsLock);
                    }
                }
                finally {
                    this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
                }
            }
            eventCount = modifyCount + insertCount;
            tableStatisticsLock = statslockAnalyzePrefix + tableName;
            this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
            try {
                int analyzeThreshold;
                threshold = (Integer)analyzeThresholds.get(tableName);
                if (threshold == null) {
                    analyzeThreshold = ManifoldCF.getIntProperty("org.apache.manifold.db.derby.analyze." + tableName, 5000);
                    analyzeThresholds.put(tableName, new Integer(analyzeThreshold));
                } else {
                    analyzeThreshold = threshold;
                }
                ts = (TableStatistics)currentAnalyzeStatistics.get(tableName);
                if (ts == null) {
                    ts = new TableStatistics();
                    currentAnalyzeStatistics.put(tableName, ts);
                }
                ts.add(eventCount);
                if (ts.getEventCount() < 100) break block23;
                this.lockManager.enterWriteLock(tableStatisticsLock);
                try {
                    eventDatum = statsAnalyzePrefix + tableName;
                    oldEventCount = this.readDatum(eventDatum);
                    if ((oldEventCount += ts.getEventCount()) >= analyzeThreshold) {
                        this.analyzeTableInternal(tableName);
                        this.writeDatum(eventDatum, 0);
                    } else {
                        this.writeDatum(eventDatum, oldEventCount);
                    }
                    ts.reset();
                }
                finally {
                    this.lockManager.leaveWriteLock(tableStatisticsLock);
                }
            }
            finally {
                this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
            }
        }
    }

    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = super.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                try {
                    this.executeViaThread(this.connection, "SET ISOLATION READ COMMITTED", null, false, 0, null, null);
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                super.beginTransaction(1);
                break;
            }
            case 2: {
                try {
                    this.executeViaThread(this.connection, "SET ISOLATION SERIALIZABLE", null, false, 0, null, null);
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                super.beginTransaction(2);
                break;
            }
            default: {
                throw new ManifoldCFException("Bad transaction type");
            }
        }
    }

    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
        if (this.getTransactionID() == null) {
            int i = 0;
            while (i < this.tablesToAnalyze.size()) {
                this.analyzeTableInternal((String)this.tablesToAnalyze.get(i++));
            }
            this.tablesToAnalyze.clear();
            i = 0;
            while (i < this.tablesToReindex.size()) {
                this.reindexTableInternal((String)this.tablesToReindex.get(i++));
            }
            this.tablesToReindex.clear();
        }
    }

    protected void startATransaction() throws ManifoldCFException {
        if (!this.inTransaction) {
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ManifoldCFException(e.getMessage(), e, 4);
            }
            this.inTransaction = true;
        }
        ++this.depthCount;
    }

    protected void commitCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.commit();
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.rollback();
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    protected String mapColumnName(String rawColumnName) {
        return rawColumnName.toLowerCase();
    }

    public static String caseInsensitiveRegularExpressionCompare(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 2);
            Matcher m = p.matcher(value);
            if (m.find()) {
                return "true";
            }
            return "false";
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseSensitiveRegularExpressionCompare(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 0);
            Matcher m = p.matcher(value);
            if (m.find()) {
                return "true";
            }
            return "false";
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseInsensitiveSubstring(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 2);
            Matcher m = p.matcher(value);
            if (m.find()) {
                return m.group(1);
            }
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return value;
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseSensitiveSubstring(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 0);
            Matcher m = p.matcher(value);
            if (m.find()) {
                return m.group(1);
            }
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return value;
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    static {
        System.setProperty("derby.locks.waitTimeout", "-1");
    }

    protected static class TableStatistics {
        protected int eventCount = 0;

        public void reset() {
            this.eventCount = 0;
        }

        public void add(int eventCount) {
            this.eventCount += eventCount;
        }

        public int getEventCount() {
            return this.eventCount;
        }
    }
}

