/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class DBInterfaceHSQLDB
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceHSQLDB.java 1082484 2011-03-17 13:30:26Z kwright $";
    private static final String _url = "jdbc:hsqldb:file:";
    private static final String _driver = "org.hsqldb.jdbcDriver";
    public static final String databasePathProperty = "org.apache.manifoldcf.hsqldbdatabasepath";
    protected String cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
    protected int serializableDepth = 0;
    protected int depthCount = 0;
    protected boolean inTransaction = false;
    protected int desiredTransactionType = 2;

    public DBInterfaceHSQLDB(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, _url + DBInterfaceHSQLDB.getFullDatabasePath(databaseName), _driver, DBInterfaceHSQLDB.getFullDatabasePath(databaseName), userName, password);
        this.userName = userName;
        this.password = password;
    }

    protected static String getFullDatabasePath(String databaseName) throws ManifoldCFException {
        File path = ManifoldCF.getFileProperty(databasePathProperty);
        if (path == null) {
            throw new ManifoldCFException("HSQLDB database requires 'org.apache.manifoldcf.hsqldbdatabasepath' property, containing a relative path");
        }
        String pathString = path.toString().replace("\\\\", "/");
        if (!pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        return pathString + databaseName;
    }

    public void openDatabase() throws ManifoldCFException {
        try {
            Class.forName(_driver).newInstance();
            DriverManager.getConnection(_url + this.databaseName, this.userName, this.password).close();
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), e, 3);
        }
    }

    public void closeDatabase() throws ManifoldCFException {
        try {
            Class.forName(_driver).newInstance();
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
        try {
            DriverManager.getConnection(_url + this.databaseName + ";shutdown=true", this.userName, this.password).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    public void performLock(String tableName) throws ManifoldCFException {
        this.performModification("LOCK TABLE " + tableName + " WRITE", null, null);
    }

    public void performInsert(String tableName, Map parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList paramArray = new ArrayList();
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuffer values = new StringBuffer(" VALUES (");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append(values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performUpdate(String tableName, Map parameterMap, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performDelete(String tableName, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    public void performCreate(String tableName, Map columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer queryBuffer = new StringBuffer("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            ColumnDescription cd = (ColumnDescription)columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            DBInterfaceHSQLDB.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected static void appendDescription(StringBuffer queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfaceHSQLDB.mapType(cd.getTypeString()));
        if (forceNull || cd.getIsNull()) {
            queryBuffer.append(" NULL");
        } else {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    public void performAlter(String tableName, Map columnMap, Map columnModifyMap, ArrayList columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = (String)columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE " + tableName + " DROP " + columnName + " RESTRICT", null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    ColumnDescription cd = (ColumnDescription)columnModifyMap.get(columnName);
                    String renameColumn = "__temp__";
                    StringBuffer sb = new StringBuffer();
                    DBInterfaceHSQLDB.appendDescription(sb, renameColumn, cd, true);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + renameColumn + "=" + columnName, null, invalidateKeys);
                    this.performModification("ALTER TABLE " + tableName + " DROP " + columnName + " RESTRICT", null, invalidateKeys);
                    sb = new StringBuffer();
                    DBInterfaceHSQLDB.appendDescription(sb, columnName, cd, true);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + columnName + "=" + renameColumn, null, invalidateKeys);
                    if (!cd.getIsNull()) {
                        this.performModification("ALTER TABLE " + tableName + " ALTER " + columnName + " SET NOT NULL", null, invalidateKeys);
                    }
                    this.performModification("ALTER TABLE " + tableName + " DROP " + renameColumn + " RESTRICT", null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    ColumnDescription cd = (ColumnDescription)columnMap.get(columnName);
                    StringBuffer sb = new StringBuffer();
                    DBInterfaceHSQLDB.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "clob";
        }
        return inputType;
    }

    public void addTableIndex(String tableName, boolean unique, ArrayList columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (String)columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuffer queryBuffer = new StringBuffer("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    public void performRemoveIndex(String indexName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    public void analyzeTable(String tableName) throws ManifoldCFException {
    }

    public void reindexTable(String tableName) throws ManifoldCFException {
    }

    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
    }

    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        File f = new File(this.databaseName);
        if (f.exists()) {
            ConnectionFactory.releaseAll();
            this.closeDatabase();
            DBInterfaceHSQLDB.recursiveDelete(f);
        }
    }

    protected static void recursiveDelete(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File newf;
                if ((newf = files[i++]).isDirectory()) {
                    DBInterfaceHSQLDB.recursiveDelete(newf);
                    continue;
                }
                newf.delete();
            }
        }
        if (!f.delete()) {
            System.out.println("Failed to delete file " + f.toString());
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40P01")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    public void performModification(String query, ArrayList params, StringSet invalidateKeys) throws ManifoldCFException {
        try {
            this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public Map getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        StringBuffer query = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName.toUpperCase());
        query.append("SELECT column_name, is_nullable, data_type, character_maximum_length ").append("FROM INFORMATION_SCHEMA.COLUMNS WHERE table_schema='PUBLIC' AND table_name=?");
        IResultSet set = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        query = new StringBuffer();
        query.append("SELECT column_name ").append("FROM INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS WHERE table_schem='PUBLIC' AND table_name=?");
        IResultSet primarySet = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        String primaryKey = null;
        if (primarySet.getRowCount() != 0) {
            primaryKey = ((String)primarySet.getRow(0).getValue("column_name")).toLowerCase();
        }
        if (primaryKey == null) {
            primaryKey = "";
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = ((String)row.getValue("column_name")).toLowerCase();
            String type = (String)row.getValue("data_type");
            Long width = (Long)row.getValue("character_maximum_length");
            String isNullable = (String)row.getValue("is_nullable");
            boolean isPrimaryKey = primaryKey.equals(fieldName);
            boolean isNull = isNullable.equals("YES");
            String dataType = type.equals("CHARACTER VARYING") ? "VARCHAR(" + width.toString() + ")" : (type.equals("CLOB") ? "LONGVARCHAR" : type);
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    public Map getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap rval = new HashMap();
        String query = "SELECT index_name,column_name,non_unique,ordinal_position FROM INFORMATION_SCHEMA.SYSTEM_INDEXINFO WHERE table_schem='PUBLIC' AND TABLE_NAME=? ORDER BY index_name,ordinal_position ASC";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName.toUpperCase());
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        String lastIndexName = null;
        ArrayList<String> indexColumns = null;
        boolean isUnique = false;
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String indexName = ((String)row.getValue("index_name")).toLowerCase();
            String columnName = ((String)row.getValue("column_name")).toLowerCase();
            String nonUnique = row.getValue("non_unique").toString();
            if (lastIndexName != null && !lastIndexName.equals(indexName)) {
                this.addIndex(rval, lastIndexName, isUnique, indexColumns);
                lastIndexName = null;
                indexColumns = null;
                isUnique = false;
            }
            if (lastIndexName == null) {
                lastIndexName = indexName;
                indexColumns = new ArrayList<String>();
                isUnique = false;
            }
            indexColumns.add(columnName);
            isUnique = nonUnique.equals("false");
        }
        if (lastIndexName != null) {
            this.addIndex(rval, lastIndexName, isUnique, indexColumns);
        }
        return rval;
    }

    protected void addIndex(Map rval, String indexName, boolean isUnique, ArrayList indexColumns) {
        if (indexName.indexOf("sys_idx") != -1) {
            return;
        }
        String[] columnNames = new String[indexColumns.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = (String)indexColumns.get(i);
        }
        rval.put(indexName, new IndexDescription(isUnique, columnNames));
    }

    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema='PUBLIC'", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "table_name";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return "REGEXP_MATCHES(" + column + "," + regularExpression + ")";
    }

    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        return "''";
    }

    public String constructOffsetLimitClause(int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("LIMIT ").append(Integer.toString(limit));
        }
        return sb.toString();
    }

    public String constructDistinctOnClause(ArrayList outputParameters, String baseQuery, ArrayList baseParameters, String[] distinctFields, Map otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = (String)otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        return sb.toString();
    }

    public int getMaxInClause() {
        return 100;
    }

    public int getMaxOrClause() {
        return 25;
    }

    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = this.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                this.desiredTransactionType = 2;
                super.beginTransaction(1);
                break;
            }
            case 2: {
                this.desiredTransactionType = 8;
                super.beginTransaction(2);
                break;
            }
            default: {
                throw new ManifoldCFException("Bad transaction type: " + Integer.toString(transactionType));
            }
        }
    }

    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
    }

    protected void startATransaction() throws ManifoldCFException {
        if (!this.inTransaction) {
            try {
                this.connection.setAutoCommit(false);
                this.connection.setTransactionIsolation(this.desiredTransactionType);
            }
            catch (SQLException e) {
                throw new ManifoldCFException(e.getMessage(), e, 4);
            }
            this.inTransaction = true;
        }
        ++this.depthCount;
    }

    protected void commitCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.commit();
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.rollback();
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    protected String mapColumnName(String rawColumnName) {
        return rawColumnName.toLowerCase();
    }
}

