/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;

public class DBInterfaceMySQL
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceMySQL.java 999670 2010-09-21 22:18:19Z kwright $";
    private static final String _url = "jdbc:mysql://localhost/";
    private static final String _driver = "org.gjt.mm.mysql.Driver";
    protected IThreadContext context;
    protected String cacheKey;

    public DBInterfaceMySQL(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, _url + databaseName, _driver, databaseName, userName, password);
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
    }

    public void openDatabase() throws ManifoldCFException {
    }

    public void closeDatabase() throws ManifoldCFException {
    }

    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    public void performLock(String tableName) throws ManifoldCFException {
        this.performModification("LOCK TABLE " + tableName + " IN EXCLUSIVE MODE", null, null);
    }

    public void performInsert(String tableName, Map parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList paramArray = new ArrayList();
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuffer values = new StringBuffer(" VALUES (");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append(values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performUpdate(String tableName, Map parameterMap, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performDelete(String tableName, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    public void performCreate(String tableName, Map columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer queryBuffer = new StringBuffer("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            ColumnDescription cd = (ColumnDescription)columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            queryBuffer.append(columnName);
            queryBuffer.append(' ');
            queryBuffer.append(cd.getTypeString());
            if (cd.getIsNull()) {
                queryBuffer.append(" NULL");
            } else {
                queryBuffer.append(" NOT NULL");
            }
            if (cd.getIsPrimaryKey()) {
                queryBuffer.append(" PRIMARY KEY");
            }
            if (cd.getReferenceTable() == null) continue;
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
                continue;
            }
            queryBuffer.append(" RESTRICT");
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    public void performAlter(String tableName, Map columnMap, Map columnModifyMap, ArrayList columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
    }

    public void addTableIndex(String tableName, boolean unique, ArrayList columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (String)columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuffer queryBuffer = new StringBuffer("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    public void performRemoveIndex(String indexName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    public void analyzeTable(String tableName) throws ManifoldCFException {
    }

    public void reindexTable(String tableName) throws ManifoldCFException {
    }

    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        Database masterDatabase = new Database(this.context, "jdbc:mysql://localhost/mysql", _driver, "mysql", adminUserName, adminPassword);
        ArrayList<String> list = new ArrayList<String>();
        list.add("utf8");
        masterDatabase.executeQuery("CREATE DATABASE " + this.databaseName + " CHARACTER SET ?", list, null, invalidateKeys, null, false, 0, null, null);
        if (this.userName != null) {
            list.clear();
            list.add(this.userName);
            list.add("localhost");
            list.add(this.password);
            masterDatabase.executeQuery("GRANT ALL ON " + this.databaseName + ".* TO ?@? IDENTIFIED BY ?", list, null, invalidateKeys, null, false, 0, null, null);
        }
    }

    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        Database masterDatabase = new Database(this.context, "jdbc:mysql://localhost/mysql", _driver, "mysql", adminUserName, adminPassword);
        masterDatabase.executeQuery("DROP DATABASE " + this.databaseName, null, null, invalidateKeys, null, false, 0, null, null);
    }

    public void performModification(String query, ArrayList params, StringSet invalidateKeys) throws ManifoldCFException {
        this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
    }

    public Map getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("DESCRIBE " + tableName, null, cacheKeys, queryClass);
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = row.getValue("Field").toString();
            String type = row.getValue("Type").toString();
            boolean isNull = row.getValue("Null").toString().equals("YES");
            boolean isPrimaryKey = row.getValue("Key").toString().equals("PRI");
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    public Map getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        return null;
    }

    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SHOW TABLES", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "Tables_in_" + this.databaseName.toLowerCase();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
    }

    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return column + " LIKE " + regularExpression;
    }

    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        return regularExpression;
    }

    public String constructOffsetLimitClause(int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("LIMIT ").append(Integer.toString(limit));
        }
        return sb.toString();
    }

    public String constructDistinctOnClause(ArrayList outputParameters, String baseQuery, ArrayList baseParameters, String[] distinctFields, Map otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = (String)otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        return sb.toString();
    }

    public int getMaxInClause() {
        return 100;
    }

    public int getMaxOrClause() {
        return 25;
    }

    public void beginTransaction() throws ManifoldCFException {
        super.beginTransaction(1);
    }

    public void beginTransaction(int transactionType) throws ManifoldCFException {
        super.beginTransaction(1);
    }

    protected void startATransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "START TRANSACTION", null, false, 0, null, null);
    }

    protected void commitCurrentTransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "COMMIT", null, false, 0, null, null);
    }

    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "ROLLBACK", null, false, 0, null, null);
    }
}

