/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class DBInterfacePostgreSQL
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfacePostgreSQL.java 999670 2010-09-21 22:18:19Z kwright $";
    public static final String postgresqlHostnameProperty = "org.apache.manifoldcf.postgresql.hostname";
    public static final String postgresqlPortProperty = "org.apache.manifoldcf.postgresql.port";
    public static final String postgresqlSslProperty = "org.apache.manifoldcf.postgresql.ssl";
    private static final String _defaultUrl = "jdbc:postgresql://localhost/";
    private static final String _driver = "org.postgresql.Driver";
    protected ILockManager lockManager;
    protected String cacheKey;
    protected int serializableDepth = 0;
    protected ArrayList tablesToAnalyze = new ArrayList();
    protected ArrayList tablesToReindex = new ArrayList();
    protected static Map currentReindexStatistics = new HashMap();
    protected static Map reindexThresholds = new HashMap();
    protected static Map currentAnalyzeStatistics = new HashMap();
    protected static Map analyzeThresholds = new HashMap();
    protected static final int commitThreshold = 100;
    protected static final String statslockReindexPrefix = "statslock-reindex-";
    protected static final String statsReindexPrefix = "stats-reindex-";
    protected static final String statslockAnalyzePrefix = "statslock-analyze-";
    protected static final String statsAnalyzePrefix = "stats-analyze-";

    public DBInterfacePostgreSQL(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, DBInterfacePostgreSQL.getJdbcUrl(databaseName), _driver, databaseName, userName, password);
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
        this.lockManager = LockManagerFactory.make(tc);
    }

    private static String getJdbcUrl(String databaseName) {
        String jdbcUrl = _defaultUrl + databaseName;
        String hostname = ManifoldCF.getProperty(postgresqlHostnameProperty);
        String ssl = ManifoldCF.getProperty(postgresqlSslProperty);
        String port = ManifoldCF.getProperty(postgresqlPortProperty);
        if (hostname != null && hostname.length() > 0) {
            jdbcUrl = "jdbc:postgresql://" + hostname;
            if (port != null && port.length() > 0) {
                jdbcUrl = jdbcUrl + ":" + port;
            }
            jdbcUrl = jdbcUrl + "/" + databaseName;
            if (ssl != null && ssl.equals("true")) {
                jdbcUrl = jdbcUrl + "?ssl=true";
            }
        }
        return jdbcUrl;
    }

    public void openDatabase() throws ManifoldCFException {
    }

    public void closeDatabase() throws ManifoldCFException {
    }

    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    public void performLock(String tableName) throws ManifoldCFException {
        this.performModification("LOCK TABLE " + tableName + " IN EXCLUSIVE MODE", null, null);
    }

    public void performInsert(String tableName, Map parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList paramArray = new ArrayList();
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuffer values = new StringBuffer(" VALUES (");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append(values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performUpdate(String tableName, Map parameterMap, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    public void performDelete(String tableName, String whereClause, ArrayList whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    public void performCreate(String tableName, Map columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuffer queryBuffer = new StringBuffer("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            ColumnDescription cd = (ColumnDescription)columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            DBInterfacePostgreSQL.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected static void appendDescription(StringBuffer queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfacePostgreSQL.mapType(cd.getTypeString()));
        if (forceNull || cd.getIsNull()) {
            queryBuffer.append(" NULL");
        } else {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    public void performAlter(String tableName, Map columnMap, Map columnModifyMap, ArrayList columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            ColumnDescription cd;
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = (String)columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    cd = (ColumnDescription)columnModifyMap.get(columnName);
                    String renameColumn = "__temp__";
                    this.performModification("ALTER TABLE ONLY " + tableName + " RENAME " + columnName + " TO " + renameColumn, null, invalidateKeys);
                    StringBuffer sb = new StringBuffer();
                    DBInterfacePostgreSQL.appendDescription(sb, columnName, cd, true);
                    this.performModification("ALTER TABLE ONLY " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + columnName + "=" + renameColumn, null, invalidateKeys);
                    if (!cd.getIsNull()) {
                        this.performModification("ALTER TABLE ONLY " + tableName + " ALTER " + columnName + " SET NOT NULL", null, invalidateKeys);
                    }
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + renameColumn, null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    cd = (ColumnDescription)columnMap.get(columnName);
                    StringBuffer sb = new StringBuffer();
                    DBInterfacePostgreSQL.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE ONLY " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "text";
        }
        if (inputType.equalsIgnoreCase("blob")) {
            return "bytea";
        }
        return inputType;
    }

    public void addTableIndex(String tableName, boolean unique, ArrayList columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (String)columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuffer queryBuffer = new StringBuffer("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    public void performRemoveIndex(String indexName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        Database masterDatabase = new Database(this.context, DBInterfacePostgreSQL.getJdbcUrl("template1"), _driver, "template1", adminUserName, adminPassword);
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.userName);
            IResultSet set = masterDatabase.executeQuery("SELECT * FROM pg_user WHERE usename=?", params, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("'");
                for (int i = 0; i < this.password.length(); ++i) {
                    char x = this.password.charAt(i);
                    if (x == '\'') {
                        sb.append("'");
                    }
                    sb.append(x);
                }
                sb.append("'");
                String quotedPassword = sb.toString();
                masterDatabase.executeQuery("CREATE USER " + this.userName + " PASSWORD " + quotedPassword, null, null, invalidateKeys, null, false, 0, null, null);
            }
            params.clear();
            params.add(this.databaseName);
            set = masterDatabase.executeQuery("SELECT * FROM pg_database WHERE datname=?", params, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                masterDatabase.executeQuery("CREATE DATABASE " + this.databaseName + " OWNER " + this.userName + " ENCODING 'utf8'", null, null, invalidateKeys, null, false, 0, null, null);
            }
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        Database masterDatabase = new Database(this.context, DBInterfacePostgreSQL.getJdbcUrl("template1"), _driver, "template1", adminUserName, adminPassword);
        try {
            masterDatabase.executeQuery("DROP DATABASE " + this.databaseName, null, null, invalidateKeys, null, false, 0, null, null);
            masterDatabase.executeQuery("DROP USER " + this.userName, null, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40P01")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    public void performModification(String query, ArrayList params, StringSet invalidateKeys) throws ManifoldCFException {
        try {
            this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public Map getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        StringBuffer query = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        query.append("SELECT pg_attribute.attname AS \"Field\",");
        query.append("CASE pg_type.typname WHEN 'int2' THEN 'smallint' WHEN 'int4' THEN 'int'");
        query.append(" WHEN 'int8' THEN 'bigint' WHEN 'varchar' THEN 'varchar(' || pg_attribute.atttypmod-4 || ')'");
        query.append(" WHEN 'text' THEN 'longtext'");
        query.append(" WHEN 'bpchar' THEN 'char(' || pg_attribute.atttypmod-4 || ')'");
        query.append(" ELSE pg_type.typname END AS \"Type\",");
        query.append("CASE WHEN pg_attribute.attnotnull THEN '' ELSE 'YES' END AS \"Null\",");
        query.append("CASE pg_type.typname WHEN 'varchar' THEN substring(pg_attrdef.adsrc from '^(.*).*$') ELSE pg_attrdef.adsrc END AS Default ");
        query.append("FROM pg_class INNER JOIN pg_attribute ON (pg_class.oid=pg_attribute.attrelid) INNER JOIN pg_type ON (pg_attribute.atttypid=pg_type.oid) ");
        query.append("LEFT JOIN pg_attrdef ON (pg_class.oid=pg_attrdef.adrelid AND pg_attribute.attnum=pg_attrdef.adnum) ");
        query.append("WHERE pg_class.relname=? AND pg_attribute.attnum>=1 AND NOT pg_attribute.attisdropped ");
        query.append("ORDER BY pg_attribute.attnum");
        list.add(tableName);
        IResultSet set = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = row.getValue("Field").toString();
            String type = row.getValue("Type").toString();
            boolean isNull = row.getValue("Null").toString().equals("YES");
            boolean isPrimaryKey = false;
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    public Map getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT pg_catalog.pg_get_indexdef(i.indexrelid, 0, true) AS indexdef FROM pg_catalog.pg_class c, pg_catalog.pg_class c2, pg_catalog.pg_index i WHERE c.relname = ? AND c.oid = i.indrelid AND i.indexrelid = c2.oid";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName);
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        int i = 0;
        while (i < result.getRowCount()) {
            boolean isUnique;
            int parsePosition;
            IResultRow row;
            String indexdef;
            int beforeMatch;
            if ((beforeMatch = (indexdef = (String)(row = result.getRow(i++)).getValue("indexdef")).indexOf("CREATE UNIQUE INDEX ", parsePosition = 0)) == -1) {
                beforeMatch = indexdef.indexOf("CREATE INDEX ", parsePosition);
                if (beforeMatch == -1) {
                    throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
                }
                isUnique = false;
                parsePosition += "CREATE INDEX ".length();
            } else {
                isUnique = true;
                parsePosition += "CREATE UNIQUE INDEX ".length();
            }
            int afterMatch = indexdef.indexOf(" ON", parsePosition);
            if (afterMatch == -1) {
                throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
            }
            String indexName = indexdef.substring(parsePosition, afterMatch);
            parsePosition = afterMatch + " ON".length();
            int parenPosition = indexdef.indexOf("(", parsePosition);
            if (parenPosition == -1) {
                throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
            }
            parsePosition = parenPosition + 1;
            ArrayList<String> columns = new ArrayList<String>();
            while (true) {
                int nextIndex = indexdef.indexOf(",", parsePosition);
                int nextParenIndex = indexdef.indexOf(")", parsePosition);
                if (nextIndex == -1) {
                    nextIndex = nextParenIndex;
                }
                if (nextIndex == -1) {
                    throw new ManifoldCFException("Cannot parse index description: '" + indexdef + "'");
                }
                if (nextParenIndex != -1 && nextParenIndex < nextIndex) {
                    nextIndex = nextParenIndex;
                }
                String columnName = indexdef.substring(parsePosition, nextIndex).trim();
                columns.add(columnName);
                if (nextIndex == nextParenIndex) break;
                parsePosition = nextIndex + 1;
            }
            String[] columnNames = new String[columns.size()];
            for (int j = 0; j < columnNames.length; ++j) {
                columnNames[j] = (String)columns.get(j);
            }
            rval.put(indexName, new IndexDescription(isUnique, columnNames));
        }
        return rval;
    }

    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT relname FROM pg_class", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "relname";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public IResultSet performQuery(String query, ArrayList params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return column + "~" + (caseInsensitive ? "*" : "") + regularExpression;
    }

    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        StringBuffer sb = new StringBuffer();
        sb.append("SUBSTRING(");
        if (caseInsensitive) {
            sb.append("LOWER(").append(column).append(")");
        } else {
            sb.append(column);
        }
        sb.append(" FROM ");
        if (caseInsensitive) {
            sb.append("LOWER(").append(regularExpression).append(")");
        } else {
            sb.append(regularExpression);
        }
        sb.append(")");
        return sb.toString();
    }

    public String constructOffsetLimitClause(int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("LIMIT ").append(Integer.toString(limit));
        }
        return sb.toString();
    }

    public String constructDistinctOnClause(ArrayList outputParameters, String baseQuery, ArrayList baseParameters, String[] distinctFields, Map otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuffer sb = new StringBuffer("SELECT DISTINCT ON(");
        int i = 0;
        while (i < distinctFields.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(distinctFields[i++]);
        }
        sb.append(") ");
        Iterator iter = otherFields.keySet().iterator();
        boolean needComma = false;
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            String columnValue = (String)otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        return sb.toString();
    }

    public int getMaxInClause() {
        return 100;
    }

    public int getMaxOrClause() {
        return 25;
    }

    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = this.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                super.beginTransaction(1);
                break;
            }
            case 2: {
                super.beginTransaction(2);
                try {
                    this.performModification("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE", null, null);
                    break;
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
            }
            default: {
                throw new ManifoldCFException("Bad transaction type: " + Integer.toString(transactionType));
            }
        }
    }

    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
        if (this.getTransactionID() == null) {
            int i = 0;
            while (i < this.tablesToAnalyze.size()) {
                this.analyzeTableInternal((String)this.tablesToAnalyze.get(i++));
            }
            this.tablesToAnalyze.clear();
            i = 0;
            while (i < this.tablesToReindex.size()) {
                this.reindexTableInternal((String)this.tablesToReindex.get(i++));
            }
            this.tablesToReindex.clear();
        }
    }

    protected void startATransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "START TRANSACTION", null, false, 0, null, null);
    }

    protected void commitCurrentTransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "COMMIT", null, false, 0, null, null);
    }

    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        this.executeViaThread(this.connection, "ROLLBACK", null, false, 0, null, null);
    }

    protected void explainQuery(String query, ArrayList params) throws ManifoldCFException {
        IResultSet x = this.executeUncachedQuery("EXPLAIN " + query, params, true, -1, null, null);
        int k = 0;
        while (k < x.getRowCount()) {
            IResultRow row = x.getRow(k++);
            Iterator iter = row.getColumns();
            String colName = (String)iter.next();
            Logging.db.warn((Object)(" Plan: " + row.getValue(colName).toString()));
        }
        Logging.db.warn((Object)"");
    }

    protected int readDatum(String datumName) throws ManifoldCFException {
        byte[] bytes = this.lockManager.readData(datumName);
        if (bytes == null) {
            return 0;
        }
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    protected void writeDatum(String datumName, int value) throws ManifoldCFException {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.lockManager.writeData(datumName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockAnalyzePrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = (TableStatistics)currentAnalyzeStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsAnalyzePrefix + tableName;
                this.analyzeTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockReindexPrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = (TableStatistics)currentReindexStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsReindexPrefix + tableName;
                this.reindexTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    protected void analyzeTableInternal(String tableName) throws ManifoldCFException {
        if (this.getTransactionID() == null) {
            this.performModification("ANALYZE " + tableName, null, null);
        } else {
            this.tablesToAnalyze.add(tableName);
        }
    }

    protected void reindexTableInternal(String tableName) throws ManifoldCFException {
        block9: {
            if (this.getTransactionID() == null) {
                long sleepAmt = 0L;
                while (true) {
                    try {
                        this.performModification("REINDEX TABLE " + tableName, null, null);
                        break block9;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 6) {
                            sleepAmt = this.getSleepAmt();
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            this.tablesToReindex.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteModifications(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
        block23: {
            int oldEventCount;
            String eventDatum;
            TableStatistics ts;
            Integer threshold;
            String tableStatisticsLock;
            int eventCount;
            block22: {
                eventCount = modifyCount + deleteCount;
                tableStatisticsLock = statslockReindexPrefix + tableName;
                this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
                try {
                    int reindexThreshold;
                    threshold = (Integer)reindexThresholds.get(tableName);
                    if (threshold == null) {
                        reindexThreshold = ManifoldCF.getIntProperty("org.apache.manifold.db.postgres.reindex." + tableName, 250000);
                        reindexThresholds.put(tableName, new Integer(reindexThreshold));
                    } else {
                        reindexThreshold = threshold;
                    }
                    ts = (TableStatistics)currentReindexStatistics.get(tableName);
                    if (ts == null) {
                        ts = new TableStatistics();
                        currentReindexStatistics.put(tableName, ts);
                    }
                    ts.add(eventCount);
                    if (ts.getEventCount() < 100) break block22;
                    this.lockManager.enterWriteLock(tableStatisticsLock);
                    try {
                        eventDatum = statsReindexPrefix + tableName;
                        oldEventCount = this.readDatum(eventDatum);
                        if ((oldEventCount += ts.getEventCount()) >= reindexThreshold) {
                            this.reindexTableInternal(tableName);
                            this.writeDatum(eventDatum, 0);
                        } else {
                            this.writeDatum(eventDatum, oldEventCount);
                        }
                        ts.reset();
                    }
                    finally {
                        this.lockManager.leaveWriteLock(tableStatisticsLock);
                    }
                }
                finally {
                    this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
                }
            }
            eventCount = modifyCount + insertCount;
            tableStatisticsLock = statslockAnalyzePrefix + tableName;
            this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
            try {
                int analyzeThreshold;
                threshold = (Integer)analyzeThresholds.get(tableName);
                if (threshold == null) {
                    analyzeThreshold = ManifoldCF.getIntProperty("org.apache.manifold.db.postgres.analyze." + tableName, 5000);
                    analyzeThresholds.put(tableName, new Integer(analyzeThreshold));
                } else {
                    analyzeThreshold = threshold;
                }
                ts = (TableStatistics)currentAnalyzeStatistics.get(tableName);
                if (ts == null) {
                    ts = new TableStatistics();
                    currentAnalyzeStatistics.put(tableName, ts);
                }
                ts.add(eventCount);
                if (ts.getEventCount() < 100) break block23;
                this.lockManager.enterWriteLock(tableStatisticsLock);
                try {
                    eventDatum = statsAnalyzePrefix + tableName;
                    oldEventCount = this.readDatum(eventDatum);
                    if ((oldEventCount += ts.getEventCount()) >= analyzeThreshold) {
                        this.analyzeTableInternal(tableName);
                        this.writeDatum(eventDatum, 0);
                    } else {
                        this.writeDatum(eventDatum, oldEventCount);
                    }
                    ts.reset();
                }
                finally {
                    this.lockManager.leaveWriteLock(tableStatisticsLock);
                }
            }
            finally {
                this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
            }
        }
    }

    protected static class TableStatistics {
        protected int eventCount = 0;

        public void reset() {
            this.eventCount = 0;
        }

        public void add(int eventCount) {
            this.eventCount += eventCount;
        }

        public int getEventCount() {
            return this.eventCount;
        }
    }
}

