/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.database.QueryDescription;
import org.apache.manifoldcf.core.database.RRow;
import org.apache.manifoldcf.core.database.RSet;
import org.apache.manifoldcf.core.database.TransactionHandle;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.core.interfaces.TimeMarker;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class Database {
    public static final String _rcsid = "@(#)$Id: Database.java 988245 2010-08-23 18:39:35Z kwright $";
    protected ICacheManager cacheManager;
    protected IThreadContext context;
    protected String jdbcUrl;
    protected String jdbcDriverClass;
    protected String databaseName;
    protected String userName;
    protected String password;
    protected TransactionHandle th = null;
    protected Connection connection = null;
    protected boolean doRollback = false;
    protected int delayedTransactionDepth = 0;
    protected static final String _TRANSACTION_ = "_TRANSACTION_";
    protected static Random random = new Random();

    public Database(IThreadContext context, String jdbcUrl, String jdbcDriverClass, String databaseName, String userName, String password) throws ManifoldCFException {
        this.context = context;
        this.jdbcUrl = jdbcUrl;
        this.jdbcDriverClass = jdbcDriverClass;
        this.databaseName = databaseName;
        this.userName = userName;
        this.password = password;
        this.cacheManager = CacheManagerFactory.make(context);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTransactionID() {
        if (this.th == null) {
            return null;
        }
        return this.th.getTransactionID();
    }

    protected void startATransaction() throws ManifoldCFException {
    }

    protected void commitCurrentTransaction() throws ManifoldCFException {
    }

    protected void rollbackCurrentTransaction() throws ManifoldCFException {
    }

    protected void explainQuery(String query, ArrayList params) throws ManifoldCFException {
    }

    protected String mapColumnName(String rawColumnName) {
        return rawColumnName;
    }

    public IResultSet executeQuery(String query, ArrayList params, StringSet cacheKeys, StringSet invalidateKeys, String queryClass, boolean needResult, int maxReturn, ResultSpecification spec, ILimitChecker returnLimits) throws ManifoldCFException {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Requested query: [" + query + "]"));
        }
        if (!needResult) {
            cacheKeys = null;
        }
        ICacheDescription[] queryDescriptions = new QueryDescription[]{new QueryDescription(this.databaseName, query, params, queryClass, cacheKeys, maxReturn, spec, returnLimits)};
        QueryCacheExecutor executor = new QueryCacheExecutor(this, needResult);
        this.cacheManager.findObjectsAndExecute(queryDescriptions, invalidateKeys, executor, this.getTransactionID());
        return executor.getResult();
    }

    public int getCurrentTransactionType() {
        if (this.th == null) {
            return 1;
        }
        return this.th.getTransactionType();
    }

    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Beginning transaction of type " + Integer.toString(transactionType)));
        }
        String enclosingID = this.th == null ? null : this.th.getTransactionID();
        ++this.delayedTransactionDepth;
        this.th = new TransactionHandle(this.context, this.th, transactionType);
        this.cacheManager.startTransaction(this.th.getTransactionID(), enclosingID);
        this.doRollback = false;
    }

    protected void synchronizeTransactions() throws ManifoldCFException {
        while (this.delayedTransactionDepth > 0) {
            this.internalTransactionBegin();
            --this.delayedTransactionDepth;
        }
    }

    protected void internalTransactionBegin() throws ManifoldCFException {
        if (this.connection == null) {
            this.connection = ConnectionFactory.getConnection(this.jdbcUrl, this.jdbcDriverClass, this.databaseName, this.userName, this.password);
            try {
                this.startATransaction();
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    this.connection = null;
                    throw e;
                }
                ConnectionFactory.releaseConnection(this.connection);
                this.connection = null;
                throw e;
            }
            catch (Error e) {
                ConnectionFactory.releaseConnection(this.connection);
                this.connection = null;
                throw e;
            }
        }
        try {
            this.startATransaction();
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                this.connection = null;
            }
            throw e;
        }
    }

    public void signalRollback() {
        Logging.db.debug((Object)"Rolling transaction back!");
        this.doRollback = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() throws ManifoldCFException {
        block16: {
            Logging.db.debug((Object)"Ending transaction");
            if (this.th == null) {
                throw new ManifoldCFException("End transaction without begin!", 0);
            }
            TransactionHandle parentTransaction = this.th.getParent();
            try {
                if (this.delayedTransactionDepth > 0) {
                    --this.delayedTransactionDepth;
                    break block16;
                }
                try {
                    if (this.doRollback) {
                        this.rollbackCurrentTransaction();
                    } else {
                        this.commitCurrentTransaction();
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) {
                        this.connection = null;
                    }
                    throw e;
                }
                finally {
                    if (parentTransaction == null && this.connection != null) {
                        ConnectionFactory.releaseConnection(this.connection);
                        this.connection = null;
                    }
                }
            }
            finally {
                if (this.doRollback) {
                    this.cacheManager.rollbackTransaction(this.th.getTransactionID());
                } else {
                    this.cacheManager.commitTransaction(this.th.getTransactionID());
                }
                this.th = parentTransaction;
            }
        }
    }

    public void noteModifications(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
    }

    public long getSleepAmt() {
        return (long)(random.nextDouble() * 60000.0 + 500.0);
    }

    public void sleepFor(long amt) throws ManifoldCFException {
        if (amt == 0L) {
            return;
        }
        try {
            ManifoldCF.sleep(amt);
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted", e, 2);
        }
    }

    protected IResultSet executeViaThread(Connection connection, String query, ArrayList params, boolean bResults, int maxResults, ResultSpecification spec, ILimitChecker returnLimit) throws ManifoldCFException {
        if (connection == null) {
            return null;
        }
        ExecuteQueryThread t = new ExecuteQueryThread(connection, query, params, bResults, maxResults, spec, returnLimit);
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof ManifoldCFException) {
                    ManifoldCFException me = (ManifoldCFException)thr;
                    throw new ManifoldCFException("Database exception: " + me.getMessage(), me.getCause(), me.getErrorCode());
                }
                throw (Error)thr;
            }
            return t.getResponse();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException(e.getMessage(), e, 2);
        }
    }

    protected IResultSet executeUncachedQuery(String query, ArrayList params, boolean bResults, int maxResults, ResultSpecification spec, ILimitChecker returnLimit) throws ManifoldCFException {
        if (this.connection != null) {
            try {
                return this.executeViaThread(this.connection, query, params, bResults, maxResults, spec, returnLimit);
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    this.connection = null;
                }
                throw e;
            }
        }
        Connection tempConnection = ConnectionFactory.getConnection(this.jdbcUrl, this.jdbcDriverClass, this.databaseName, this.userName, this.password);
        try {
            IResultSet iResultSet = this.executeViaThread(tempConnection, query, params, bResults, maxResults, spec, returnLimit);
            return iResultSet;
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                tempConnection = null;
            }
            throw e;
        }
        finally {
            if (tempConnection != null) {
                ConnectionFactory.releaseConnection(tempConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResultSet execute(Connection connection, String query, ArrayList params, boolean bResults, int maxResults, ResultSpecification spec, ILimitChecker returnLimit) throws ManifoldCFException {
        IResultSet rval = null;
        try {
            try {
                long queryStartTime;
                block26: {
                    queryStartTime = 0L;
                    if (Logging.db.isDebugEnabled()) {
                        queryStartTime = System.currentTimeMillis();
                        Logging.db.debug((Object)("Actual query: [" + query + "]"));
                        if (params != null) {
                            for (int i = 0; i < params.size(); ++i) {
                                Logging.db.debug((Object)("  Parameter " + i + ": '" + params.get(i).toString() + "'"));
                            }
                        }
                    }
                    if (params == null) {
                        Statement stmt = connection.createStatement();
                        try {
                            stmt.execute(query);
                            ResultSet rs = stmt.getResultSet();
                            try {
                                rval = this.getData(rs, bResults, maxResults, spec, returnLimit);
                                break block26;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    PreparedStatement ps = connection.prepareStatement(query);
                    try {
                        Database.loadPS(ps, params);
                        if (bResults) {
                            ResultSet rs = ps.executeQuery();
                            try {
                                rval = this.getData(rs, true, maxResults, spec, returnLimit);
                                break block26;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        ps.executeUpdate();
                        rval = this.getData(null, false, 0, spec, null);
                    }
                    finally {
                        ps.close();
                    }
                }
                if (Logging.db.isDebugEnabled()) {
                    Logging.db.debug((Object)("Done actual query (" + new Long(System.currentTimeMillis() - queryStartTime).toString() + "ms): [" + query + "]"));
                }
            }
            catch (SQLException e) {
                throw new ManifoldCFException("Exception doing query: " + e.getMessage(), e, 4);
            }
        }
        finally {
            if (params != null) {
                Database.cleanupParameters(params);
            }
        }
        return rval;
    }

    protected IResultSet getData(ResultSet rs, boolean bResults, int maxResults, ResultSpecification spec, ILimitChecker returnLimit) throws ManifoldCFException {
        RSet results = new RSet();
        try {
            try {
                if (rs != null) {
                    int colcount = 0;
                    String[] resultCols = null;
                    String[] resultLabels = null;
                    ResultSetMetaData rsmd = rs.getMetaData();
                    if (rsmd != null) {
                        colcount = rsmd.getColumnCount();
                        resultCols = new String[colcount];
                        resultLabels = new String[colcount];
                        for (int i = 0; i < colcount; ++i) {
                            resultCols[i] = rsmd.getColumnName(i + 1);
                            resultLabels[i] = this.mapColumnName(rsmd.getColumnLabel(i + 1));
                        }
                    }
                    if (bResults) {
                        if (colcount == 0) {
                            throw new ManifoldCFException("Empty query, no columns returned", 0);
                        }
                        while (rs.next() && (maxResults == -1 || maxResults > 0) && (returnLimit == null || returnLimit.checkContinue())) {
                            RRow m = new RRow();
                            for (int i = 0; i < colcount; ++i) {
                                String key = resultCols[i];
                                int colnum = this.findColumn(rs, key);
                                Object value = null;
                                if (colnum > -1) {
                                    value = this.getObject(rs, rsmd, colnum, spec == null ? 0 : spec.getForm(key));
                                }
                                m.put(resultLabels[i], value);
                            }
                            boolean include = true;
                            if (returnLimit != null) {
                                include = returnLimit.checkInclude(m);
                            }
                            if (include) {
                                if (maxResults != -1) {
                                    --maxResults;
                                }
                                results.addRow(m);
                                continue;
                            }
                            Iterator iter = m.getColumns();
                            while (iter.hasNext()) {
                                String columnName = (String)iter.next();
                                Object colValue = m.getValue(columnName);
                                if (colValue instanceof BinaryInput) {
                                    ((BinaryInput)colValue).discard();
                                    continue;
                                }
                                if (!(colValue instanceof CharacterInput)) continue;
                                ((CharacterInput)colValue).discard();
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new ManifoldCFException("Resultset error: " + e.getMessage(), e, 4);
            }
        }
        catch (Throwable e) {
            int i = 0;
            while (i < results.getRowCount()) {
                IResultRow row = results.getRow(i++);
                boolean j = false;
                Iterator iter = row.getColumns();
                while (iter.hasNext()) {
                    String colName = (String)iter.next();
                    Object o = row.getValue(colName);
                    if (o instanceof BinaryInput) {
                        ((BinaryInput)o).discard();
                        continue;
                    }
                    if (!(o instanceof CharacterInput)) continue;
                    ((CharacterInput)o).discard();
                }
            }
            if (e instanceof ManifoldCFException) {
                throw (ManifoldCFException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new Error("Unexpected exception caught: " + e.getMessage(), e);
        }
        return results;
    }

    protected static void loadPS(PreparedStatement ps, ArrayList data) throws SQLException, ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                long length;
                Object value;
                Object x = data.get(i);
                if (x instanceof String) {
                    value = (String)x;
                    ps.setString(i + 1, (String)value);
                }
                if (x instanceof BinaryInput) {
                    value = (BinaryInput)x;
                    length = ((BinaryInput)value).getLength();
                    ps.setBinaryStream(i + 1, ((BinaryInput)value).getStream(), length == -1L ? Integer.MAX_VALUE : (int)length);
                }
                if (x instanceof CharacterInput) {
                    value = (CharacterInput)x;
                    length = ((CharacterInput)value).getCharacterLength();
                    ps.setCharacterStream(i + 1, ((CharacterInput)value).getStream(), length == -1L ? Integer.MAX_VALUE : (int)length);
                }
                if (x instanceof java.util.Date) {
                    ps.setDate(i + 1, new Date(((java.util.Date)x).getTime()));
                }
                if (x instanceof Long) {
                    ps.setLong(i + 1, (Long)x);
                }
                if (x instanceof TimeMarker) {
                    ps.setTimestamp(i + 1, new Timestamp(((TimeMarker)x).longValue()));
                }
                if (x instanceof Double) {
                    ps.setDouble(i + 1, (Double)x);
                }
                if (x instanceof Integer) {
                    ps.setInt(i + 1, (Integer)x);
                }
                if (!(x instanceof Float)) continue;
                ps.setFloat(i + 1, ((Float)x).floatValue());
            }
        }
    }

    protected static void cleanupParameters(ArrayList data) throws ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                Object x = data.get(i);
                if (x instanceof BinaryInput) {
                    ((BinaryInput)x).doneWithStream();
                    continue;
                }
                if (!(x instanceof CharacterInput)) continue;
                ((CharacterInput)x).doneWithStream();
            }
        }
    }

    protected int findColumn(ResultSet rs, String name) throws ManifoldCFException {
        try {
            return rs.findColumn(name);
        }
        catch (SQLException e) {
            return -1;
        }
        catch (Exception e) {
            throw new ManifoldCFException("Error finding " + name + " in resultset: " + e.getMessage(), e, 1);
        }
    }

    protected Blob getBLOB(ResultSet rs, int col) throws ManifoldCFException {
        try {
            return rs.getBlob(col);
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in getBlob", sqle, 4);
        }
        catch (Exception sqle) {
            throw new ManifoldCFException("Error in getBlob", sqle, 1);
        }
    }

    protected boolean isBLOB(ResultSetMetaData rsmd, int col) throws ManifoldCFException {
        try {
            int type = rsmd.getColumnType(col);
            return type == 2004;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBlob(" + col + "): " + sqle.getMessage(), sqle, 4);
        }
        catch (Exception sqle) {
            throw new ManifoldCFException("Error in isBlob(" + col + "): " + sqle.getMessage(), sqle, 1);
        }
    }

    protected boolean isBinary(ResultSetMetaData rsmd, int col) throws ManifoldCFException {
        try {
            int type = rsmd.getColumnType(col);
            return type == -3 || type == -2 || type == -4;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBinary(" + col + "): " + sqle.getMessage(), sqle, 4);
        }
        catch (Exception sqle) {
            throw new ManifoldCFException("Error in isBinary(" + col + "): " + sqle.getMessage(), sqle, 1);
        }
    }

    protected Object getObject(ResultSet rs, ResultSetMetaData rsmd, int col, int desiredForm) throws ManifoldCFException {
        Object result = null;
        try {
            try {
                if (this.isBLOB(rsmd, col)) {
                    Blob blob = this.getBLOB(rs, col);
                    if (blob != null) {
                        result = new TempFileInput(blob.getBinaryStream(), blob.length());
                    }
                } else if (this.isBinary(rsmd, col)) {
                    InputStream is = rs.getBinaryStream(col);
                    if (is != null) {
                        result = new TempFileInput(is);
                    }
                } else {
                    block2 : switch (rsmd.getColumnType(col)) {
                        case 1: 
                        case 12: {
                            String resultString = rs.getString(col);
                            if (resultString == null) break;
                            if (rsmd.getColumnDisplaySize(col) < resultString.length()) {
                                result = resultString.substring(0, rsmd.getColumnDisplaySize(col));
                                break;
                            }
                            result = resultString;
                            break;
                        }
                        case 2005: {
                            Clob clob = rs.getClob(col);
                            if (clob == null) break;
                            result = clob.getSubString(1L, (int)clob.length());
                            break;
                        }
                        case -5: {
                            long l = rs.getLong(col);
                            if (rs.wasNull()) break;
                            result = new Long(l);
                            break;
                        }
                        case 4: {
                            int i = rs.getInt(col);
                            if (rs.wasNull()) break;
                            result = new Integer(i);
                            break;
                        }
                        case 5: {
                            short s = rs.getShort(col);
                            if (rs.wasNull()) break;
                            result = new Short(s);
                            break;
                        }
                        case 6: 
                        case 7: {
                            float f = rs.getFloat(col);
                            if (rs.wasNull()) break;
                            result = new Float(f);
                            break;
                        }
                        case 8: {
                            double d = rs.getDouble(col);
                            if (rs.wasNull()) break;
                            result = new Double(d);
                            break;
                        }
                        case 91: {
                            Date date = rs.getDate(col);
                            if (date == null) break;
                            result = new java.util.Date(date.getTime());
                            break;
                        }
                        case 93: {
                            Timestamp timestamp = rs.getTimestamp(col);
                            if (timestamp == null) break;
                            result = new TimeMarker(timestamp.getTime());
                            break;
                        }
                        case 16: {
                            boolean b = rs.getBoolean(col);
                            if (rs.wasNull()) break;
                            result = new Boolean(b);
                            break;
                        }
                        case 2004: {
                            throw new ManifoldCFException("BLOB is not a string, column = " + col, 0);
                        }
                        default: {
                            switch (desiredForm) {
                                case 0: 
                                case 1: {
                                    result = rs.getString(col);
                                    break block2;
                                }
                                case 2: {
                                    result = new TempFileCharacterInput(rs.getCharacterStream(col));
                                    break block2;
                                }
                            }
                            throw new ManifoldCFException("Illegal form requested for column " + Integer.toString(col) + ": " + Integer.toString(desiredForm));
                        }
                    }
                    if (rs.wasNull()) {
                        if (result instanceof CharacterInput) {
                            ((CharacterInput)result).discard();
                        }
                        result = null;
                    }
                }
            }
            catch (SQLException e) {
                throw new ManifoldCFException("Exception in getObject(): " + e.getMessage(), e, 4);
            }
        }
        catch (Throwable e) {
            if (result instanceof CharacterInput) {
                ((CharacterInput)result).discard();
            } else if (result instanceof BinaryInput) {
                ((BinaryInput)result).discard();
            }
            if (e instanceof ManifoldCFException) {
                throw (ManifoldCFException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new Error("Unexpected exception caught: " + e.getMessage(), e);
        }
        return result;
    }

    public static class QueryCacheExecutor
    extends ExecutorBase {
        protected Database database;
        protected boolean needResult;
        protected IResultSet resultset = null;

        public QueryCacheExecutor(Database database, boolean needResult) {
            this.database = database;
            this.needResult = needResult;
        }

        public IResultSet getResult() {
            return this.resultset;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            Object[] rval = new Object[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.database.synchronizeTransactions();
                QueryDescription description = (QueryDescription)objectDescriptions[i];
                ILimitChecker limit = description.getReturnLimit();
                ResultSpecification spec = description.getResultSpecification();
                long startTime = System.currentTimeMillis();
                rval[i] = this.database.executeUncachedQuery(description.getQuery(), description.getParameters(), this.needResult, description.getMaxReturn(), spec, limit);
                long endTime = System.currentTimeMillis();
                if (endTime - startTime <= 60000L || description.getQuery().length() < 6 || !"SELECT".equalsIgnoreCase(description.getQuery().substring(0, 6)) && !"UPDATE".equalsIgnoreCase(description.getQuery().substring(0, 6))) continue;
                Logging.db.warn((Object)("Found a query that took more than a minute (" + new Long(endTime - startTime).toString() + " ms): [" + description.getQuery() + "]"));
                if (description.getParameters() != null) {
                    for (int j = 0; j < description.getParameters().size(); ++j) {
                        Logging.db.warn((Object)("  Parameter " + j + ": '" + description.getParameters().get(j).toString() + "'"));
                    }
                }
                try {
                    this.database.explainQuery(description.getQuery(), description.getParameters());
                    continue;
                }
                catch (ManifoldCFException e) {
                    Logging.db.error((Object)("Explain failed with error " + e.getMessage()), (Throwable)e);
                }
            }
            return rval;
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            this.resultset = (IResultSet)cachedObject;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected class ExecuteQueryThread
    extends Thread {
        protected Connection connection;
        protected String query;
        protected ArrayList params;
        protected boolean bResults;
        protected int maxResults;
        protected ResultSpecification spec;
        protected ILimitChecker returnLimit;
        protected Throwable exception = null;
        protected IResultSet rval = null;

        public ExecuteQueryThread(Connection connection, String query, ArrayList params, boolean bResults, int maxResults, ResultSpecification spec, ILimitChecker returnLimit) {
            this.setDaemon(true);
            this.connection = connection;
            this.query = query;
            this.params = params;
            this.bResults = bResults;
            this.maxResults = maxResults;
            this.spec = spec;
            this.returnLimit = returnLimit;
        }

        public void run() {
            try {
                this.rval = Database.this.execute(this.connection, this.query, this.params, this.bResults, this.maxResults, this.spec, this.returnLimit);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public IResultSet getResponse() {
            return this.rval;
        }
    }
}

