/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class ConfigParams
extends Configuration {
    public static final String _rcsid = "@(#)$Id: ConfigParams.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String PARAMETER_TYPE = "_PARAMETER_";
    protected static final String ATTR_NAME = "name";
    protected HashMap params = new HashMap();

    public ConfigParams() {
        super("configuration");
    }

    public ConfigParams(Map map) {
        super("configuration");
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            ConfigNode cn = new ConfigNode(PARAMETER_TYPE);
            cn.setAttribute(ATTR_NAME, key);
            cn.setValue(value);
            this.addChild(this.getChildCount(), cn);
        }
    }

    public ConfigParams(String xml) throws ManifoldCFException {
        super("configuration");
        this.fromXML(xml);
    }

    public ConfigParams(InputStream xmlstream) throws ManifoldCFException {
        super("configuration");
        this.fromXML(xmlstream);
    }

    protected Configuration createNew() {
        return new ConfigParams();
    }

    protected ConfigurationNode createNewNode(String type) {
        return new ConfigNode(type);
    }

    protected void clearOuterNodes() {
        this.params.clear();
    }

    protected void addOuterNode(ConfigurationNode node) {
        if (node.getType().equals(PARAMETER_TYPE)) {
            String name = node.getAttributeValue(ATTR_NAME);
            String value = node.getValue();
            if (name != null && value != null) {
                this.params.put(name, value);
            }
        }
    }

    protected void removeOuterNode(ConfigurationNode node) {
        String name;
        if (node.getType().equals(PARAMETER_TYPE) && (name = node.getAttributeValue(ATTR_NAME)) != null) {
            this.params.remove(name);
        }
    }

    public String getParameter(String key) {
        return (String)this.params.get(key);
    }

    public String getObfuscatedParameter(String key) {
        String rval = this.getParameter(key);
        if (rval == null) {
            return rval;
        }
        try {
            return ManifoldCF.deobfuscate(rval);
        }
        catch (ManifoldCFException e) {
            return "";
        }
    }

    public void setParameter(String key, String value) {
        if (this.params.get(key) != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                String name;
                ConfigNode node = (ConfigNode)this.children.get(i);
                if (!node.getType().equals(PARAMETER_TYPE) || !(name = node.getAttributeValue(ATTR_NAME)).equals(key)) continue;
                this.removeChild(i);
                break;
            }
        }
        ConfigNode cn = new ConfigNode(PARAMETER_TYPE);
        cn.setAttribute(ATTR_NAME, key);
        cn.setValue(value);
        this.addChild(this.getChildCount(), cn);
    }

    public void setObfuscatedParameter(String key, String value) {
        if (value != null) {
            try {
                value = ManifoldCF.obfuscate(value);
            }
            catch (ManifoldCFException e) {
                value = "";
            }
        }
        this.setParameter(key, value);
    }

    public Iterator listParameters() {
        return this.params.keySet().iterator();
    }

    public ConfigParams duplicate() {
        return (ConfigParams)this.createDuplicate(false);
    }

    public ConfigNode getChild(int index) {
        return (ConfigNode)this.findChild(index);
    }
}

