/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.IHierarchyParent;

public class ConfigurationNode
implements IHierarchyParent {
    public static final String _rcsid = "@(#)$Id: ConfigurationNode.java 988245 2010-08-23 18:39:35Z kwright $";
    protected ArrayList children = null;
    protected HashMap attributes = null;
    protected String type = null;
    protected String value = null;
    protected boolean readOnly = false;

    public ConfigurationNode(String type) {
        this.type = type;
    }

    public ConfigurationNode(ConfigurationNode source) {
        this.type = source.type;
        this.value = source.value;
        this.readOnly = source.readOnly;
        if (source.attributes != null) {
            for (String attribute : source.attributes.keySet()) {
                String attrValue = (String)source.attributes.get(attribute);
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(attribute, attrValue);
            }
        }
        int i = 0;
        while (i < source.getChildCount()) {
            ConfigurationNode child = source.findChild(i++);
            this.addChild(this.getChildCount(), this.createNewNode(child));
        }
    }

    protected ConfigurationNode createNewNode() {
        return new ConfigurationNode(this.type);
    }

    protected ConfigurationNode createNewNode(ConfigurationNode source) {
        return new ConfigurationNode(source);
    }

    public void makeReadOnly() {
        if (this.readOnly) {
            return;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode child = (ConfigurationNode)this.children.get(i++);
                child.makeReadOnly();
            }
        }
        this.readOnly = true;
    }

    protected ConfigurationNode createDuplicate(boolean readOnly) {
        if (readOnly && this.readOnly) {
            return this;
        }
        ConfigurationNode rval = this.createNewNode();
        rval.value = this.value;
        if (this.attributes != null) {
            rval.attributes = (HashMap)this.attributes.clone();
        }
        if (this.children != null) {
            rval.children = new ArrayList();
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode node = (ConfigurationNode)this.children.get(i++);
                rval.children.add(node.createDuplicate(readOnly));
            }
        }
        rval.readOnly = readOnly;
        return rval;
    }

    public String getType() {
        return this.type;
    }

    public void setValue(String value) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public ConfigurationNode findChild(int index) {
        return (ConfigurationNode)this.children.get(index);
    }

    public void removeChild(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        if (this.children != null) {
            this.children.remove(index);
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }

    public void addChild(int index, ConfigurationNode child) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(index, child);
    }

    public void setAttribute(String attribute, String value) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        if (value == null) {
            if (this.attributes != null) {
                this.attributes.remove(attribute);
                if (this.attributes.size() == 0) {
                    this.attributes = null;
                }
            }
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(attribute, value);
        }
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public Iterator getAttributes() {
        if (this.attributes == null) {
            return new HashMap().keySet().iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public String getAttributeValue(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attribute);
    }

    public int hashCode() {
        int rval = this.type.hashCode();
        if (this.value != null) {
            rval += this.value.hashCode();
        }
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                String attrValue = (String)this.attributes.get(key);
                rval += key.hashCode() + attrValue.hashCode();
            }
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                rval += this.children.get(i++).hashCode();
            }
        }
        return rval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigurationNode)) {
            return false;
        }
        ConfigurationNode n = (ConfigurationNode)o;
        if ((this.attributes == null ? 0 : this.attributes.size()) != (n.attributes == null ? 0 : n.attributes.size())) {
            return false;
        }
        if ((this.children == null ? 0 : this.children.size()) != (n.children == null ? 0 : n.children.size())) {
            return false;
        }
        if (!this.type.equals(n.type)) {
            return false;
        }
        if (this.value == null || n.value == null ? this.value != n.value : !this.value.equals(n.value)) {
            return false;
        }
        if (this.attributes != null && n.attributes != null) {
            for (String key : this.attributes.keySet()) {
                String attrValue = (String)this.attributes.get(key);
                String nAttrValue = (String)n.attributes.get(key);
                if (nAttrValue != null && attrValue.equals(nAttrValue)) continue;
                return false;
            }
        }
        if (this.children != null && n.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                ConfigurationNode nChild;
                ConfigurationNode child = (ConfigurationNode)this.children.get(i);
                if (child.equals(nChild = (ConfigurationNode)n.children.get(i))) continue;
                return false;
            }
        }
        return true;
    }
}

