/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.keystore.KeystoreManager;

public class KeystoreManagerFactory {
    public static final String _rcsid = "@(#)$Id: KeystoreManagerFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static X509TrustManager[] openTrustManagerArray = new OpenTrustManager[]{new OpenTrustManager()};

    public static IKeystoreManager make(String passcode) throws ManifoldCFException {
        return new KeystoreManager(passcode);
    }

    public static IKeystoreManager make(String passcode, String base64String) throws ManifoldCFException {
        return new KeystoreManager(passcode, base64String);
    }

    public static SSLSocketFactory getTrustingSecureSocketFactory() throws ManifoldCFException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, openTrustManagerArray, secureRandom);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("No such algorithm: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new ManifoldCFException("Key management exception: " + e.getMessage(), e);
        }
    }

    protected static class OpenTrustManager
    implements X509TrustManager {
        protected OpenTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

