/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class ResultSpecification {
    public static final int FORM_DEFAULT = 0;
    public static final int FORM_STRING = 1;
    public static final int FORM_STREAM = 2;
    protected HashMap columnSpecifications = new HashMap();

    public int hashCode() {
        Object[] keys = new String[this.columnSpecifications.size()];
        Iterator iter = this.columnSpecifications.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keys[i++] = (String)iter.next();
        }
        Arrays.sort(keys);
        int rval = 0;
        i = 0;
        while (i < keys.length) {
            Object key = keys[i++];
            rval += ((String)key).hashCode();
            ColumnSpecification cs = (ColumnSpecification)this.columnSpecifications.get(key);
            rval += cs.hashCode();
        }
        return rval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResultSpecification)) {
            return false;
        }
        ResultSpecification other = (ResultSpecification)o;
        if (other.columnSpecifications.size() != this.columnSpecifications.size()) {
            return false;
        }
        for (String key : this.columnSpecifications.keySet()) {
            ColumnSpecification thisSpec = (ColumnSpecification)this.columnSpecifications.get(key);
            ColumnSpecification otherSpec = (ColumnSpecification)other.columnSpecifications.get(key);
            if (otherSpec == null) {
                return false;
            }
            if (thisSpec.equals(otherSpec)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] keys = new String[this.columnSpecifications.size()];
        Iterator iter = this.columnSpecifications.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keys[i++] = (String)iter.next();
        }
        Arrays.sort(keys);
        sb.append(Integer.toString(keys.length));
        i = 0;
        while (i < keys.length) {
            Object key = keys[i++];
            sb.append("-").append((String)key);
            ColumnSpecification cs = (ColumnSpecification)this.columnSpecifications.get(key);
            sb.append("-").append(cs.toString());
        }
        return sb.toString();
    }

    public void setForm(String columnName, int formValue) {
        ColumnSpecification cs = (ColumnSpecification)this.columnSpecifications.get(columnName);
        if (cs == null) {
            if (formValue == 0) {
                return;
            }
            cs = new ColumnSpecification();
            this.columnSpecifications.put(columnName, cs);
        } else if (formValue == 0) {
            this.columnSpecifications.remove(columnName);
            return;
        }
        cs.setForm(formValue);
    }

    public int getForm(String columnName) {
        ColumnSpecification cs = (ColumnSpecification)this.columnSpecifications.get(columnName);
        if (cs == null) {
            return 0;
        }
        return cs.getForm();
    }

    protected static class ColumnSpecification {
        protected int formValue = 0;

        public void setForm(int formValue) {
            this.formValue = formValue;
        }

        public int getForm() {
            return this.formValue;
        }

        public String toString() {
            return Integer.toString(this.formValue);
        }

        public int hashCode() {
            return this.formValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ColumnSpecification)) {
                return false;
            }
            ColumnSpecification other = (ColumnSpecification)o;
            return other.formValue == this.formValue;
        }
    }
}

