/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class TempFileCharacterInput
extends CharacterInput {
    public static final String _rcsid = "@(#)$Id: TempFileCharacterInput.java 988245 2010-08-23 18:39:35Z kwright $";
    protected File file;
    protected static final int CHUNK_SIZE = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileCharacterInput(Reader is) throws ManifoldCFException {
        try {
            File outfile = File.createTempFile("_MC_", "");
            try {
                ManifoldCF.addFile(outfile);
                MessageDigest md = ManifoldCF.startHash();
                FileOutputStream outStream = new FileOutputStream(outfile);
                OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)outStream, "utf-8");
                try {
                    int moveAmount;
                    int readsize;
                    char[] buffer = new char[65536];
                    long totalMoved = 0L;
                    while ((readsize = is.read(buffer, 0, moveAmount = 65536)) != -1) {
                        outWriter.write(buffer, 0, readsize);
                        ManifoldCF.addToHash(md, new String(buffer, 0, readsize));
                        totalMoved += (long)readsize;
                    }
                    this.charLength = totalMoved;
                    this.hashValue = ManifoldCF.getHashValue(md);
                }
                finally {
                    outWriter.close();
                }
                this.file = outfile;
            }
            catch (Throwable e) {
                ManifoldCF.deleteFile(outfile);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception("Unexpected throwable: " + e.getMessage(), e);
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (Exception e) {
            throw new ManifoldCFException("Cannot write temporary file: " + e.getMessage(), e, 0);
        }
    }

    public TempFileCharacterInput(File tempFile) {
        this.file = tempFile;
        ManifoldCF.addFile(this.file);
    }

    protected TempFileCharacterInput() {
    }

    public InputStream getUtf8Stream() throws ManifoldCFException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ManifoldCFException("No such file: " + e.getMessage(), e, 0);
            }
        }
        return null;
    }

    protected void openStream() throws ManifoldCFException {
        try {
            FileInputStream binaryStream = new FileInputStream(this.file);
            this.stream = new InputStreamReader((InputStream)binaryStream, "utf-8");
        }
        catch (FileNotFoundException e) {
            throw new ManifoldCFException("Can't create stream: " + e.getMessage(), e, 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new ManifoldCFException("Can't create stream: " + e.getMessage(), e, 0);
        }
    }

    public CharacterInput transfer() {
        TempFileCharacterInput rval = new TempFileCharacterInput();
        rval.file = this.file;
        rval.stream = this.stream;
        rval.charLength = this.charLength;
        rval.hashValue = this.hashValue;
        this.file = null;
        this.stream = null;
        this.charLength = -1L;
        this.hashValue = null;
        return rval;
    }

    public void discard() throws ManifoldCFException {
        super.discard();
        if (this.file != null) {
            ManifoldCF.deleteFile(this.file);
            this.file = null;
        }
    }

    protected void calculateLength() throws ManifoldCFException {
        this.scanFile();
    }

    protected void calculateHashValue() throws ManifoldCFException {
        this.scanFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile() throws ManifoldCFException {
        try {
            FileInputStream binaryStream = new FileInputStream(this.file);
            InputStreamReader reader = new InputStreamReader((InputStream)binaryStream, "utf-8");
            try {
                int moveAmount;
                int readsize;
                MessageDigest md = ManifoldCF.startHash();
                char[] buffer = new char[65536];
                long totalMoved = 0L;
                while ((readsize = ((Reader)reader).read(buffer, 0, moveAmount = 65536)) != -1) {
                    ManifoldCF.addToHash(md, new String(buffer, 0, readsize));
                    totalMoved += (long)readsize;
                }
                this.charLength = totalMoved;
                this.hashValue = ManifoldCF.getHashValue(md);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("Can't scan file: " + e.getMessage(), e, 0);
        }
    }
}

