/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class TempFileInput
extends BinaryInput {
    public static final String _rcsid = "@(#)$Id: TempFileInput.java 988245 2010-08-23 18:39:35Z kwright $";
    protected File file;
    protected static final int CHUNK_SIZE = 65536;

    public TempFileInput(InputStream is) throws ManifoldCFException {
        this(is, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileInput(InputStream is, long length) throws ManifoldCFException {
        try {
            File outfile = File.createTempFile("_MC_", "");
            try {
                ManifoldCF.addFile(outfile);
                FileOutputStream outStream = new FileOutputStream(outfile);
                try {
                    int moveAmount;
                    byte[] buffer = new byte[65536];
                    long totalMoved = 0L;
                    while ((moveAmount = length == -1L || length - totalMoved > 65536L ? 65536 : (int)(length - totalMoved)) != 0) {
                        int readsize = is.read(buffer, 0, moveAmount);
                        if (readsize == -1) {
                            break;
                        }
                        outStream.write(buffer, 0, readsize);
                        totalMoved += (long)readsize;
                    }
                }
                finally {
                    outStream.close();
                }
                this.file = outfile;
                this.length = this.file.length();
            }
            catch (Throwable e) {
                ManifoldCF.deleteFile(outfile);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception("Unexpected throwable: " + e.getMessage(), e);
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (Exception e) {
            throw new ManifoldCFException("Cannot write temporary file", e, 0);
        }
    }

    public TempFileInput(File tempFile) {
        this.file = tempFile;
        ManifoldCF.addFile(this.file);
    }

    protected TempFileInput() {
    }

    public BinaryInput transfer() {
        TempFileInput rval = new TempFileInput();
        rval.file = this.file;
        rval.stream = this.stream;
        rval.length = this.length;
        this.file = null;
        this.stream = null;
        this.length = -1L;
        return rval;
    }

    public void discard() throws ManifoldCFException {
        super.discard();
        if (this.file != null) {
            ManifoldCF.deleteFile(this.file);
            this.file = null;
        }
    }

    protected void openStream() throws ManifoldCFException {
        try {
            this.stream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ManifoldCFException("Can't create stream: " + e.getMessage(), e, 0);
        }
    }

    protected void calculateLength() throws ManifoldCFException {
        this.length = this.file.length();
    }
}

