/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.LockException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.ExpiredObjectException;
import org.apache.manifoldcf.core.lockmanager.LocalLockException;
import org.apache.manifoldcf.core.lockmanager.LockObject;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class LockManager
implements ILockManager {
    public static final String _rcsid = "@(#)$Id: LockManager.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String synchDirectoryProperty = "org.apache.manifoldcf.synchdirectory";
    protected static final int TYPE_READ = 1;
    protected static final int TYPE_WRITENONEX = 2;
    protected static final int TYPE_WRITE = 3;
    protected HashMap localLocks = new HashMap();
    protected static LockPool myLocks = new LockPool();
    protected HashMap localSections = new HashMap();
    protected static LockPool mySections = new LockPool();
    protected File synchDirectory = ManifoldCF.getFileProperty("org.apache.manifoldcf.synchdirectory");
    protected static HashMap globalFlags = new HashMap();
    protected static HashMap globalData = new HashMap();
    protected static final int BASE_SIZE = 128;

    public LockManager() throws ManifoldCFException {
        if (this.synchDirectory != null && !this.synchDirectory.isDirectory()) {
            throw new ManifoldCFException("Property org.apache.manifoldcf.synchdirectory must point to an existing, writeable directory!", 3);
        }
    }

    protected static String getFlagResourceName(String flagName) {
        return "flag-" + flagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalFlag(String flagName) throws ManifoldCFException {
        if (this.synchDirectory == null) {
            HashMap hashMap = globalFlags;
            synchronized (hashMap) {
                globalFlags.put(flagName, new Boolean(true));
            }
        }
        String resourceName = LockManager.getFlagResourceName(flagName);
        String path = this.makeFilePath(resourceName);
        new File(path).mkdirs();
        File f = new File(path, ManifoldCF.safeFileName(resourceName));
        try {
            f.createNewFile();
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGlobalFlag(String flagName) throws ManifoldCFException {
        if (this.synchDirectory == null) {
            HashMap hashMap = globalFlags;
            synchronized (hashMap) {
                globalFlags.remove(flagName);
            }
        } else {
            String resourceName = LockManager.getFlagResourceName(flagName);
            File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkGlobalFlag(String flagName) throws ManifoldCFException {
        if (this.synchDirectory == null) {
            HashMap hashMap = globalFlags;
            synchronized (hashMap) {
                return globalFlags.get(flagName) != null;
            }
        }
        String resourceName = LockManager.getFlagResourceName(flagName);
        File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readData(String resourceName) throws ManifoldCFException {
        byte[] byArray;
        if (this.synchDirectory == null) {
            HashMap hashMap = globalData;
            synchronized (hashMap) {
                return (byte[])globalData.get(resourceName);
            }
        }
        File f = new File(this.makeFilePath(resourceName), ManifoldCF.safeFileName(resourceName));
        FileInputStream is = new FileInputStream(f);
        try {
            int x;
            ByteArrayBuffer bab = new ByteArrayBuffer();
            while ((x = ((InputStream)is).read()) != -1) {
                bab.add((byte)x);
            }
            byArray = bab.toArray();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
            }
        }
        ((InputStream)is).close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(String resourceName, byte[] data) throws ManifoldCFException {
        if (this.synchDirectory == null) {
            HashMap hashMap = globalData;
            synchronized (hashMap) {
                if (data == null) {
                    globalData.remove(resourceName);
                } else {
                    globalData.put(resourceName, data);
                }
            }
        }
        try {
            String path = this.makeFilePath(resourceName);
            new File(path).mkdirs();
            File f = new File(path, ManifoldCF.safeFileName(resourceName));
            if (data == null) {
                f.delete();
                return;
            }
            FileOutputStream os = new FileOutputStream(f);
            try {
                os.write(data, 0, data.length);
            }
            finally {
                os.close();
            }
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
        }
    }

    public void timedWait(int time) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Waiting for time " + Integer.toString(time)));
        }
        try {
            ManifoldCF.sleep(time);
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted", e, 2);
        }
    }

    public void enterNonExWriteLock(String lockKey) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering non-ex write lock '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementNonExWriteLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        if (ll.hasReadLock()) {
            throw new ManifoldCFException("Illegal lock sequence: NonExWrite lock can't be within read lock", 0);
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                lo.enterNonExWriteLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementNonExWriteLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterNonExWriteLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering non-ex write lock no wait '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementNonExWriteLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        if (ll.hasReadLock()) {
            throw new ManifoldCFException("Illegal lock sequence: NonExWrite lock can't be within read lock", 0);
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                LockObject lockObject = lo;
                synchronized (lockObject) {
                    lo.enterNonExWriteLockNoWait();
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not non-ex write lock '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementNonExWriteLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    public void leaveNonExWriteLock(String lockKey) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving non-ex write lock '" + lockKey + "'"));
        }
        LocalLock ll = this.getLocalLock(lockKey);
        ll.decrementNonExWriteLocks();
        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
            while (true) {
                LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
                try {
                    lo.leaveNonExWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveNonExWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalLock(lockKey);
        }
    }

    public void enterWriteLock(String lockKey) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering write lock '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasWriteLock()) {
            ll.incrementWriteLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        if (ll.hasReadLock() || ll.hasNonExWriteLock()) {
            throw new ManifoldCFException("Illegal lock sequence: Write lock can't be within read lock or non-ex write lock", 0);
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                lo.enterWriteLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementWriteLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterWriteLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering write lock no wait '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasWriteLock()) {
            ll.incrementWriteLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        if (ll.hasReadLock() || ll.hasNonExWriteLock()) {
            throw new ManifoldCFException("Illegal lock sequence: Write lock can't be within read lock or non-ex write lock", 0);
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                LockObject lockObject = lo;
                synchronized (lockObject) {
                    lo.enterWriteLockNoWait();
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not write lock '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementWriteLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    public void leaveWriteLock(String lockKey) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving write lock '" + lockKey + "'"));
        }
        LocalLock ll = this.getLocalLock(lockKey);
        ll.decrementWriteLocks();
        if (!ll.hasWriteLock()) {
            while (true) {
                LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
                try {
                    lo.leaveWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalLock(lockKey);
        }
    }

    public void enterReadLock(String lockKey) throws ManifoldCFException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering read lock '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementReadLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                lo.enterReadLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementReadLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterReadLockNoWait(String lockKey) throws ManifoldCFException, LockException {
        LocalLock ll;
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Entering read lock no wait '" + lockKey + "'"));
        }
        if ((ll = this.getLocalLock(lockKey)).hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementReadLocks();
            Logging.lock.debug((Object)" Successfully obtained lock!");
            return;
        }
        while (true) {
            LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
            try {
                LockObject lockObject = lo;
                synchronized (lockObject) {
                    lo.enterReadLockNoWait();
                }
            }
            catch (LocalLockException e) {
                if (Logging.lock.isDebugEnabled()) {
                    Logging.lock.debug((Object)(" Could not read lock '" + lockKey + "', lock exception"));
                }
                throw new LockException(e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementReadLocks();
        Logging.lock.debug((Object)" Successfully obtained lock!");
    }

    public void leaveReadLock(String lockKey) throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)("Leaving read lock '" + lockKey + "'"));
        }
        LocalLock ll = this.getLocalLock(lockKey);
        ll.decrementReadLocks();
        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
            while (true) {
                LockObject lo = myLocks.getObject(lockKey, this.synchDirectory);
                try {
                    lo.leaveReadLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveReadLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalLock(lockKey);
        }
    }

    public void clearLocks() throws ManifoldCFException {
        if (Logging.lock.isDebugEnabled()) {
            Logging.lock.debug((Object)"Clearing all locks");
        }
        for (String keyValue : this.localLocks.keySet()) {
            LocalLock ll = (LocalLock)this.localLocks.get(keyValue);
            while (ll.hasWriteLock()) {
                this.leaveWriteLock(keyValue);
            }
            while (ll.hasNonExWriteLock()) {
                this.leaveNonExWriteLock(keyValue);
            }
            while (ll.hasReadLock()) {
                this.leaveReadLock(keyValue);
            }
        }
    }

    public void enterLocks(String[] readLocks, String[] nonExWriteLocks, String[] writeLocks) throws ManifoldCFException {
        int locksProcessed;
        if (Logging.lock.isDebugEnabled()) {
            int i;
            Logging.lock.debug((Object)"Entering multiple locks:");
            if (readLocks != null) {
                i = 0;
                while (i < readLocks.length) {
                    Logging.lock.debug((Object)(" Read lock '" + readLocks[i++] + "'"));
                }
            }
            if (nonExWriteLocks != null) {
                i = 0;
                while (i < nonExWriteLocks.length) {
                    Logging.lock.debug((Object)(" Non-ex write lock '" + nonExWriteLocks[i++] + "'"));
                }
            }
            if (writeLocks != null) {
                i = 0;
                while (i < writeLocks.length) {
                    Logging.lock.debug((Object)(" Write lock '" + writeLocks[i++] + "'"));
                }
            }
        }
        LockDescription[] lds = this.getSortedUniqueLocks(readLocks, nonExWriteLocks, writeLocks);
        try {
            block23: for (locksProcessed = 0; locksProcessed < lds.length; ++locksProcessed) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                switch (lockType) {
                    case 3: {
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if ((ll.hasReadLock() || ll.hasNonExWriteLock()) && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: Write lock can't be within read lock or non-ex write lock", 0);
                        }
                        if (!ll.hasWriteLock()) {
                            while (true) {
                                lo = myLocks.getObject(lockKey, this.synchDirectory);
                                try {
                                    lo.enterWriteLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementWriteLocks();
                        continue block23;
                    }
                    case 2: {
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if (ll.hasReadLock() && !ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: NonExWrite lock can't be within read lock", 0);
                        }
                        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            while (true) {
                                lo = myLocks.getObject(lockKey, this.synchDirectory);
                                try {
                                    lo.enterNonExWriteLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementNonExWriteLocks();
                        continue block23;
                    }
                    case 1: {
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
                            while (true) {
                                lo = myLocks.getObject(lockKey, this.synchDirectory);
                                try {
                                    lo.enterReadLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementReadLocks();
                    }
                }
            }
            Logging.lock.debug((Object)" Successfully obtained multiple locks!");
            return;
        }
        catch (Throwable ex) {
            ManifoldCFException ae = null;
            boolean errno = false;
            while (--locksProcessed >= 0) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                try {
                    switch (lockType) {
                        case 1: {
                            this.leaveReadLock(lockKey);
                            break;
                        }
                        case 2: {
                            this.leaveNonExWriteLock(lockKey);
                            break;
                        }
                        case 3: {
                            this.leaveWriteLock(lockKey);
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    ae = e;
                }
            }
            if (ae != null) {
                throw ae;
            }
            if (ex instanceof ManifoldCFException) {
                throw (ManifoldCFException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw new ManifoldCFException("Interrupted", ex, 2);
            }
            if (!(ex instanceof Error)) {
                throw new Error("Unexpected exception", ex);
            }
            throw (Error)ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterLocksNoWait(String[] readLocks, String[] nonExWriteLocks, String[] writeLocks) throws ManifoldCFException, LockException {
        int locksProcessed;
        if (Logging.lock.isDebugEnabled()) {
            int i;
            Logging.lock.debug((Object)"Entering multiple locks no wait:");
            if (readLocks != null) {
                i = 0;
                while (i < readLocks.length) {
                    Logging.lock.debug((Object)(" Read lock '" + readLocks[i++] + "'"));
                }
            }
            if (nonExWriteLocks != null) {
                i = 0;
                while (i < nonExWriteLocks.length) {
                    Logging.lock.debug((Object)(" Non-ex write lock '" + nonExWriteLocks[i++] + "'"));
                }
            }
            if (writeLocks != null) {
                i = 0;
                while (i < writeLocks.length) {
                    Logging.lock.debug((Object)(" Write lock '" + writeLocks[i++] + "'"));
                }
            }
        }
        LockDescription[] lds = this.getSortedUniqueLocks(readLocks, nonExWriteLocks, writeLocks);
        try {
            block32: for (locksProcessed = 0; locksProcessed < lds.length; ++locksProcessed) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                switch (lockType) {
                    case 3: {
                        LockObject lockObject;
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if ((ll.hasReadLock() || ll.hasNonExWriteLock()) && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: Write lock can't be within read lock or non-ex write lock", 0);
                        }
                        if (!ll.hasWriteLock()) {
                            while (true) {
                                lockObject = lo = myLocks.getObject(lockKey, this.synchDirectory);
                                synchronized (lockObject) {
                                    try {
                                        lo.enterWriteLockNoWait();
                                        break;
                                    }
                                    catch (ExpiredObjectException e) {
                                    }
                                }
                            }
                        }
                        ll.incrementWriteLocks();
                        continue block32;
                    }
                    case 2: {
                        LockObject lockObject;
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if (ll.hasReadLock() && !ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: NonExWrite lock can't be within read lock", 0);
                        }
                        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            while (true) {
                                lockObject = lo = myLocks.getObject(lockKey, this.synchDirectory);
                                synchronized (lockObject) {
                                    try {
                                        lo.enterNonExWriteLockNoWait();
                                        break;
                                    }
                                    catch (ExpiredObjectException e) {
                                    }
                                }
                            }
                        }
                        ll.incrementNonExWriteLocks();
                        continue block32;
                    }
                    case 1: {
                        LockObject lockObject;
                        LockObject lo;
                        LocalLock ll = this.getLocalLock(lockKey);
                        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
                            while (true) {
                                lockObject = lo = myLocks.getObject(lockKey, this.synchDirectory);
                                synchronized (lockObject) {
                                    try {
                                        lo.enterReadLockNoWait();
                                        break;
                                    }
                                    catch (ExpiredObjectException e) {
                                    }
                                }
                            }
                        }
                        ll.incrementReadLocks();
                    }
                }
            }
            Logging.lock.debug((Object)" Successfully obtained multiple locks!");
            return;
        }
        catch (Throwable ex) {
            ManifoldCFException ae = null;
            boolean errno = false;
            while (--locksProcessed >= 0) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                try {
                    switch (lockType) {
                        case 1: {
                            this.leaveReadLock(lockKey);
                            break;
                        }
                        case 2: {
                            this.leaveNonExWriteLock(lockKey);
                            break;
                        }
                        case 3: {
                            this.leaveWriteLock(lockKey);
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    ae = e;
                }
            }
            if (ae != null) {
                throw ae;
            }
            if (ex instanceof ManifoldCFException) {
                throw (ManifoldCFException)ex;
            }
            if (ex instanceof LockException || ex instanceof LocalLockException) {
                Logging.lock.debug((Object)" Couldn't get lock; throwing LockException");
                throw new LockException(ex.getMessage());
            }
            if (ex instanceof InterruptedException) {
                throw new ManifoldCFException("Interrupted", ex, 2);
            }
            if (!(ex instanceof Error)) {
                throw new Error("Unexpected exception", ex);
            }
            throw (Error)ex;
        }
    }

    public void leaveLocks(String[] readLocks, String[] writeNonExLocks, String[] writeLocks) throws ManifoldCFException {
        LockDescription[] lds = this.getSortedUniqueLocks(readLocks, writeNonExLocks, writeLocks);
        ManifoldCFException ae = null;
        int i = lds.length;
        while (--i >= 0) {
            LockDescription ld = lds[i];
            String lockKey = ld.getKey();
            int lockType = ld.getType();
            try {
                switch (lockType) {
                    case 1: {
                        this.leaveReadLock(lockKey);
                        break;
                    }
                    case 2: {
                        this.leaveNonExWriteLock(lockKey);
                        break;
                    }
                    case 3: {
                        this.leaveWriteLock(lockKey);
                    }
                }
            }
            catch (ManifoldCFException e) {
                ae = e;
            }
        }
        if (ae != null) {
            throw ae;
        }
    }

    public void enterReadCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        if (ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementReadLocks();
            return;
        }
        while (true) {
            LockObject lo = mySections.getObject(sectionKey, null);
            try {
                lo.enterReadLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementReadLocks();
    }

    public void leaveReadCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        ll.decrementReadLocks();
        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
            while (true) {
                LockObject lo = mySections.getObject(sectionKey, null);
                try {
                    lo.leaveReadLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveReadLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementReadLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalSection(sectionKey);
        }
    }

    public void enterNonExWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        if (ll.hasNonExWriteLock() || ll.hasWriteLock()) {
            ll.incrementNonExWriteLocks();
            return;
        }
        if (ll.hasReadLock()) {
            throw new ManifoldCFException("Illegal lock sequence: NonExWrite critical section can't be within read critical section", 0);
        }
        while (true) {
            LockObject lo = mySections.getObject(sectionKey, null);
            try {
                lo.enterNonExWriteLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementNonExWriteLocks();
    }

    public void leaveNonExWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        ll.decrementNonExWriteLocks();
        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
            while (true) {
                LockObject lo = mySections.getObject(sectionKey, null);
                try {
                    lo.leaveNonExWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveNonExWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementNonExWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalSection(sectionKey);
        }
    }

    public void enterWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        if (ll.hasWriteLock()) {
            ll.incrementWriteLocks();
            return;
        }
        if (ll.hasReadLock() || ll.hasNonExWriteLock()) {
            throw new ManifoldCFException("Illegal lock sequence: Write lock can't be within read lock or non-ex write lock", 0);
        }
        while (true) {
            LockObject lo = mySections.getObject(sectionKey, null);
            try {
                lo.enterWriteLock();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", e, 2);
            }
            catch (ExpiredObjectException e) {
                continue;
            }
            break;
        }
        ll.incrementWriteLocks();
    }

    public void leaveWriteCriticalSection(String sectionKey) throws ManifoldCFException {
        LocalLock ll = this.getLocalSection(sectionKey);
        ll.decrementWriteLocks();
        if (!ll.hasWriteLock()) {
            while (true) {
                LockObject lo = mySections.getObject(sectionKey, null);
                try {
                    lo.leaveWriteLock();
                }
                catch (InterruptedException e) {
                    try {
                        lo.leaveWriteLock();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                    catch (InterruptedException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e2, 2);
                    }
                    catch (ExpiredObjectException e2) {
                        ll.incrementWriteLocks();
                        throw new ManifoldCFException("Interrupted", e, 2);
                    }
                }
                catch (ExpiredObjectException e) {
                    continue;
                }
                break;
            }
            this.releaseLocalSection(sectionKey);
        }
    }

    public void enterCriticalSections(String[] readSectionKeys, String[] nonExSectionKeys, String[] writeSectionKeys) throws ManifoldCFException {
        int locksProcessed;
        LockDescription[] lds = this.getSortedUniqueLocks(readSectionKeys, nonExSectionKeys, writeSectionKeys);
        try {
            block20: for (locksProcessed = 0; locksProcessed < lds.length; ++locksProcessed) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                switch (lockType) {
                    case 3: {
                        LockObject lo;
                        LocalLock ll = this.getLocalSection(lockKey);
                        if ((ll.hasReadLock() || ll.hasNonExWriteLock()) && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: Write critical section can't be within read critical section or non-ex write critical section", 0);
                        }
                        if (!ll.hasWriteLock()) {
                            while (true) {
                                lo = mySections.getObject(lockKey, null);
                                try {
                                    lo.enterWriteLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementWriteLocks();
                        continue block20;
                    }
                    case 2: {
                        LockObject lo;
                        LocalLock ll = this.getLocalSection(lockKey);
                        if (ll.hasReadLock() && !ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            throw new ManifoldCFException("Illegal lock sequence: NonExWrite critical section can't be within read critical section", 0);
                        }
                        if (!ll.hasNonExWriteLock() && !ll.hasWriteLock()) {
                            while (true) {
                                lo = mySections.getObject(lockKey, null);
                                try {
                                    lo.enterNonExWriteLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementNonExWriteLocks();
                        continue block20;
                    }
                    case 1: {
                        LockObject lo;
                        LocalLock ll = this.getLocalSection(lockKey);
                        if (!(ll.hasReadLock() || ll.hasNonExWriteLock() || ll.hasWriteLock())) {
                            while (true) {
                                lo = mySections.getObject(lockKey, null);
                                try {
                                    lo.enterReadLock();
                                }
                                catch (ExpiredObjectException e) {
                                    continue;
                                }
                                break;
                            }
                        }
                        ll.incrementReadLocks();
                    }
                }
            }
            return;
        }
        catch (Throwable ex) {
            ManifoldCFException ae = null;
            boolean errno = false;
            while (--locksProcessed >= 0) {
                LockDescription ld = lds[locksProcessed];
                int lockType = ld.getType();
                String lockKey = ld.getKey();
                try {
                    switch (lockType) {
                        case 1: {
                            this.leaveReadCriticalSection(lockKey);
                            break;
                        }
                        case 2: {
                            this.leaveNonExWriteCriticalSection(lockKey);
                            break;
                        }
                        case 3: {
                            this.leaveWriteCriticalSection(lockKey);
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    ae = e;
                }
            }
            if (ae != null) {
                throw ae;
            }
            if (ex instanceof ManifoldCFException) {
                throw (ManifoldCFException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw new ManifoldCFException("Interrupted", ex, 2);
            }
            if (!(ex instanceof Error)) {
                throw new Error("Unexpected exception", ex);
            }
            throw (Error)ex;
        }
    }

    public void leaveCriticalSections(String[] readSectionKeys, String[] nonExSectionKeys, String[] writeSectionKeys) throws ManifoldCFException {
        LockDescription[] lds = this.getSortedUniqueLocks(readSectionKeys, nonExSectionKeys, writeSectionKeys);
        ManifoldCFException ae = null;
        int i = lds.length;
        while (--i >= 0) {
            LockDescription ld = lds[i];
            String lockKey = ld.getKey();
            int lockType = ld.getType();
            try {
                switch (lockType) {
                    case 1: {
                        this.leaveReadCriticalSection(lockKey);
                        break;
                    }
                    case 2: {
                        this.leaveNonExWriteCriticalSection(lockKey);
                        break;
                    }
                    case 3: {
                        this.leaveWriteCriticalSection(lockKey);
                    }
                }
            }
            catch (ManifoldCFException e) {
                ae = e;
            }
        }
        if (ae != null) {
            throw ae;
        }
    }

    protected LocalLock getLocalLock(String lockKey) {
        LocalLock ll = (LocalLock)this.localLocks.get(lockKey);
        if (ll == null) {
            ll = new LocalLock();
            this.localLocks.put(lockKey, ll);
        }
        return ll;
    }

    protected void releaseLocalLock(String lockKey) {
        this.localLocks.remove(lockKey);
    }

    protected LocalLock getLocalSection(String sectionKey) {
        LocalLock ll = (LocalLock)this.localSections.get(sectionKey);
        if (ll == null) {
            ll = new LocalLock();
            this.localSections.put(sectionKey, ll);
        }
        return ll;
    }

    protected void releaseLocalSection(String sectionKey) {
        this.localSections.remove(sectionKey);
    }

    protected LockDescription[] getSortedUniqueLocks(String[] readLocks, String[] writeNonExLocks, String[] writeLocks) {
        String key;
        LockDescription ld;
        int i;
        HashMap<String, LockDescription> ht = new HashMap<String, LockDescription>();
        if (readLocks != null) {
            i = 0;
            while (i < readLocks.length) {
                if ((ld = (LockDescription)ht.get(key = readLocks[i++])) == null) {
                    ld = new LockDescription(1, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(1);
            }
        }
        if (writeNonExLocks != null) {
            i = 0;
            while (i < writeNonExLocks.length) {
                if ((ld = (LockDescription)ht.get(key = writeNonExLocks[i++])) == null) {
                    ld = new LockDescription(2, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(2);
            }
        }
        if (writeLocks != null) {
            i = 0;
            while (i < writeLocks.length) {
                if ((ld = (LockDescription)ht.get(key = writeLocks[i++])) == null) {
                    ld = new LockDescription(3, key);
                    ht.put(key, ld);
                    continue;
                }
                ld.set(3);
            }
        }
        LockDescription[] rval = new LockDescription[ht.size()];
        Object[] sortarray = new String[ht.size()];
        i = 0;
        for (String key2 : ht.keySet()) {
            sortarray[i++] = key2;
        }
        Arrays.sort(sortarray);
        for (i = 0; i < sortarray.length; ++i) {
            rval[i] = (LockDescription)ht.get(sortarray[i]);
        }
        return rval;
    }

    protected String makeFilePath(String key) {
        int hashcode = key.hashCode();
        int outerDirNumber = hashcode & 0x3FF;
        int innerDirNumber = hashcode >> 10 & 0x3FF;
        String fullDir = this.synchDirectory.toString();
        if (fullDir.length() == 0 || !fullDir.endsWith("/")) {
            fullDir = fullDir + "/";
        }
        fullDir = fullDir + Integer.toString(outerDirNumber) + "/" + Integer.toString(innerDirNumber);
        return fullDir;
    }

    protected static class ByteArrayBuffer {
        protected byte[] buffer = new byte[128];
        protected int length = 0;

        public void add(byte b) {
            if (this.length == this.buffer.length) {
                byte[] oldbuffer = this.buffer;
                this.buffer = new byte[this.length * 2];
                System.arraycopy(oldbuffer, 0, this.buffer, 0, this.length);
            }
            this.buffer[this.length++] = b;
        }

        public byte[] toArray() {
            byte[] rval = new byte[this.length];
            System.arraycopy(this.buffer, 0, rval, 0, this.length);
            return rval;
        }
    }

    protected class LocalLock {
        private int readCount = 0;
        private int writeCount = 0;
        private int nonExWriteCount = 0;

        public boolean hasWriteLock() {
            return this.writeCount > 0;
        }

        public boolean hasReadLock() {
            return this.readCount > 0;
        }

        public boolean hasNonExWriteLock() {
            return this.nonExWriteCount > 0;
        }

        public void incrementReadLocks() {
            ++this.readCount;
        }

        public void incrementNonExWriteLocks() {
            ++this.nonExWriteCount;
        }

        public void incrementWriteLocks() {
            ++this.writeCount;
        }

        public void decrementReadLocks() {
            --this.readCount;
        }

        public void decrementNonExWriteLocks() {
            --this.nonExWriteCount;
        }

        public void decrementWriteLocks() {
            --this.writeCount;
        }
    }

    protected class LockDescription {
        protected int lockType;
        protected String lockKey;

        public LockDescription(int lockType, String lockKey) {
            this.lockType = lockType;
            this.lockKey = lockKey;
        }

        public void set(int lockType) {
            if (lockType > this.lockType) {
                this.lockType = lockType;
            }
        }

        public int getType() {
            return this.lockType;
        }

        public String getKey() {
            return this.lockKey;
        }
    }
}

