/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCFConfiguration;
import org.apache.manifoldcf.core.system.ManifoldCFResourceLoader;

public class ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String NODE_PROPERTY = "property";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String NODE_LIBDIR = "libdir";
    public static final String ATTRIBUTE_PATH = "path";
    protected static File workingDirectory = null;
    protected static ManifoldCFResourceLoader resourceLoader = null;
    protected static FileTrack tracker = null;
    protected static DatabaseShutdown dbShutdown = null;
    protected static ArrayList cleanupHooks = new ArrayList();
    protected static Thread shutdownThread = new ShutdownThread();
    protected static boolean isInitialized;
    protected static boolean alreadyClosed;
    protected static Integer initializeFlagLock;
    protected static String masterDatabaseName;
    protected static String masterDatabaseUsername;
    protected static String masterDatabasePassword;
    protected static ManifoldCFConfiguration localConfiguration;
    protected static Map localProperties;
    protected static long propertyFilelastMod;
    protected static String propertyFilePath;
    protected static final String applicationName = "lcf";
    public static final String lcfConfigFileProperty = "org.apache.manifoldcf.configfile";
    public static final String masterDatabaseNameProperty = "org.apache.manifoldcf.database.name";
    public static final String masterDatabaseUsernameProperty = "org.apache.manifoldcf.database.username";
    public static final String masterDatabasePasswordProperty = "org.apache.manifoldcf.database.password";
    public static final String databaseHandleMaxcountProperty = "org.apache.manifoldcf.database.maxhandles";
    public static final String databaseHandleTimeoutProperty = "org.apache.manifoldcf.database.handletimeout";
    public static final String logConfigFileProperty = "org.apache.manifoldcf.logconfigfile";
    public static final String lockManagerImplementation = "org.apache.manifoldcf.lockmanagerclass";
    public static final String databaseImplementation = "org.apache.manifoldcf.databaseimplementationclass";
    public static final String configSignalCommandProperty = "org.apache.manifoldcf.configuration.change.command";
    public static final String maintenanceFileSignalProperty = "org.apache.manifoldcf.database.maintenanceflag";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment() throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (isInitialized) {
                return;
            }
            try {
                Properties props = System.getProperties();
                propertyFilePath = (String)props.get(lcfConfigFileProperty);
                if (propertyFilePath == null) {
                    System.err.println("Couldn't find org.apache.manifoldcf.configfile property; using default");
                    String configPath = (String)props.get("user.home") + "/" + applicationName;
                    configPath = configPath.replace('\\', '/');
                    propertyFilePath = new File(configPath, "properties.xml").toString();
                }
                workingDirectory = new File(propertyFilePath).getAbsoluteFile().getParentFile();
                resourceLoader = new ManifoldCFResourceLoader(Thread.currentThread().getContextClassLoader());
                localConfiguration = new ManifoldCFConfiguration();
                localProperties = new HashMap();
                ManifoldCF.checkProperties();
                File logConfigFile = ManifoldCF.getFileProperty(logConfigFileProperty);
                if (logConfigFile == null) {
                    System.err.println("Couldn't find org.apache.manifoldcf.logconfigfile property; using default");
                    String configPath = (String)props.get("user.home") + "/" + applicationName;
                    configPath = configPath.replace('\\', '/');
                    logConfigFile = new File(configPath, "logging.ini");
                }
                Logging.initializeLoggingSystem(logConfigFile);
                Logging.initializeLoggers();
                Logging.setLogLevels();
                masterDatabaseName = ManifoldCF.getProperty(masterDatabaseNameProperty);
                if (masterDatabaseName == null) {
                    masterDatabaseName = "dbname";
                }
                if ((masterDatabaseUsername = ManifoldCF.getProperty(masterDatabaseUsernameProperty)) == null) {
                    masterDatabaseUsername = "manifoldcf";
                }
                if ((masterDatabasePassword = ManifoldCF.getProperty(masterDatabasePasswordProperty)) == null) {
                    masterDatabasePassword = "local_pg_passwd";
                }
                tracker = new FileTrack();
                ManifoldCF.addShutdownHook(tracker);
                ManifoldCF.addShutdownHook(new DatabaseShutdown());
                IThreadContext threadcontext = ThreadContextFactory.make();
                DBInterfaceFactory.make(threadcontext, masterDatabaseName, masterDatabaseUsername, masterDatabasePassword).openDatabase();
                isInitialized = true;
            }
            catch (ManifoldCFException e) {
                throw new ManifoldCFException("Initialization failed: " + e.getMessage(), e, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkProperties() throws ManifoldCFException {
        block10: {
            File f = new File(propertyFilePath);
            try {
                if (propertyFilelastMod != f.lastModified()) {
                    FileInputStream is = new FileInputStream(f);
                    try {
                        localConfiguration.fromXML(is);
                        System.err.println("Configuration file successfully read");
                        propertyFilelastMod = f.lastModified();
                        break block10;
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                System.err.println("Configuration file not read because it didn't change");
                return;
            }
            catch (Exception e) {
                throw new ManifoldCFException("Could not read configuration file '" + f.toString() + "'", e);
            }
        }
        localProperties.clear();
        ArrayList<File> libDirs = new ArrayList<File>();
        int i = 0;
        while (i < localConfiguration.getChildCount()) {
            ConfigurationNode cn;
            if ((cn = localConfiguration.findChild(i++)).getType().equals(NODE_PROPERTY)) {
                String name = cn.getAttributeValue(ATTRIBUTE_NAME);
                String value = cn.getAttributeValue(ATTRIBUTE_VALUE);
                if (name == null) {
                    throw new ManifoldCFException("Node type 'property' requires a 'name' attribute");
                }
                localProperties.put(name, value);
                continue;
            }
            if (!cn.getType().equals(NODE_LIBDIR)) continue;
            String path = cn.getAttributeValue(ATTRIBUTE_PATH);
            if (path == null) {
                throw new ManifoldCFException("Node type 'libdir' requires a 'path attribute");
            }
            libDirs.add(ManifoldCF.resolvePath(path));
        }
        resourceLoader.setClassPath(libDirs);
    }

    public static File resolvePath(String path) {
        File r = new File(path);
        return r.isAbsolute() ? r : new File(workingDirectory, path);
    }

    public static String getProperty(String s) {
        String rval = System.getProperty(s);
        if (rval == null) {
            rval = (String)localProperties.get(s);
        }
        return rval;
    }

    public static File getFileProperty(String s) {
        String value = ManifoldCF.getProperty(s);
        if (value == null) {
            return null;
        }
        return ManifoldCF.resolvePath(value);
    }

    public static int getIntProperty(String s, int defaultValue) throws ManifoldCFException {
        String value = ManifoldCF.getProperty(s);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Illegal property value for integer property '" + s + "': '" + value + "': " + e.getMessage(), e, 3);
        }
    }

    public static void ensureFolder(String path) throws ManifoldCFException {
        try {
            File f = new File(path);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            throw new ManifoldCFException("Can't make folder", e, 0);
        }
    }

    public static void deleteFolder(String path) {
        File directoryPath = new File(path);
        ManifoldCF.recursiveDelete(directoryPath);
    }

    protected static void recursiveDelete(File directoryPath) {
        File[] children = directoryPath.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                File x;
                if ((x = children[i++]).isDirectory()) {
                    ManifoldCF.recursiveDelete(x);
                    continue;
                }
                x.delete();
            }
        }
        directoryPath.delete();
    }

    public static boolean isFolder(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    public static String safeFileName(String value) {
        StringBuffer rval = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '/' || x == '\"' || x == '\\' || x == '|' || x >= '\u0000' && x < ' ' || x == '+' || x == ',' || x == ':' || x == ';' || x == '<' || x == '>' || x == '=' || x == '[' || x == ']' || x == '&') {
                rval.append("&").append(Integer.toString(x)).append("!");
                continue;
            }
            rval.append(x);
        }
        return rval.toString();
    }

    public static String getMasterDatabaseName() {
        return masterDatabaseName;
    }

    public static String getMasterDatabaseUsername() {
        return masterDatabaseUsername;
    }

    public static String getMasterDatabasePassword() {
        return masterDatabasePassword;
    }

    public static String getChildDatabaseName(IDBInterface companyDatabase, String childDBIdentifier) {
        return companyDatabase.getDatabaseName() + "_" + childDBIdentifier;
    }

    public static String hash(String input) throws ManifoldCFException {
        return ManifoldCF.encrypt(input);
    }

    public static MessageDigest startHash() throws ManifoldCFException {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static void addToHash(MessageDigest digest, String input) throws ManifoldCFException {
        try {
            byte[] inputBytes = input.getBytes("UTF-8");
            digest.update(inputBytes);
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static String getHashValue(MessageDigest digest) throws ManifoldCFException {
        try {
            byte[] encryptedBytes = digest.digest();
            StringBuffer rval = new StringBuffer();
            int i = 0;
            while (i < encryptedBytes.length) {
                byte x = encryptedBytes[i++];
                rval.append(ManifoldCF.writeNibble(x >> 4 & 0xF));
                rval.append(ManifoldCF.writeNibble(x & 0xF));
            }
            return rval.toString();
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static String encrypt(String input) throws ManifoldCFException {
        MessageDigest hash = ManifoldCF.startHash();
        ManifoldCF.addToHash(hash, input);
        return ManifoldCF.getHashValue(hash);
    }

    public static String obfuscate(String input) throws ManifoldCFException {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() == 0) {
                return input;
            }
            byte[] array = input.getBytes("UTF-8");
            int i = 0;
            int carryover = array[array.length - 1] & 0x1F;
            while (i < array.length) {
                int x = array[i];
                int newCarryover = x & 0x1F;
                x = (x >> 5 & 7) + (carryover << 3);
                carryover = newCarryover;
                array[i++] = (byte)(x ^ 0x59);
            }
            StringBuffer rval = new StringBuffer();
            i = 0;
            while (i < array.length) {
                byte x = array[i++];
                rval.append(ManifoldCF.writeNibble(x >> 4 & 0xF));
                rval.append(ManifoldCF.writeNibble(x & 0xF));
            }
            return rval.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new ManifoldCFException("UTF-8 not supported", e, 0);
        }
    }

    protected static char writeNibble(int value) {
        if (value >= 10) {
            return (char)(value - 10 + 65);
        }
        return (char)(value + 48);
    }

    public static String deobfuscate(String input) throws ManifoldCFException {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() == 0) {
                return input;
            }
            if ((input.length() >> 1) * 2 != input.length()) {
                throw new ManifoldCFException("Decoding error", 0);
            }
            byte[] bytes = new byte[input.length() >> 1];
            int i = 0;
            int j = 0;
            while (i < input.length()) {
                int x0 = ManifoldCF.readNibble(input.charAt(i++));
                int x1 = ManifoldCF.readNibble(input.charAt(i++));
                int x = (x0 << 4) + x1;
                bytes[j++] = (byte)x;
            }
            int carryover = (bytes[0] ^ 0x59) >> 3 & 0x1F;
            i = bytes.length;
            while (i > 0) {
                int x = bytes[--i] ^ 0x59;
                int newCarryover = x >> 3 & 0x1F;
                x = (x << 5) + carryover;
                bytes[i] = (byte)x;
                carryover = newCarryover;
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ManifoldCFException("UTF-8 unsupported", e, 0);
        }
    }

    protected static int readNibble(char value) throws ManifoldCFException {
        if (value >= 'A' && value <= 'F') {
            return value - 65 + 10;
        }
        if (value >= '0' && value <= '9') {
            return value - 48;
        }
        throw new ManifoldCFException("Bad hexadecimal value", 0);
    }

    public static void createSystemDatabase(IThreadContext threadcontext, String masterUsername, String masterPassword) throws ManifoldCFException {
        String databaseName = ManifoldCF.getMasterDatabaseName();
        String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
        String databasePassword = ManifoldCF.getMasterDatabasePassword();
        IDBInterface master = DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword);
        master.createUserAndDatabase(masterUsername, masterPassword, null);
    }

    public static void dropSystemDatabase(IThreadContext threadcontext, String masterUsername, String masterPassword) throws ManifoldCFException {
        String databaseName = ManifoldCF.getMasterDatabaseName();
        String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
        String databasePassword = ManifoldCF.getMasterDatabasePassword();
        IDBInterface master = DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword);
        master.dropUserAndDatabase(masterUsername, masterPassword, null);
    }

    public static void addFile(File f) {
        tracker.addFile(f);
    }

    public static void deleteFile(File f) {
        tracker.deleteFile(f);
    }

    public static boolean checkMaintenanceUnderway() {
        String fileToCheck = ManifoldCF.getProperty(maintenanceFileSignalProperty);
        if (fileToCheck != null && fileToCheck.length() > 0) {
            File f = new File(fileToCheck);
            return f.exists();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteConfigurationChange() throws ManifoldCFException {
        String configChangeSignalCommand = ManifoldCF.getProperty(configSignalCommandProperty);
        if (configChangeSignalCommand == null || configChangeSignalCommand.length() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int currentIndex = 0;
        while (currentIndex < configChangeSignalCommand.length()) {
            char x;
            while (currentIndex < configChangeSignalCommand.length() && (x = configChangeSignalCommand.charAt(currentIndex)) >= '\u0000' && x <= ' ') {
                ++currentIndex;
            }
            StringBuffer argBuffer = new StringBuffer();
            boolean isQuoted = false;
            while (currentIndex < configChangeSignalCommand.length()) {
                char x2 = configChangeSignalCommand.charAt(currentIndex);
                if (isQuoted) {
                    if (x2 == '\"') {
                        ++currentIndex;
                        isQuoted = false;
                        continue;
                    }
                    if (x2 == '\\') {
                        if (++currentIndex >= configChangeSignalCommand.length()) break;
                        x2 = configChangeSignalCommand.charAt(currentIndex);
                        argBuffer.append(x2);
                        continue;
                    }
                    ++currentIndex;
                    argBuffer.append(x2);
                    continue;
                }
                if (x2 == '\"') {
                    ++currentIndex;
                    isQuoted = true;
                    continue;
                }
                if (x2 == '\\') {
                    if (++currentIndex >= configChangeSignalCommand.length()) break;
                    x2 = configChangeSignalCommand.charAt(currentIndex);
                    argBuffer.append(x2);
                    continue;
                }
                if (x2 >= '\u0000' && x2 <= ' ') break;
                ++currentIndex;
                argBuffer.append(x2);
            }
            list.add(argBuffer.toString());
        }
        String[] commandArray = new String[list.size()];
        for (int i = 0; i < commandArray.length; ++i) {
            commandArray[i] = (String)list.get(i);
        }
        if (commandArray.length == 0) {
            return;
        }
        String[] env = new String[]{};
        File dir = new File("/");
        try {
            Process p = Runtime.getRuntime().exec(commandArray, env, dir);
            try {
                int rval = p.waitFor();
                if (rval != 0) {
                    InputStream is = p.getErrorStream();
                    try {
                        InputStreamReader r = new InputStreamReader(is);
                        try {
                            BufferedReader br = new BufferedReader(r);
                            try {
                                String value;
                                StringBuffer sb = new StringBuffer();
                                while ((value = br.readLine()) != null) {
                                    sb.append(value).append("; ");
                                }
                                throw new ManifoldCFException("Shelled process '" + configChangeSignalCommand + "' failed with error " + Integer.toString(rval) + ": " + sb.toString());
                            }
                            catch (Throwable throwable) {
                                br.close();
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            ((Reader)r).close();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        is.close();
                        throw throwable;
                    }
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Process wait interrupted: " + e.getMessage(), e, 2);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("IO with subprocess interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception signalling change: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long milliseconds) throws InterruptedException {
        Integer x;
        Integer n = x = new Integer(0);
        synchronized (n) {
            x.wait(milliseconds);
        }
    }

    public static void writeBytes(OutputStream os, byte[] byteArray) throws IOException {
        os.write(byteArray, 0, byteArray.length);
    }

    public static void writeByte(OutputStream os, int byteValue) throws IOException {
        ManifoldCF.writeBytes(os, new byte[]{(byte)byteValue});
    }

    public static void writeWord(OutputStream os, int wordValue) throws IOException {
        byte[] buffer = new byte[]{(byte)(wordValue & 0xFF), (byte)(wordValue >>> 8 & 0xFF)};
        ManifoldCF.writeBytes(os, buffer);
    }

    public static void writeDword(OutputStream os, int dwordValue) throws IOException {
        if (dwordValue < 0) {
            throw new IllegalArgumentException("Attempt to use an unsigned operator to write a signed value");
        }
        ManifoldCF.writeSdword(os, dwordValue);
    }

    public static void writeSdword(OutputStream os, int dwordValue) throws IOException {
        byte[] buffer = new byte[]{(byte)(dwordValue & 0xFF), (byte)(dwordValue >>> 8 & 0xFF), (byte)(dwordValue >>> 16 & 0xFF), (byte)(dwordValue >>> 24 & 0xFF)};
        ManifoldCF.writeBytes(os, buffer);
    }

    public static void writeLong(OutputStream os, Long longValue) throws IOException {
        if (longValue == null) {
            ManifoldCF.writeByte(os, 1);
        } else {
            ManifoldCF.writeByte(os, 0);
            long value = longValue;
            byte[] buffer = new byte[]{(byte)(value & 0xFFL), (byte)(Long.rotateRight(value, 8) & 0xFFL), (byte)(Long.rotateRight(value, 16) & 0xFFL), (byte)(Long.rotateRight(value, 24) & 0xFFL), (byte)(Long.rotateRight(value, 32) & 0xFFL), (byte)(Long.rotateRight(value, 40) & 0xFFL), (byte)(Long.rotateRight(value, 48) & 0xFFL), (byte)(Long.rotateRight(value, 56) & 0xFFL)};
            ManifoldCF.writeBytes(os, buffer);
        }
    }

    public static void writeString(OutputStream os, String stringValue) throws IOException {
        byte[] characters = stringValue == null ? null : stringValue.getBytes("utf-8");
        ManifoldCF.writeByteArray(os, characters);
    }

    public static void writeByteArray(OutputStream os, byte[] byteArray) throws IOException {
        if (byteArray == null) {
            ManifoldCF.writeSdword(os, -1);
        } else {
            ManifoldCF.writeSdword(os, byteArray.length);
            ManifoldCF.writeBytes(os, byteArray);
        }
    }

    public static void writefloat(OutputStream os, float floatValue) throws IOException {
        ManifoldCF.writeSdword(os, Float.floatToIntBits(floatValue));
    }

    public static void readBytes(InputStream is, byte[] byteArray) throws IOException {
        int amt;
        for (int amtSoFar = 0; amtSoFar < byteArray.length; amtSoFar += amt) {
            amt = is.read(byteArray, amtSoFar, byteArray.length - amtSoFar);
            if (amt != -1) continue;
            throw new IOException("Unexpected EOF");
        }
    }

    public static int readByte(InputStream is) throws IOException {
        byte[] inputArray = new byte[1];
        ManifoldCF.readBytes(is, inputArray);
        return inputArray[0] & 0xFF;
    }

    public static int readWord(InputStream is) throws IOException {
        byte[] inputArray = new byte[2];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8);
    }

    public static int readDword(InputStream is) throws IOException {
        byte[] inputArray = new byte[4];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8) + ((inputArray[2] & 0xFF) << 16) + ((inputArray[3] & 0xFF) << 24);
    }

    public static int readSdword(InputStream is) throws IOException {
        byte[] inputArray = new byte[4];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8) + ((inputArray[2] & 0xFF) << 16) + (inputArray[3] << 24);
    }

    public static Long readLong(InputStream is) throws IOException {
        int value = ManifoldCF.readByte(is);
        if (value == 1) {
            return null;
        }
        byte[] inputArray = new byte[8];
        ManifoldCF.readBytes(is, inputArray);
        return new Long((long)(inputArray[0] & 0xFF) + Long.rotateLeft(inputArray[1] & 0xFF, 8) + Long.rotateLeft(inputArray[2] & 0xFF, 16) + Long.rotateLeft(inputArray[3] & 0xFF, 24) + Long.rotateLeft(inputArray[4] & 0xFF, 32) + Long.rotateLeft(inputArray[5] & 0xFF, 40) + Long.rotateLeft(inputArray[6] & 0xFF, 48) + Long.rotateLeft(inputArray[7] & 0xFF, 56));
    }

    public static String readString(InputStream is) throws IOException {
        byte[] bytes = ManifoldCF.readByteArray(is);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "utf-8");
    }

    public static byte[] readByteArray(InputStream is) throws IOException {
        int length = ManifoldCF.readSdword(is);
        if (length == -1) {
            return null;
        }
        byte[] byteArray = new byte[length];
        ManifoldCF.readBytes(is, byteArray);
        return byteArray;
    }

    public static float readfloat(InputStream os) throws IOException {
        return Float.intBitsToFloat(ManifoldCF.readSdword(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(IShutdownHook hook) {
        ArrayList arrayList = cleanupHooks;
        synchronized (arrayList) {
            cleanupHooks.add(hook);
        }
    }

    public static ManifoldCFResourceLoader createResourceLoader() throws ManifoldCFException {
        return new ManifoldCFResourceLoader(resourceLoader.getClassLoader());
    }

    public static Class findClass(String cname) throws ClassNotFoundException, ManifoldCFException {
        return resourceLoader.findClass(cname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanUpSystem() {
        ArrayList arrayList = cleanupHooks;
        synchronized (arrayList) {
            int i = cleanupHooks.size();
            while (i > 0) {
                IShutdownHook hook = (IShutdownHook)cleanupHooks.get(--i);
                try {
                    hook.doCleanup();
                }
                catch (ManifoldCFException e) {
                    Logging.root.warn((Object)("Error during system shutdown: " + e.getMessage()), (Throwable)e);
                }
            }
            cleanupHooks.clear();
        }
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        isInitialized = false;
        alreadyClosed = false;
        initializeFlagLock = new Integer(0);
        masterDatabaseName = null;
        masterDatabaseUsername = null;
        masterDatabasePassword = null;
        localConfiguration = null;
        localProperties = null;
        propertyFilelastMod = -1L;
        propertyFilePath = null;
    }

    protected static class DatabaseConnectionReleaseThread
    extends Thread {
        public DatabaseConnectionReleaseThread() {
            this.setName("Database connection release thread");
            this.setDaemon(true);
        }

        public void run() {
            ConnectionFactory.releaseAll();
        }
    }

    protected static class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            this.setName("Shutdown thread");
        }

        public void run() {
            ManifoldCF.cleanUpSystem();
        }
    }

    protected static class DatabaseShutdown
    implements IShutdownHook {
        public void doCleanup() throws ManifoldCFException {
            DatabaseConnectionReleaseThread t = new DatabaseConnectionReleaseThread();
            t.start();
            try {
                t.join(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.closeDatabase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeDatabase() throws ManifoldCFException {
            Integer n = initializeFlagLock;
            synchronized (n) {
                if (isInitialized && !alreadyClosed) {
                    IThreadContext threadcontext = ThreadContextFactory.make();
                    String databaseName = ManifoldCF.getMasterDatabaseName();
                    String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
                    String databasePassword = ManifoldCF.getMasterDatabasePassword();
                    DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword).closeDatabase();
                    alreadyClosed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.closeDatabase();
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class FileTrack
    implements IShutdownHook {
        protected HashMap filesToDelete = new HashMap();

        public synchronized void addFile(File f) {
            this.filesToDelete.put(f, f);
        }

        public synchronized void deleteFile(File f) {
            f.delete();
            this.filesToDelete.remove(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doCleanup() throws ManifoldCFException {
            FileTrack fileTrack = this;
            synchronized (fileTrack) {
                for (File f : this.filesToDelete.keySet()) {
                    f.delete();
                }
                this.filesToDelete.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.doCleanup();
            }
            finally {
                super.finalize();
            }
        }
    }
}

