/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.urlnormalizer.basic;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.net.URLNormalizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicURLNormalizer
extends Configured
implements URLNormalizer {
    public static final Logger LOG = LoggerFactory.getLogger(BasicURLNormalizer.class);
    private Perl5Compiler compiler = new Perl5Compiler();
    private ThreadLocal<Perl5Matcher> matchers = new ThreadLocal<Perl5Matcher>(){

        @Override
        protected Perl5Matcher initialValue() {
            return new Perl5Matcher();
        }
    };
    private final Rule relativePathRule;
    private final Rule leadingRelativePathRule;
    private final Rule currentPathRule;
    private final Rule adjacentSlashRule;
    private static final java.util.regex.Pattern hasNormalizablePattern = java.util.regex.Pattern.compile("/\\.?\\.?/");
    private Configuration conf;

    public BasicURLNormalizer() {
        try {
            this.relativePathRule = new Rule();
            this.relativePathRule.pattern = (Perl5Pattern)this.compiler.compile("(/[^/]*[^/.]{1}[^/]*/\\.\\./)", 32768);
            this.relativePathRule.substitution = new Perl5Substitution("/");
            this.leadingRelativePathRule = new Rule();
            this.leadingRelativePathRule.pattern = (Perl5Pattern)this.compiler.compile("^(/\\.\\./)+", 32768);
            this.leadingRelativePathRule.substitution = new Perl5Substitution("/");
            this.currentPathRule = new Rule();
            this.currentPathRule.pattern = (Perl5Pattern)this.compiler.compile("(/\\./)", 32768);
            this.currentPathRule.substitution = new Perl5Substitution("/");
            this.adjacentSlashRule = new Rule();
            this.adjacentSlashRule.pattern = (Perl5Pattern)this.compiler.compile("/{2,}", 32768);
            this.adjacentSlashRule.substitution = new Perl5Substitution("/");
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e);
        }
    }

    public String normalize(String urlString, String scope) throws MalformedURLException {
        if ("".equals(urlString)) {
            return urlString;
        }
        urlString = urlString.trim();
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String file = url.getFile();
        boolean changed = false;
        if (!urlString.startsWith(protocol)) {
            changed = true;
        }
        if ("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol)) {
            String file2;
            String newHost;
            if (host != null && !host.equals(newHost = host.toLowerCase())) {
                host = newHost;
                changed = true;
            }
            if (port == url.getDefaultPort()) {
                port = -1;
                changed = true;
            }
            if (file == null || "".equals(file)) {
                file = "/";
                changed = true;
            }
            if (url.getRef() != null) {
                changed = true;
            }
            if (!file.equals(file2 = this.substituteUnnecessaryRelativePaths(file))) {
                changed = true;
                file = file2;
            }
        }
        if (changed) {
            urlString = new URL(protocol, host, port, file).toString();
        }
        return urlString;
    }

    private String substituteUnnecessaryRelativePaths(String file) {
        if (!hasNormalizablePattern.matcher(file).find()) {
            return file;
        }
        String fileWorkCopy = file;
        int oldLen = file.length();
        int newLen = oldLen - 1;
        Perl5Matcher matcher = this.matchers.get();
        while (oldLen != newLen) {
            oldLen = fileWorkCopy.length();
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this.relativePathRule.pattern, (Substitution)this.relativePathRule.substitution, (String)fileWorkCopy, (int)1);
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this.leadingRelativePathRule.pattern, (Substitution)this.leadingRelativePathRule.substitution, (String)fileWorkCopy, (int)1);
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this.currentPathRule.pattern, (Substitution)this.currentPathRule.substitution, (String)fileWorkCopy, (int)1);
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this.adjacentSlashRule.pattern, (Substitution)this.adjacentSlashRule.substitution, (String)fileWorkCopy, (int)1);
            newLen = fileWorkCopy.length();
        }
        return fileWorkCopy;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static class Rule {
        public Perl5Pattern pattern;
        public Perl5Substitution substitution;

        private Rule() {
        }
    }
}

