/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.lucene.Lucene;

public final class XNGramTokenizer
extends Tokenizer {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private char[] buffer;
    private int bufferStart;
    private int bufferEnd;
    private int offset;
    private int gramSize;
    private int minGram;
    private int maxGram;
    private boolean exhausted;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    static final /* synthetic */ boolean $assertionsDisabled;

    public XNGramTokenizer(Version version, Reader input, int minGram, int maxGram) {
        super(input);
        this.init(version, minGram, maxGram);
    }

    public XNGramTokenizer(Version version, AttributeSource.AttributeFactory factory, Reader input, int minGram, int maxGram) {
        super(factory, input);
        this.init(version, minGram, maxGram);
    }

    public XNGramTokenizer(Version version, Reader input) {
        this(version, input, 1, 2);
    }

    private void init(Version version, int minGram, int maxGram) {
        if (!version.onOrAfter(Version.LUCENE_42)) {
            throw new IllegalArgumentException("This class only works with Lucene 4.4+. To emulate the old (broken) behavior of NGramTokenizer, use Lucene43NGramTokenizer");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.buffer = new char[maxGram + 1024];
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.bufferStart >= this.buffer.length - this.maxGram) {
            System.arraycopy(this.buffer, this.bufferStart, this.buffer, 0, this.bufferEnd - this.bufferStart);
            this.bufferEnd -= this.bufferStart;
            this.bufferStart = 0;
            if (!this.exhausted) {
                while (this.bufferEnd < this.buffer.length) {
                    int read = this.input.read(this.buffer, this.bufferEnd, this.buffer.length - this.bufferEnd);
                    if (read == -1) {
                        this.exhausted = true;
                        break;
                    }
                    this.bufferEnd += read;
                }
            }
        }
        if (this.gramSize > this.maxGram || this.bufferStart + this.gramSize > this.bufferEnd) {
            ++this.bufferStart;
            ++this.offset;
            this.gramSize = this.minGram;
        }
        if (this.bufferStart + this.gramSize > this.bufferEnd) {
            return false;
        }
        this.termAtt.copyBuffer(this.buffer, this.bufferStart, this.gramSize);
        this.posIncAtt.setPositionIncrement(1);
        this.posLenAtt.setPositionLength(1);
        this.offsetAtt.setOffset(this.correctOffset(this.offset), this.correctOffset(this.offset + this.gramSize));
        ++this.gramSize;
        return true;
    }

    public void end() {
        int endOffset = this.correctOffset(this.offset + this.bufferEnd - this.bufferStart);
        this.offsetAtt.setOffset(endOffset, endOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.bufferStart = this.bufferEnd = this.buffer.length;
        this.offset = 0;
        this.gramSize = this.minGram;
        this.exhausted = false;
    }

    static {
        boolean bl = $assertionsDisabled = !XNGramTokenizer.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Lucene.VERSION.ordinal() >= Version.LUCENE_42.ordinal() + 2) {
            throw new AssertionError((Object)("Elasticsearch has upgraded to Lucene Version: [" + Lucene.VERSION + "] this should can be removed"));
        }
    }
}

