/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.store.StoreUtils;

public final class RateLimitedFSDirectory
extends Directory {
    private final FSDirectory delegate;
    private final StoreRateLimiting.Provider rateLimitingProvider;
    private final StoreRateLimiting.Listener rateListener;

    public RateLimitedFSDirectory(FSDirectory wrapped, StoreRateLimiting.Provider rateLimitingProvider, StoreRateLimiting.Listener rateListener) {
        this.delegate = wrapped;
        this.rateLimitingProvider = rateLimitingProvider;
        this.rateListener = rateListener;
    }

    public FSDirectory wrappedDirectory() {
        return this.delegate;
    }

    public String[] listAll() throws IOException {
        this.ensureOpen();
        return this.delegate.listAll();
    }

    public boolean fileExists(String name) throws IOException {
        this.ensureOpen();
        return this.delegate.fileExists(name);
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        this.delegate.deleteFile(name);
    }

    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        return this.delegate.fileLength(name);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        IndexOutput output = this.delegate.createOutput(name, context);
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return output;
        }
        if (context.context == IOContext.Context.MERGE) {
            return new RateLimitedIndexOutput(limiter, this.rateListener, output);
        }
        if (type == StoreRateLimiting.Type.ALL) {
            return new RateLimitedIndexOutput(limiter, this.rateListener, output);
        }
        return output;
    }

    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        this.delegate.sync(names);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        return this.delegate.openInput(name, context);
    }

    public void close() throws IOException {
        this.isOpen = false;
        this.delegate.close();
    }

    public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
        this.ensureOpen();
        return this.delegate.createSlicer(name, context);
    }

    public Lock makeLock(String name) {
        this.ensureOpen();
        return this.delegate.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.ensureOpen();
        this.delegate.clearLock(name);
    }

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.ensureOpen();
        this.delegate.setLockFactory(lockFactory);
    }

    public LockFactory getLockFactory() {
        this.ensureOpen();
        return this.delegate.getLockFactory();
    }

    public String getLockID() {
        this.ensureOpen();
        return this.delegate.getLockID();
    }

    public String toString() {
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return StoreUtils.toString((Directory)this.delegate);
        }
        return "rate_limited(" + StoreUtils.toString((Directory)this.delegate) + ", type=" + type.name() + ", rate=" + limiter.getMbPerSec() + ")";
    }

    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.ensureOpen();
        this.delegate.copy(to, src, dest, context);
    }

    static final class RateLimitedIndexOutput
    extends BufferedIndexOutput {
        private final IndexOutput delegate;
        private final BufferedIndexOutput bufferedDelegate;
        private final RateLimiter rateLimiter;
        private final StoreRateLimiting.Listener rateListener;

        RateLimitedIndexOutput(RateLimiter rateLimiter, StoreRateLimiting.Listener rateListener, IndexOutput delegate) {
            if (delegate instanceof BufferedIndexOutput) {
                this.bufferedDelegate = (BufferedIndexOutput)delegate;
                this.delegate = delegate;
            } else {
                this.delegate = delegate;
                this.bufferedDelegate = null;
            }
            this.rateLimiter = rateLimiter;
            this.rateListener = rateListener;
        }

        protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
            this.rateListener.onPause(this.rateLimiter.pause((long)len));
            if (this.bufferedDelegate != null) {
                this.bufferedDelegate.flushBuffer(b, offset, len);
            } else {
                this.delegate.writeBytes(b, offset, len);
            }
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public void seek(long pos) throws IOException {
            this.flush();
            this.delegate.seek(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            try {
                super.flush();
            }
            finally {
                this.delegate.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.delegate.close();
            }
        }
    }
}

