/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterShardHealth;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class ClusterIndexHealth
implements Iterable<ClusterShardHealth>,
Streamable {
    private String index;
    private int numberOfShards;
    private int numberOfReplicas;
    int activeShards = 0;
    int relocatingShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    int activePrimaryShards = 0;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    final Map<Integer, ClusterShardHealth> shards = Maps.newHashMap();
    List<String> validationFailures;

    private ClusterIndexHealth() {
    }

    public ClusterIndexHealth(String index, int numberOfShards, int numberOfReplicas, List<String> validationFailures) {
        this.index = index;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.validationFailures = validationFailures;
    }

    public String getIndex() {
        return this.index;
    }

    public List<String> getValidationFailures() {
        return this.validationFailures;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ClusterShardHealth> iterator() {
        return this.shards.values().iterator();
    }

    public static ClusterIndexHealth readClusterIndexHealth(StreamInput in) throws IOException {
        ClusterIndexHealth indexHealth = new ClusterIndexHealth();
        indexHealth.readFrom(in);
        return indexHealth;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            ClusterShardHealth shardHealth = ClusterShardHealth.readClusterShardHealth(in);
            this.shards.put(shardHealth.getId(), shardHealth);
        }
        size = in.readVInt();
        if (size == 0) {
            this.validationFailures = ImmutableList.of();
        } else {
            for (i = 0; i < size; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeVInt(this.shards.size());
        for (ClusterShardHealth shardHealth : this) {
            shardHealth.writeTo(out);
        }
        out.writeVInt(this.validationFailures.size());
        for (String failure : this.validationFailures) {
            out.writeString(failure);
        }
    }
}

