/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class NodesStatsResponse
extends NodesOperationResponse<NodeStats>
implements ToXContent {
    NodesStatsResponse() {
    }

    public NodesStatsResponse(ClusterName clusterName, NodeStats[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeStats[in.readVInt()];
        for (int i = 0; i < ((NodeStats[])this.nodes).length; ++i) {
            ((NodeStats[])this.nodes)[i] = NodeStats.readNodeStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeStats[])this.nodes).length);
        for (NodeStats node : (NodeStats[])this.nodes) {
            node.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_name", this.getClusterName().value());
        builder.startObject("nodes");
        for (NodeStats nodeStats : this) {
            builder.startObject(nodeStats.getNode().id(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("timestamp", nodeStats.getTimestamp());
            builder.field("name", nodeStats.getNode().name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("transport_address", nodeStats.getNode().address().toString());
            if (nodeStats.getHostname() != null) {
                builder.field("hostname", nodeStats.getHostname(), XContentBuilder.FieldCaseConversion.NONE);
            }
            if (!nodeStats.getNode().attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr : nodeStats.getNode().attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue());
                }
                builder.endObject();
            }
            if (nodeStats.getIndices() != null) {
                nodeStats.getIndices().toXContent(builder, params);
            }
            if (nodeStats.getOs() != null) {
                nodeStats.getOs().toXContent(builder, params);
            }
            if (nodeStats.getProcess() != null) {
                nodeStats.getProcess().toXContent(builder, params);
            }
            if (nodeStats.getJvm() != null) {
                nodeStats.getJvm().toXContent(builder, params);
            }
            if (nodeStats.getThreadPool() != null) {
                nodeStats.getThreadPool().toXContent(builder, params);
            }
            if (nodeStats.getNetwork() != null) {
                nodeStats.getNetwork().toXContent(builder, params);
            }
            if (nodeStats.getFs() != null) {
                nodeStats.getFs().toXContent(builder, params);
            }
            if (nodeStats.getTransport() != null) {
                nodeStats.getTransport().toXContent(builder, params);
            }
            if (nodeStats.getHttp() != null) {
                nodeStats.getHttp().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

