/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class ClusterUpdateSettingsResponse
extends ActionResponse {
    Settings transientSettings;
    Settings persistentSettings;

    ClusterUpdateSettingsResponse() {
        this.persistentSettings = ImmutableSettings.EMPTY;
        this.transientSettings = ImmutableSettings.EMPTY;
    }

    ClusterUpdateSettingsResponse(Settings transientSettings, Settings persistentSettings) {
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.transientSettings = ImmutableSettings.readSettingsFromStream(in);
        this.persistentSettings = ImmutableSettings.readSettingsFromStream(in);
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        ImmutableSettings.writeSettingsToStream(this.transientSettings, out);
        ImmutableSettings.writeSettingsToStream(this.persistentSettings, out);
    }
}

