/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesGetAliasesResponse
extends ActionResponse {
    private Map<String, List<AliasMetaData>> aliases = new HashMap<String, List<AliasMetaData>>();

    public IndicesGetAliasesResponse(Map<String, List<AliasMetaData>> aliases) {
        this.aliases = aliases;
    }

    IndicesGetAliasesResponse() {
    }

    public Map<String, List<AliasMetaData>> getAliases() {
        return this.aliases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetaData> value = new ArrayList<AliasMetaData>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                value.add(AliasMetaData.Builder.readFrom(in));
            }
            this.aliases.put(key, value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.aliases.size());
        for (Map.Entry<String, List<AliasMetaData>> entry : this.aliases.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (AliasMetaData aliasMetaData : entry.getValue()) {
                AliasMetaData.Builder.writeTo(aliasMetaData, out);
            }
        }
    }
}

