/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;

public class IndicesStatsResponse
extends BroadcastOperationResponse
implements ToXContent {
    private ShardStats[] shards;
    private Map<String, IndexStats> indicesStats;
    private CommonStats total = null;
    private CommonStats primary = null;

    IndicesStatsResponse() {
    }

    IndicesStatsResponse(ShardStats[] shards, ClusterState clusterState, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    public IndexStats getIndex(String index) {
        return this.getIndices().get(index);
    }

    public Map<String, IndexStats> getIndices() {
        if (this.indicesStats != null) {
            return this.indicesStats;
        }
        HashMap<String, IndexStats> indicesStats = Maps.newHashMap();
        HashSet<String> indices = Sets.newHashSet();
        for (ShardStats shard : this.shards) {
            indices.add(shard.getIndex());
        }
        for (String index : indices) {
            ArrayList<ShardStats> shards = Lists.newArrayList();
            for (ShardStats shard : this.shards) {
                if (!shard.getShardRouting().index().equals(index)) continue;
                shards.add(shard);
            }
            indicesStats.put(index, new IndexStats(index, shards.toArray(new ShardStats[shards.size()])));
        }
        this.indicesStats = indicesStats;
        return indicesStats;
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardStats[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ShardStats.readShardStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardStats shard : this.shards) {
            shard.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_all");
        builder.startObject("primaries");
        this.getPrimaries().toXContent(builder, params);
        builder.endObject();
        builder.startObject("total");
        this.getTotal().toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        builder.startObject(Fields.INDICES);
        for (IndexStats indexStats : this.getIndices().values()) {
            builder.startObject(indexStats.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
            builder.startObject("primaries");
            indexStats.getPrimaries().toXContent(builder, params);
            builder.endObject();
            builder.startObject("total");
            indexStats.getTotal().toXContent(builder, params);
            builder.endObject();
            if ("shards".equalsIgnoreCase(params.param("level", null))) {
                builder.startObject(Fields.SHARDS);
                for (IndexShardStats indexShardStats : indexStats) {
                    builder.startArray(Integer.toString(indexShardStats.getShardId().id()));
                    for (ShardStats shardStats : indexShardStats) {
                        builder.startObject();
                        builder.startObject(Fields.ROUTING).field(Fields.STATE, (Object)shardStats.getShardRouting().state()).field(Fields.PRIMARY, shardStats.getShardRouting().primary()).field(Fields.NODE, shardStats.getShardRouting().currentNodeId()).field(Fields.RELOCATING_NODE, shardStats.getShardRouting().relocatingNodeId()).endObject();
                        shardStats.getStats().toXContent(builder, params);
                        builder.endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");

        Fields() {
        }
    }
}

