/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class GatewayRecoveryStatus {
    final Stage stage;
    final long startTime;
    final long time;
    final long indexSize;
    final long reusedIndexSize;
    final long recoveredIndexSize;
    final long recoveredTranslogOperations;

    public GatewayRecoveryStatus(Stage stage, long startTime, long time, long indexSize, long reusedIndexSize, long recoveredIndexSize, long recoveredTranslogOperations) {
        this.stage = stage;
        this.startTime = startTime;
        this.time = time;
        this.indexSize = indexSize;
        this.reusedIndexSize = reusedIndexSize;
        this.recoveredIndexSize = recoveredIndexSize;
        this.recoveredTranslogOperations = recoveredTranslogOperations;
    }

    public Stage getStage() {
        return this.stage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TimeValue getTime() {
        return TimeValue.timeValueMillis(this.time);
    }

    public ByteSizeValue getIndexSize() {
        return new ByteSizeValue(this.indexSize);
    }

    public ByteSizeValue getReusedIndexSize() {
        return new ByteSizeValue(this.reusedIndexSize);
    }

    public ByteSizeValue getExpectedRecoveredIndexSize() {
        return new ByteSizeValue(this.indexSize - this.reusedIndexSize);
    }

    public ByteSizeValue getRecoveredIndexSize() {
        return new ByteSizeValue(this.recoveredIndexSize);
    }

    public int getIndexRecoveryProgress() {
        if (this.recoveredIndexSize == 0L) {
            if (this.indexSize != 0L && this.indexSize == this.reusedIndexSize) {
                return 100;
            }
            return 0;
        }
        return (int)((double)this.recoveredIndexSize / (double)this.getExpectedRecoveredIndexSize().bytes() * 100.0);
    }

    public long getRecoveredTranslogOperations() {
        return this.recoveredTranslogOperations;
    }

    public static enum Stage {
        INIT(0),
        INDEX(1),
        TRANSLOG(2),
        FINALIZE(3),
        DONE(4);

        private final byte value;

        private Stage(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Stage fromValue(byte value) {
            if (value == 0) {
                return INIT;
            }
            if (value == 1) {
                return INDEX;
            }
            if (value == 2) {
                return TRANSLOG;
            }
            if (value == 3) {
                return FINALIZE;
            }
            if (value == 4) {
                return DONE;
            }
            throw new ElasticSearchIllegalArgumentException("No stage found for [" + value + ']');
        }
    }
}

