/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExplainAction
extends TransportShardSingleOperationAction<ExplainRequest, ExplainResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;

    @Inject
    public TransportExplainAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
    }

    @Override
    protected String transportAction() {
        return "explain";
    }

    @Override
    protected String executor() {
        return "get";
    }

    @Override
    protected void resolveRequest(ClusterState state, ExplainRequest request) {
        String concreteIndex = state.metaData().concreteIndex(request.index());
        request.filteringAlias(state.metaData().filteringAliases(concreteIndex, request.index()));
        request.index(state.metaData().concreteIndex(request.index()));
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, int shardId) throws ElasticSearchException {
        Term uidTerm;
        IndexService indexService = this.indicesService.indexService(request.index());
        IndexShard indexShard = indexService.shardSafe(shardId);
        Engine.GetResult result = indexShard.get(new Engine.Get(false, uidTerm = new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(request.type(), request.id()))));
        if (!result.exists()) {
            return new ExplainResponse(false);
        }
        SearchContext context = new SearchContext(0L, new ShardSearchRequest().types(new String[]{request.type()}).filteringAliases(request.filteringAlias()), null, result.searcher(), indexService, indexShard, this.scriptService);
        SearchContext.setCurrent(context);
        try {
            Explanation explanation;
            context.parsedQuery(this.parseQuery(request, indexService));
            context.preProcess();
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().reader.docBase;
            if (context.rescore() != null) {
                RescoreSearchContext ctx = context.rescore();
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, context, ctx);
            } else {
                explanation = context.searcher().explain(context.query(), topLevelDocId);
            }
            if (request.fields() != null) {
                if (request.fields().length == 1 && "_source".equals(request.fields()[0])) {
                    request.fields(null);
                }
                GetResult getResult = indexShard.getService().get(result, request.id(), request.type(), request.fields());
                ExplainResponse explainResponse = new ExplainResponse(true, explanation, getResult);
                return explainResponse;
            }
            ExplainResponse explainResponse = new ExplainResponse(true, explanation);
            return explainResponse;
        }
        catch (IOException e) {
            throw new ElasticSearchException("Could not explain", e);
        }
        finally {
            context.release();
            SearchContext.removeCurrent();
        }
    }

    private ParsedQuery parseQuery(ExplainRequest request, IndexService indexService) {
        try {
            XContentParser parser = XContentHelper.createParser(request.source());
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if ("query".equals(fieldName)) {
                        return indexService.queryParserService().parse(parser);
                    }
                    if ("query_binary".equals(fieldName)) {
                        byte[] querySource = parser.binaryValue();
                        XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);
                        return indexService.queryParserService().parse(qSourceParser);
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException("Couldn't parse query from source.", e);
        }
        throw new ElasticSearchException("No query specified");
    }

    @Override
    protected ExplainRequest newRequest() {
        return new ExplainRequest();
    }

    @Override
    protected ExplainResponse newResponse() {
        return new ExplainResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ExplainRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ExplainRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState state, ExplainRequest request) throws ElasticSearchException {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing(), request.preference());
    }
}

