/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.custom;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportSingleCustomOperationAction<Request extends SingleCustomOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportAction;
    final String transportShardAction;
    final String executor;

    protected TransportSingleCustomOperationAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportAction = this.transportAction();
        this.transportShardAction = this.transportAction() + "/s";
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleCustomOperationRequest)request, listener).start();
    }

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract ShardsIterator shards(ClusterState var1, Request var2);

    protected abstract Response shardOperation(Request var1, int var2) throws ElasticSearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2);

    protected class ShardSingleOperationRequest
    extends TransportRequest {
        private Request request;
        private int shardId;
        final /* synthetic */ TransportSingleCustomOperationAction this$0;

        ShardSingleOperationRequest(TransportSingleCustomOperationAction transportSingleCustomOperationAction) {
            this.this$0 = transportSingleCustomOperationAction;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public ShardSingleOperationRequest(Request request, int shardId) {
            this.this$0 = (TransportSingleCustomOperationAction)n;
            super((TransportRequest)request);
            this.request = request;
            this.shardId = shardId;
        }

        public Request request() {
            return this.request;
        }

        public int shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = this.this$0.newRequest();
            ((SingleCustomOperationRequest)this.request).readFrom(in);
            this.shardId = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((SingleCustomOperationRequest)this.request).writeTo(out);
            out.writeVInt(this.shardId);
        }
    }

    private class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardSingleOperationRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public ShardSingleOperationRequest newInstance() {
            return new ShardSingleOperationRequest(TransportSingleCustomOperationAction.this);
        }

        @Override
        public String executor() {
            return TransportSingleCustomOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardSingleOperationRequest request, TransportChannel channel) throws Exception {
            Object response = TransportSingleCustomOperationAction.this.shardOperation(request.request(), request.shardId());
            channel.sendResponse((TransportResponse)response);
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportSingleCustomOperationAction.this.newRequest();
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((SingleCustomOperationRequest)request).operationThreaded(true);
            TransportSingleCustomOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportSingleCustomOperationAction.this.logger.warn("Failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardsIt;
        private final Request request;
        private final DiscoveryNodes nodes;
        final /* synthetic */ TransportSingleCustomOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            blockException = var1_1.checkRequestBlock(clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            this.shardsIt = var1_1.shards(clusterState, request);
        }

        public void start() {
            this.performFirst();
        }

        private void onFailure(ShardRouting shardRouting, Throwable e) {
            if (this.this$0.logger.isTraceEnabled() && e != null) {
                this.this$0.logger.trace(shardRouting.shortSummary() + ": Failed to execute [" + this.request + "]", e, new Object[0]);
            }
            this.perform(e);
        }

        private void performFirst() {
            if (this.shardsIt == null) {
                if (((SingleCustomOperationRequest)this.request).operationThreaded()) {
                    ((SingleCustomOperationRequest)this.request).beforeLocalFork();
                    this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.request, -1);
                                AsyncSingleAction.this.listener.onResponse(response);
                            }
                            catch (Throwable e) {
                                AsyncSingleAction.this.onFailure(null, e);
                            }
                        }
                    });
                    return;
                }
                try {
                    Object response = this.this$0.shardOperation(this.request, -1);
                    this.listener.onResponse(response);
                    return;
                }
                catch (Throwable e) {
                    this.onFailure(null, e);
                    return;
                }
            }
            if (((SingleCustomOperationRequest)this.request).preferLocalShard()) {
                ShardRouting shardX;
                boolean foundLocal = false;
                while ((shardX = this.shardsIt.nextOrNull()) != null) {
                    final ShardRouting shard = shardX;
                    if (!shard.currentNodeId().equals(this.nodes.localNodeId())) continue;
                    foundLocal = true;
                    if (((SingleCustomOperationRequest)this.request).operationThreaded()) {
                        ((SingleCustomOperationRequest)this.request).beforeLocalFork();
                        this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.request, shard.id());
                                    AsyncSingleAction.this.listener.onResponse(response);
                                }
                                catch (Throwable e) {
                                    AsyncSingleAction.this.shardsIt.reset();
                                    AsyncSingleAction.this.onFailure(shard, e);
                                }
                            }
                        });
                        return;
                    }
                    try {
                        Object response = this.this$0.shardOperation(this.request, shard.id());
                        this.listener.onResponse(response);
                        return;
                    }
                    catch (Throwable e) {
                        this.shardsIt.reset();
                        this.onFailure(shard, e);
                    }
                }
                if (!foundLocal) {
                    this.shardsIt.reset();
                    this.perform(null);
                }
            } else {
                this.perform(null);
            }
        }

        private void perform(Throwable lastException) {
            ShardRouting shard;
            ShardRouting shardRouting = shard = this.shardsIt == null ? null : this.shardsIt.nextOrNull();
            if (shard == null) {
                Throwable failure = lastException;
                if (failure == null) {
                    failure = new NoShardAvailableActionException(null, "No shard available for [" + this.request + "]");
                } else if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug("failed to execute [" + this.request + "]", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            } else if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                if (!((SingleCustomOperationRequest)this.request).preferLocalShard()) {
                    if (((SingleCustomOperationRequest)this.request).operationThreaded()) {
                        ((SingleCustomOperationRequest)this.request).beforeLocalFork();
                        this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.request, shard.id());
                                    AsyncSingleAction.this.listener.onResponse(response);
                                }
                                catch (Throwable e) {
                                    AsyncSingleAction.this.onFailure(shard, e);
                                }
                            }
                        });
                    } else {
                        try {
                            Object response = this.this$0.shardOperation(this.request, shard.id());
                            this.listener.onResponse(response);
                        }
                        catch (Throwable e) {
                            this.onFailure(shard, e);
                        }
                    }
                } else {
                    this.perform(lastException);
                }
            } else {
                DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, new ShardSingleOperationRequest(this.this$0, this.request, shard.id()), new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncSingleAction.this.this$0.newResponse();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.onFailure(shard, exp);
                    }
                });
            }
        }
    }
}

