/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;

public class DiscoveryNodes
implements Iterable<DiscoveryNode> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.newNodesBuilder().build();
    private final ImmutableMap<String, DiscoveryNode> nodes;
    private final ImmutableMap<String, DiscoveryNode> dataNodes;
    private final ImmutableMap<String, DiscoveryNode> masterNodes;
    private final String masterNodeId;
    private final String localNodeId;

    private DiscoveryNodes(ImmutableMap<String, DiscoveryNode> nodes, ImmutableMap<String, DiscoveryNode> dataNodes, ImmutableMap<String, DiscoveryNode> masterNodes, String masterNodeId, String localNodeId) {
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.masterNodes = masterNodes;
        this.masterNodeId = masterNodeId;
        this.localNodeId = localNodeId;
    }

    @Override
    public UnmodifiableIterator<DiscoveryNode> iterator() {
        return ((ImmutableCollection)this.nodes.values()).iterator();
    }

    public boolean valid() {
        return this.localNodeId != null;
    }

    public boolean localNodeMaster() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.masterNodeId);
    }

    public int size() {
        return this.nodes.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableMap<String, DiscoveryNode> nodes() {
        return this.nodes;
    }

    public ImmutableMap<String, DiscoveryNode> getNodes() {
        return this.nodes();
    }

    public ImmutableMap<String, DiscoveryNode> dataNodes() {
        return this.dataNodes;
    }

    public ImmutableMap<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes();
    }

    public ImmutableMap<String, DiscoveryNode> masterNodes() {
        return this.masterNodes;
    }

    public ImmutableMap<String, DiscoveryNode> getMasterNodes() {
        return this.masterNodes();
    }

    public ImmutableMap<String, DiscoveryNode> masterAndDataNodes() {
        return MapBuilder.newMapBuilder().putAll(this.dataNodes).putAll(this.masterNodes).immutableMap();
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public String masterNodeId() {
        return this.masterNodeId;
    }

    public String getMasterNodeId() {
        return this.masterNodeId();
    }

    public String localNodeId() {
        return this.localNodeId;
    }

    public String getLocalNodeId() {
        return this.localNodeId();
    }

    public DiscoveryNode localNode() {
        return this.nodes.get(this.localNodeId);
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode();
    }

    public DiscoveryNode masterNode() {
        return this.nodes.get(this.masterNodeId);
    }

    public DiscoveryNode getMasterNode() {
        return this.masterNode();
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (DiscoveryNode node : this.nodes.values()) {
            if (!node.address().equals(address)) continue;
            return node;
        }
        return null;
    }

    public boolean isAllNodes(String ... nodesIds) {
        return nodesIds == null || nodesIds.length == 0 || nodesIds.length == 1 && nodesIds[0].equals("_all");
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodesIds(node);
        if (resolvedNodeIds.length > 1) {
            throw new ElasticSearchIllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new ElasticSearchIllegalArgumentException("failed to resolve [" + node + " ], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodesIds(String ... nodesIds) {
        if (this.isAllNodes(nodesIds)) {
            int index = 0;
            nodesIds = new String[this.nodes.size()];
            for (DiscoveryNode node : this) {
                nodesIds[index++] = node.id();
            }
            return nodesIds;
        }
        HashSet<String> resolvedNodesIds = new HashSet<String>(nodesIds.length);
        for (String nodeId : nodesIds) {
            if (nodeId.equals("_local")) {
                String localNodeId = this.localNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add(localNodeId);
                continue;
            }
            if (nodeId.equals("_master")) {
                String masterNodeId = this.masterNodeId();
                if (masterNodeId == null) continue;
                resolvedNodesIds.add(masterNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add(nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!Regex.simpleMatch(nodeId, node.name())) continue;
                resolvedNodesIds.add(node.id());
            }
            for (DiscoveryNode node : this) {
                if (!node.address().match(nodeId)) continue;
                resolvedNodesIds.add(node.id());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if ("data".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll(this.dataNodes.keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.dataNodes.keySet());
                continue;
            }
            if ("master".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll(this.masterNodes.keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.masterNodes.keySet());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.attributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add(node.id());
                }
            }
        }
        return resolvedNodesIds.toArray(new String[resolvedNodesIds.size()]);
    }

    public DiscoveryNodes removeDeadMembers(Set<String> newNodes, String masterNodeId) {
        Builder builder = new Builder().masterNodeId(masterNodeId).localNodeId(this.localNodeId);
        for (DiscoveryNode node : this) {
            if (!newNodes.contains(node.id())) continue;
            builder.put(node);
        }
        return builder.build();
    }

    public DiscoveryNodes newNode(DiscoveryNode node) {
        return new Builder().putAll(this).put(node).build();
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = Lists.newArrayList();
        ArrayList<DiscoveryNode> added = Lists.newArrayList();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node.id())) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node.id())) continue;
            added.add(node);
        }
        DiscoveryNode previousMasterNode = null;
        DiscoveryNode newMasterNode = null;
        if (!(this.masterNodeId == null || other.masterNodeId != null && other.masterNodeId.equals(this.masterNodeId))) {
            previousMasterNode = other.masterNode();
            newMasterNode = this.masterNode();
        }
        return new Delta(previousMasterNode, newMasterNode, this.localNodeId, ImmutableList.copyOf(removed), ImmutableList.copyOf(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (DiscoveryNode node : this) {
            sb.append(node).append(',');
        }
        sb.append("}");
        return sb.toString();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.localNode()) {
                sb.append(", local");
            }
            if (node == this.masterNode()) {
                sb.append(", master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Delta emptyDelta() {
        return new Delta(null, null, this.localNodeId, DiscoveryNode.EMPTY_LIST, DiscoveryNode.EMPTY_LIST);
    }

    public static Builder newNodesBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, DiscoveryNode> nodes = Maps.newHashMap();
        private String masterNodeId;
        private String localNodeId;

        public Builder putAll(DiscoveryNodes nodes) {
            this.masterNodeId = nodes.masterNodeId();
            this.localNodeId = nodes.localNodeId();
            for (DiscoveryNode node : nodes) {
                this.put(node);
            }
            return this;
        }

        public Builder put(DiscoveryNode node) {
            this.nodes.put(node.id(), node);
            return this;
        }

        public Builder putAll(Iterable<DiscoveryNode> nodes) {
            for (DiscoveryNode node : nodes) {
                this.put(node);
            }
            return this;
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder masterNodeId(String masterNodeId) {
            this.masterNodeId = masterNodeId;
            return this;
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        public DiscoveryNodes build() {
            ImmutableMap.Builder<String, DiscoveryNode> dataNodesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder<String, DiscoveryNode> masterNodesBuilder = ImmutableMap.builder();
            for (Map.Entry<String, DiscoveryNode> nodeEntry : this.nodes.entrySet()) {
                if (nodeEntry.getValue().dataNode()) {
                    dataNodesBuilder.put(nodeEntry.getKey(), nodeEntry.getValue());
                }
                if (!nodeEntry.getValue().masterNode()) continue;
                masterNodesBuilder.put(nodeEntry.getKey(), nodeEntry.getValue());
            }
            return new DiscoveryNodes(ImmutableMap.copyOf(this.nodes), dataNodesBuilder.build(), masterNodesBuilder.build(), this.masterNodeId, this.localNodeId);
        }

        public static void writeTo(DiscoveryNodes nodes, StreamOutput out) throws IOException {
            if (nodes.masterNodeId() == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(nodes.masterNodeId);
            }
            out.writeVInt(nodes.size());
            for (DiscoveryNode node : nodes) {
                node.writeTo(out);
            }
        }

        public static DiscoveryNodes readFrom(StreamInput in, @Nullable DiscoveryNode localNode) throws IOException {
            Builder builder = new Builder();
            if (in.readBoolean()) {
                builder.masterNodeId(in.readString());
            }
            if (localNode != null) {
                builder.localNodeId(localNode.id());
            }
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                DiscoveryNode node = DiscoveryNode.readNode(in);
                if (localNode != null && node.id().equals(localNode.id())) {
                    node = localNode;
                }
                builder.put(node);
            }
            return builder.build();
        }
    }

    public static class Delta {
        private final String localNodeId;
        private final DiscoveryNode previousMasterNode;
        private final DiscoveryNode newMasterNode;
        private final ImmutableList<DiscoveryNode> removed;
        private final ImmutableList<DiscoveryNode> added;

        public Delta(String localNodeId, ImmutableList<DiscoveryNode> removed, ImmutableList<DiscoveryNode> added) {
            this(null, null, localNodeId, removed, added);
        }

        public Delta(@Nullable DiscoveryNode previousMasterNode, @Nullable DiscoveryNode newMasterNode, String localNodeId, ImmutableList<DiscoveryNode> removed, ImmutableList<DiscoveryNode> added) {
            this.previousMasterNode = previousMasterNode;
            this.newMasterNode = newMasterNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.masterNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean masterNodeChanged() {
            return this.newMasterNode != null;
        }

        public DiscoveryNode previousMasterNode() {
            return this.previousMasterNode;
        }

        public DiscoveryNode newMasterNode() {
            return this.newMasterNode;
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public ImmutableList<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public ImmutableList<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            StringBuilder sb = new StringBuilder();
            if (!this.removed() && this.masterNodeChanged()) {
                if (this.newMasterNode.id().equals(this.localNodeId)) {
                    sb.append("new_master ").append(this.newMasterNode());
                } else {
                    sb.append("detected_master ").append(this.newMasterNode());
                }
            } else {
                if (this.masterNodeChanged()) {
                    sb.append("master {new ").append(this.newMasterNode());
                    if (this.previousMasterNode() != null) {
                        sb.append(", previous ").append(this.previousMasterNode());
                    }
                    sb.append("}");
                }
                if (this.removed()) {
                    if (this.masterNodeChanged()) {
                        sb.append(", ");
                    }
                    sb.append("removed {");
                    for (DiscoveryNode node : this.removedNodes()) {
                        sb.append(node).append(',');
                    }
                    sb.append("}");
                }
            }
            if (this.added() && (this.addedNodes().size() != 1 || !((DiscoveryNode)this.addedNodes().get(0)).id().equals(this.localNodeId))) {
                if (this.removed() || this.masterNodeChanged()) {
                    sb.append(", ");
                }
                sb.append("added {");
                for (DiscoveryNode node : this.addedNodes()) {
                    if (node.id().equals(this.localNodeId)) continue;
                    sb.append(node).append(',');
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }
}

