/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.RoutingValidationException;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class IndexRoutingTable
implements Iterable<IndexShardRoutingTable> {
    private final String index;
    private final ImmutableMap<Integer, IndexShardRoutingTable> shards;
    private final ImmutableList<ShardRouting> allShards;
    private final ImmutableList<ShardRouting> allActiveShards;
    private final AtomicInteger counter = new AtomicInteger();

    IndexRoutingTable(String index, Map<Integer, IndexShardRoutingTable> shards) {
        this.index = index;
        this.shards = ImmutableMap.copyOf(shards);
        ImmutableList.Builder allShards = ImmutableList.builder();
        ImmutableList.Builder allActiveShards = ImmutableList.builder();
        for (IndexShardRoutingTable indexShardRoutingTable : shards.values()) {
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                allShards.add(shardRouting);
                if (!shardRouting.active()) continue;
                allActiveShards.add(shardRouting);
            }
        }
        this.allShards = allShards.build();
        this.allActiveShards = allActiveShards.build();
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public IndexRoutingTable normalizeVersions() {
        Builder builder = new Builder(this.index);
        for (IndexShardRoutingTable shardTable : this.shards.values()) {
            builder.addIndexShard(shardTable.normalizeVersions());
        }
        return builder.build();
    }

    public void validate(RoutingTableValidation validation, MetaData metaData) {
        if (!metaData.hasIndex(this.index())) {
            validation.addIndexFailure(this.index(), "Exists in routing does not exists in metadata");
            return;
        }
        IndexMetaData indexMetaData = metaData.index(this.index());
        if (indexMetaData.numberOfShards() != this.shards().size()) {
            HashSet<Integer> expected = Sets.newHashSet();
            for (int i = 0; i < indexMetaData.numberOfShards(); ++i) {
                expected.add(i);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : this) {
                expected.remove(indexShardRoutingTable.shardId().id());
            }
            validation.addIndexFailure(this.index(), "Wrong number of shards in routing table, missing: " + expected);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : this) {
            int routingNumberOfReplicas = indexShardRoutingTable.size() - 1;
            if (routingNumberOfReplicas != indexMetaData.numberOfReplicas()) {
                validation.addIndexFailure(this.index(), "Shard [" + indexShardRoutingTable.shardId().id() + "] routing table has wrong number of replicas, expected [" + indexMetaData.numberOfReplicas() + "], got [" + routingNumberOfReplicas + "]");
            }
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                if (shardRouting.index().equals(this.index())) continue;
                validation.addIndexFailure(this.index(), "shard routing has an index [" + shardRouting.index() + "] that is different than the routing table");
            }
        }
    }

    @Override
    public UnmodifiableIterator<IndexShardRoutingTable> iterator() {
        return ((ImmutableCollection)this.shards.values()).iterator();
    }

    public int numberOfNodesShardsAreAllocatedOn(String ... excludedNodes) {
        HashSet<String> nodes = Sets.newHashSet();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            for (ShardRouting shardRouting : shardRoutingTable) {
                if (!shardRouting.assignedToNode()) continue;
                String currentNodeId = shardRouting.currentNodeId();
                boolean excluded = false;
                if (excludedNodes != null) {
                    for (String excludedNode : excludedNodes) {
                        if (!currentNodeId.equals(excludedNode)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                nodes.add(currentNodeId);
            }
        }
        return nodes.size();
    }

    public ImmutableMap<Integer, IndexShardRoutingTable> shards() {
        return this.shards;
    }

    public ImmutableMap<Integer, IndexShardRoutingTable> getShards() {
        return this.shards();
    }

    public IndexShardRoutingTable shard(int shardId) {
        return this.shards.get(shardId);
    }

    public boolean allPrimaryShardsActive() {
        return this.primaryShardsActive() == this.shards().size();
    }

    public int primaryShardsActive() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().active()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean allPrimaryShardsUnassigned() {
        return this.primaryShardsUnassigned() == this.shards.size();
    }

    public int primaryShardsUnassigned() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().unassigned()) continue;
            ++counter;
        }
        return counter;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            shards.addAll(shardRoutingTable.shardsWithState(states));
        }
        return shards;
    }

    public ShardsIterator randomAllShardsIt() {
        return new PlainShardsIterator(this.allShards, this.counter.incrementAndGet());
    }

    public ShardsIterator randomAllActiveShardsIt() {
        return new PlainShardsIterator(this.allActiveShards, this.counter.incrementAndGet());
    }

    public GroupShardsIterator groupByShardsIt() {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>(this.shards.size());
        for (IndexShardRoutingTable indexShard : this) {
            set.add(indexShard.shardsIt());
        }
        return new GroupShardsIterator(set);
    }

    public GroupShardsIterator groupByAllIt() {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (IndexShardRoutingTable indexShard : this) {
            for (ShardRouting shardRouting : indexShard) {
                set.add(shardRouting.shardsIt());
            }
        }
        return new GroupShardsIterator(set);
    }

    public void validate() throws RoutingValidationException {
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("-- index [" + this.index + "]\n");
        for (IndexShardRoutingTable indexShard : this) {
            sb.append("----shard_id [").append(indexShard.shardId().index().name()).append("][").append(indexShard.shardId().id()).append("]\n");
            for (ShardRouting shard : indexShard) {
                sb.append("--------").append(shard.shortSummary()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private final String index;
        private final Map<Integer, IndexShardRoutingTable> shards = new HashMap<Integer, IndexShardRoutingTable>();

        public Builder(String index) {
            this.index = index;
        }

        public static IndexRoutingTable readFrom(StreamInput in) throws IOException {
            String index = in.readString();
            Builder builder = new Builder(index);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                builder.addIndexShard(IndexShardRoutingTable.Builder.readFromThin(in, index));
            }
            return builder.build();
        }

        public static void writeTo(IndexRoutingTable index, StreamOutput out) throws IOException {
            out.writeString(index.index());
            out.writeVInt(index.shards.size());
            for (IndexShardRoutingTable indexShard : index) {
                IndexShardRoutingTable.Builder.writeToThin(indexShard, out);
            }
        }

        public Builder initializeAsNew(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, true);
        }

        public Builder initializeAsRecovery(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, false);
        }

        private Builder initializeEmpty(IndexMetaData indexMetaData, boolean asNew) {
            if (!this.shards.isEmpty()) {
                throw new ElasticSearchIllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardId = 0; shardId < indexMetaData.numberOfShards(); ++shardId) {
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(new ShardId(indexMetaData.index(), shardId), !asNew);
                for (int i = 0; i <= indexMetaData.numberOfReplicas(); ++i) {
                    indexShardRoutingBuilder.addShard(new ImmutableShardRouting(this.index, shardId, null, i == 0, ShardRoutingState.UNASSIGNED, 0L));
                }
                this.shards.put(shardId, indexShardRoutingBuilder.build());
            }
            return this;
        }

        public Builder addReplica() {
            for (int shardId : this.shards.keySet()) {
                ImmutableShardRouting shard = new ImmutableShardRouting(this.index, shardId, null, false, ShardRoutingState.UNASSIGNED, 0L);
                this.shards.put(shardId, new IndexShardRoutingTable.Builder(this.shards.get(shard.id())).addShard(shard).build());
            }
            return this;
        }

        public Builder removeReplica() {
            for (int shardId : this.shards.keySet()) {
                IndexShardRoutingTable indexShard = this.shards.get(shardId);
                if (indexShard.replicaShards().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(indexShard.shardId(), indexShard.primaryAllocatedPostApi());
                for (ShardRouting shardRouting : indexShard) {
                    builder.addShard(new ImmutableShardRouting(shardRouting));
                }
                boolean removed = false;
                for (ShardRouting shardRouting : indexShard) {
                    if (shardRouting.primary() || shardRouting.assignedToNode()) continue;
                    builder.removeShard(shardRouting);
                    removed = true;
                    break;
                }
                if (!removed) {
                    for (ShardRouting shardRouting : indexShard) {
                        if (shardRouting.primary()) continue;
                        builder.removeShard(shardRouting);
                        removed = true;
                        break;
                    }
                }
                this.shards.put(shardId, builder.build());
            }
            return this;
        }

        public Builder addIndexShard(IndexShardRoutingTable indexShard) {
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public Builder clearPostAllocationFlag(ShardId shardId) {
            assert (this.index.equals(shardId.index().name()));
            IndexShardRoutingTable indexShard = this.shards.get(shardId.id());
            this.shards.put(indexShard.shardId().id(), new IndexShardRoutingTable(indexShard.shardId(), indexShard.shards(), false));
            return this;
        }

        public Builder addShard(IndexShardRoutingTable refData, ShardRouting shard) {
            IndexShardRoutingTable indexShard = this.shards.get(shard.id());
            indexShard = indexShard == null ? new IndexShardRoutingTable.Builder(refData.shardId(), refData.primaryAllocatedPostApi()).addShard(new ImmutableShardRouting(shard)).build() : new IndexShardRoutingTable.Builder(indexShard).addShard(new ImmutableShardRouting(shard)).build();
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public IndexRoutingTable build() throws RoutingValidationException {
            IndexRoutingTable indexRoutingTable = new IndexRoutingTable(this.index, ImmutableMap.copyOf(this.shards));
            indexRoutingTable.validate();
            return indexRoutingTable;
        }
    }
}

