/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Queue;
import org.elasticsearch.common.Recycler;
import org.elasticsearch.common.trove.ExtTDoubleObjectHashMap;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.trove.map.hash.TByteIntHashMap;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.trove.map.hash.TFloatIntHashMap;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.trove.map.hash.TIntObjectHashMap;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.common.trove.map.hash.TShortIntHashMap;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class DefaultCacheRecycler
implements Recycler {
    private final SoftWrapper<Queue<ExtTHashMap>> hashMap = new SoftWrapper();
    private final SoftWrapper<Queue<THashSet>> hashSet = new SoftWrapper();
    private final SoftWrapper<Queue<ExtTDoubleObjectHashMap>> doubleObjectHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<ExtTLongObjectHashMap>> longObjectHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TLongLongHashMap>> longLongHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TIntIntHashMap>> intIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TFloatIntHashMap>> floatIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TDoubleIntHashMap>> doubleIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TByteIntHashMap>> byteIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TShortIntHashMap>> shortIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TLongIntHashMap>> longIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TObjectIntHashMap>> objectIntHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TIntObjectHashMap>> intObjectHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<TObjectFloatHashMap>> objectFloatHashMap = new SoftWrapper();
    private final SoftWrapper<Queue<Object[]>> objectArray = new SoftWrapper();
    private final SoftWrapper<Queue<int[]>> intArray = new SoftWrapper();

    @Override
    public void clear() {
        this.hashMap.clear();
        this.hashSet.clear();
        this.doubleObjectHashMap.clear();
        this.longObjectHashMap.clear();
        this.longLongHashMap.clear();
        this.intIntHashMap.clear();
        this.floatIntHashMap.clear();
        this.doubleIntHashMap.clear();
        this.shortIntHashMap.clear();
        this.longIntHashMap.clear();
        this.objectIntHashMap.clear();
        this.intObjectHashMap.clear();
        this.objectFloatHashMap.clear();
        this.objectArray.clear();
        this.intArray.clear();
    }

    @Override
    public <K, V> ExtTHashMap<K, V> popHashMap() {
        ExtTHashMap map = (ExtTHashMap)DefaultCacheRecycler.pop(this.hashMap);
        if (map == null) {
            return new ExtTHashMap();
        }
        return map;
    }

    @Override
    public void pushHashMap(ExtTHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.hashMap, map);
    }

    @Override
    public <T> THashSet<T> popHashSet() {
        THashSet set = (THashSet)DefaultCacheRecycler.pop(this.hashSet);
        if (set == null) {
            return new THashSet();
        }
        return set;
    }

    @Override
    public void pushHashSet(THashSet map) {
        map.clear();
        DefaultCacheRecycler.push(this.hashSet, map);
    }

    @Override
    public <T> ExtTDoubleObjectHashMap<T> popDoubleObjectMap() {
        ExtTDoubleObjectHashMap map = (ExtTDoubleObjectHashMap)DefaultCacheRecycler.pop(this.doubleObjectHashMap);
        if (map == null) {
            return new ExtTDoubleObjectHashMap();
        }
        return map;
    }

    @Override
    public void pushDoubleObjectMap(ExtTDoubleObjectHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.doubleObjectHashMap, map);
    }

    @Override
    public <T> ExtTLongObjectHashMap<T> popLongObjectMap() {
        ExtTLongObjectHashMap map = (ExtTLongObjectHashMap)DefaultCacheRecycler.pop(this.longObjectHashMap);
        if (map == null) {
            return new ExtTLongObjectHashMap();
        }
        return map;
    }

    @Override
    public void pushLongObjectMap(ExtTLongObjectHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.longObjectHashMap, map);
    }

    @Override
    public TLongLongHashMap popLongLongMap() {
        TLongLongHashMap map = (TLongLongHashMap)DefaultCacheRecycler.pop(this.longLongHashMap);
        if (map == null) {
            return new TLongLongHashMap();
        }
        return map;
    }

    @Override
    public void pushLongLongMap(TLongLongHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.longLongHashMap, map);
    }

    @Override
    public TIntIntHashMap popIntIntMap() {
        TIntIntHashMap map = (TIntIntHashMap)DefaultCacheRecycler.pop(this.intIntHashMap);
        if (map == null) {
            return new TIntIntHashMap();
        }
        return map;
    }

    @Override
    public void pushIntIntMap(TIntIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.intIntHashMap, map);
    }

    @Override
    public TFloatIntHashMap popFloatIntMap() {
        TFloatIntHashMap map = (TFloatIntHashMap)DefaultCacheRecycler.pop(this.floatIntHashMap);
        if (map == null) {
            return new TFloatIntHashMap();
        }
        return map;
    }

    @Override
    public void pushFloatIntMap(TFloatIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.floatIntHashMap, map);
    }

    @Override
    public TDoubleIntHashMap popDoubleIntMap() {
        TDoubleIntHashMap map = (TDoubleIntHashMap)DefaultCacheRecycler.pop(this.doubleIntHashMap);
        if (map == null) {
            return new TDoubleIntHashMap();
        }
        return map;
    }

    @Override
    public void pushDoubleIntMap(TDoubleIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.doubleIntHashMap, map);
    }

    @Override
    public TByteIntHashMap popByteIntMap() {
        TByteIntHashMap map = (TByteIntHashMap)DefaultCacheRecycler.pop(this.byteIntHashMap);
        if (map == null) {
            return new TByteIntHashMap();
        }
        return map;
    }

    @Override
    public void pushByteIntMap(TByteIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.byteIntHashMap, map);
    }

    @Override
    public TShortIntHashMap popShortIntMap() {
        TShortIntHashMap map = (TShortIntHashMap)DefaultCacheRecycler.pop(this.shortIntHashMap);
        if (map == null) {
            return new TShortIntHashMap();
        }
        return map;
    }

    @Override
    public void pushShortIntMap(TShortIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.shortIntHashMap, map);
    }

    @Override
    public TLongIntHashMap popLongIntMap() {
        Queue<TLongIntHashMap> ref = this.longIntHashMap.get();
        if (ref == null) {
            return new TLongIntHashMap();
        }
        TLongIntHashMap map = (TLongIntHashMap)DefaultCacheRecycler.pop(this.longIntHashMap);
        if (map == null) {
            return new TLongIntHashMap();
        }
        return map;
    }

    @Override
    public void pushLongIntMap(TLongIntHashMap map) {
        map.clear();
        DefaultCacheRecycler.push(this.longIntHashMap, map);
    }

    @Override
    public <T> TObjectIntHashMap<T> popObjectIntMap() {
        TObjectIntHashMap map = (TObjectIntHashMap)DefaultCacheRecycler.pop(this.objectIntHashMap);
        if (map == null) {
            return new TObjectIntHashMap();
        }
        return map;
    }

    @Override
    public <T> void pushObjectIntMap(TObjectIntHashMap<T> map) {
        map.clear();
        DefaultCacheRecycler.push(this.objectIntHashMap, map);
    }

    @Override
    public <T> TIntObjectHashMap<T> popIntObjectMap() {
        TIntObjectHashMap map = (TIntObjectHashMap)DefaultCacheRecycler.pop(this.intObjectHashMap);
        if (map == null) {
            return new TIntObjectHashMap();
        }
        return map;
    }

    @Override
    public <T> void pushIntObjectMap(TIntObjectHashMap<T> map) {
        map.clear();
        DefaultCacheRecycler.push(this.intObjectHashMap, map);
    }

    @Override
    public <T> TObjectFloatHashMap<T> popObjectFloatMap() {
        TObjectFloatHashMap map = (TObjectFloatHashMap)DefaultCacheRecycler.pop(this.objectFloatHashMap);
        if (map == null) {
            return new TObjectFloatHashMap();
        }
        return map;
    }

    @Override
    public <T> void pushObjectFloatMap(TObjectFloatHashMap<T> map) {
        map.clear();
        DefaultCacheRecycler.push(this.objectFloatHashMap, map);
    }

    @Override
    public Object[] popObjectArray(int size) {
        size = size < 100 ? 100 : size;
        Queue<Object[]> ref = this.objectArray.get();
        if (ref == null) {
            return new Object[size];
        }
        Object[] objects = ref.poll();
        if (objects == null) {
            return new Object[size];
        }
        if (objects.length < size) {
            return new Object[size];
        }
        return objects;
    }

    @Override
    public void pushObjectArray(Object[] objects) {
        Arrays.fill(objects, null);
        DefaultCacheRecycler.push(this.objectArray, objects);
    }

    @Override
    public int[] popIntArray(int size) {
        return this.popIntArray(size, 0);
    }

    @Override
    public int[] popIntArray(int size, int sentinal) {
        size = size < 100 ? 100 : size;
        Queue<int[]> ref = this.intArray.get();
        if (ref == null) {
            int[] ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        int[] ints = ref.poll();
        if (ints == null) {
            ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        if (ints.length < size) {
            ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        return ints;
    }

    @Override
    public void pushIntArray(int[] ints) {
        this.pushIntArray(ints, 0);
    }

    @Override
    public void pushIntArray(int[] ints, int sentinal) {
        Arrays.fill(ints, sentinal);
        DefaultCacheRecycler.push(this.intArray, ints);
    }

    private static final <T> void push(SoftWrapper<Queue<T>> wrapper, T obj) {
        Queue<T> ref = wrapper.get();
        if (ref == null) {
            ref = ConcurrentCollections.newQueue();
            wrapper.set(ref);
        }
        ref.add(obj);
    }

    private static final <T> T pop(SoftWrapper<Queue<T>> wrapper) {
        Queue<T> queue = wrapper.get();
        return queue == null ? null : (T)queue.poll();
    }

    static class SoftWrapper<T> {
        private SoftReference<T> ref;

        public void set(T ref) {
            this.ref = new SoftReference<T>(ref);
        }

        public T get() {
            return this.ref == null ? null : (T)this.ref.get();
        }

        public void clear() {
            this.ref = null;
        }
    }
}

