/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ForwardingMap;
import org.elasticsearch.common.trove.ExtTHashMap;

public final class XMaps {
    public static final int DEFAULT_CAPACITY = 10;

    public static <K, V> Map<K, V> newMap(int capacity) {
        return new ExtTHashMap(capacity, 0.5f);
    }

    public static <K, V> Map<K, V> newMap() {
        return XMaps.newMap(10);
    }

    public static <K, V> Map<K, V> newNoNullKeysMap() {
        Map<K, V> delegate = XMaps.newMap();
        return XMaps.ensureNoNullKeys(delegate);
    }

    public static <K, V> Map<K, V> newNoNullKeysMap(int capacity) {
        Map<K, V> delegate = XMaps.newMap(capacity);
        return XMaps.ensureNoNullKeys(delegate);
    }

    public static <K, V> Map<K, V> ensureNoNullKeys(final Map<K, V> delegate) {
        return new ForwardingMap<K, V>(){

            @Override
            public V put(K key, V value) {
                if (key == null) {
                    throw new ElasticSearchIllegalArgumentException("Map key must not be null");
                }
                return super.put(key, value);
            }

            @Override
            protected Map<K, V> delegate() {
                return delegate;
            }
        };
    }
}

