/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.Base64Variants;
import org.elasticsearch.common.jackson.core.FormatSchema;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.JsonProcessingException;
import org.elasticsearch.common.jackson.core.JsonStreamContext;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.TreeNode;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.Versioned;
import org.elasticsearch.common.jackson.core.io.CharacterEscapes;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    @Override
    public abstract Version version();

    public Object getOutputTarget() {
        return null;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public final JsonGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public abstract void writeFieldName(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeString(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public void writeBinary(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n, n2);
    }

    public void writeBinary(byte[] byArray) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n) throws IOException, JsonGenerationException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws IOException, JsonGenerationException;

    public void writeNumber(short s) throws IOException, JsonGenerationException {
        this.writeNumber((int)s);
    }

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public abstract void writeTree(TreeNode var1) throws IOException, JsonProcessingException;

    public void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeBooleanField(String string, boolean bl) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeBoolean(bl);
    }

    public final void writeNullField(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNull();
    }

    public final void writeNumberField(String string, int n) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(n);
    }

    public final void writeNumberField(String string, long l) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(l);
    }

    public final void writeNumberField(String string, double d) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(d);
    }

    public final void writeNumberField(String string, float f) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(f);
    }

    public final void writeNumberField(String string, BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string, byte[] byArray) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public final void writeObjectField(String string, Object object) throws IOException, JsonProcessingException {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public abstract void copyCurrentEvent(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract void copyCurrentStructure(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract JsonStreamContext getOutputContext();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean isClosed();

    @Override
    public abstract void close() throws IOException;

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        WRITE_NUMBERS_AS_STRINGS(false),
        FLUSH_PASSED_TO_STREAM(true),
        ESCAPE_NON_ASCII(false);

        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

