/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.all.AllEntries;

public final class AllTokenStream
extends TokenFilter {
    private final BytesRef payloadSpare = new BytesRef(new byte[4]);
    private final AllEntries allEntries;
    private final PayloadAttribute payloadAttribute;

    public static TokenStream allTokenStream(String allFieldName, AllEntries allEntries, Analyzer analyzer) throws IOException {
        return new AllTokenStream(analyzer.tokenStream(allFieldName, (Reader)allEntries), allEntries);
    }

    AllTokenStream(TokenStream input, AllEntries allEntries) {
        super(input);
        this.allEntries = allEntries;
        this.payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public AllEntries allEntries() {
        return this.allEntries;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.allEntries.current() != null) {
            float boost = this.allEntries.current().boost();
            if (boost != 1.0f) {
                PayloadHelper.encodeFloat((float)boost, (byte[])this.payloadSpare.bytes, (int)this.payloadSpare.offset);
                this.payloadAttribute.setPayload(this.payloadSpare);
            } else {
                this.payloadAttribute.setPayload(null);
            }
        }
        return true;
    }

    public String toString() {
        return this.allEntries.toString();
    }
}

