/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.MatchAllDocsFilter;
import org.elasticsearch.common.lucene.search.MatchNoDocsFilter;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;

public class Queries {
    public static final Query MATCH_ALL_QUERY;
    public static final Query NO_MATCH_QUERY;
    public static final Filter MATCH_ALL_FILTER;
    public static final Filter MATCH_NO_FILTER;
    private static final Field disjuncts;
    private static Pattern spaceAroundLessThanPattern;
    private static Pattern spacePattern;
    private static Pattern lessThanPattern;

    public static List<Query> disMaxClauses(DisjunctionMaxQuery query) {
        try {
            return (List)disjuncts.get(query);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Query optimizeQuery(Query q) {
        BooleanQuery booleanQuery;
        BooleanClause[] clauses;
        if (q instanceof BooleanQuery && (clauses = (booleanQuery = (BooleanQuery)q).getClauses()).length == 1) {
            BooleanClause clause = clauses[0];
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                Query query = clause.getQuery();
                query.setBoost(booleanQuery.getBoost() * query.getBoost());
                return Queries.optimizeQuery(query);
            }
            if (clause.getOccur() == BooleanClause.Occur.SHOULD && booleanQuery.getMinimumNumberShouldMatch() > 0) {
                Query query = clause.getQuery();
                query.setBoost(booleanQuery.getBoost() * query.getBoost());
                return Queries.optimizeQuery(query);
            }
        }
        return q;
    }

    public static boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List clauses = ((BooleanQuery)q).clauses();
        if (clauses.isEmpty()) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query fixNegativeQueryIfNeeded(Query q) {
        if (Queries.isNegativeQuery(q)) {
            BooleanQuery newBq = (BooleanQuery)q.clone();
            newBq.add(MATCH_ALL_QUERY, BooleanClause.Occur.MUST);
            return newBq;
        }
        return q;
    }

    public static boolean isConstantMatchAllQuery(Query query) {
        XConstantScoreQuery scoreQuery;
        if (query == MATCH_ALL_QUERY) {
            return true;
        }
        return query instanceof XConstantScoreQuery && (scoreQuery = (XConstantScoreQuery)query).getFilter() instanceof MatchAllDocsFilter;
    }

    public static void applyMinimumShouldMatch(BooleanQuery query, @Nullable String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            return;
        }
        int optionalClauses = 0;
        for (BooleanClause c : query.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = Queries.calculateMinShouldMatch(optionalClauses, minimumShouldMatch);
        if (0 < msm) {
            query.setMinimumNumberShouldMatch(msm);
        }
    }

    public static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < (spec = spec.trim()).indexOf("<")) {
            spec = spaceAroundLessThanPattern.matcher(spec).replaceAll("<");
            for (String s : spacePattern.split(spec)) {
                String[] parts = lessThanPattern.split(s, 0);
                int upperBound = Integer.parseInt(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = Queries.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf(37)) {
            int percent = Integer.parseInt(spec = spec.substring(0, spec.length() - 1));
            float calc = (float)(result * percent) * 0.01f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = Integer.parseInt(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }

    static {
        Field disjunctsX;
        MATCH_ALL_QUERY = new XConstantScoreQuery(new MatchAllDocsFilter());
        NO_MATCH_QUERY = MatchNoDocsQuery.INSTANCE;
        MATCH_ALL_FILTER = new MatchAllDocsFilter();
        MATCH_NO_FILTER = new MatchNoDocsFilter();
        try {
            disjunctsX = DisjunctionMaxQuery.class.getDeclaredField("disjuncts");
            disjunctsX.setAccessible(true);
        }
        catch (Exception e) {
            disjunctsX = null;
        }
        disjuncts = disjunctsX;
        spaceAroundLessThanPattern = Pattern.compile("(\\s+<\\s*)|(\\s*<\\s+)");
        spacePattern = Pattern.compile(" ");
        lessThanPattern = Pattern.compile("<");
    }
}

