/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.search.controller.ShardFieldDoc;

public class ShardFieldDocSortedHitQueue
extends PriorityQueue<ShardFieldDoc> {
    volatile SortField[] fields = null;
    FieldComparator[] comparators = null;

    public ShardFieldDocSortedHitQueue(SortField[] fields, int size) {
        super(size);
        this.setFields(fields);
    }

    public void setFields(SortField[] fields) {
        this.fields = fields;
        try {
            this.comparators = new FieldComparator[fields.length];
            for (int fieldIDX = 0; fieldIDX < fields.length; ++fieldIDX) {
                this.comparators[fieldIDX] = fields[fieldIDX].getComparator(1, fieldIDX);
            }
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalStateException("failed to get comparator", e);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    protected final boolean lessThan(ShardFieldDoc docA, ShardFieldDoc docB) {
        int n = this.fields.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            SortField.Type type = this.fields[i].getType();
            if (type == SortField.Type.STRING) {
                BytesRef s1 = (BytesRef)docA.fields[i];
                BytesRef s2 = (BytesRef)docB.fields[i];
                c = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : s1.compareTo(s2));
            } else {
                c = this.comparators[i].compareValues(docA.fields[i], docB.fields[i]);
            }
            if (!this.fields[i].getReverse()) continue;
            c = -c;
        }
        if (c == 0 && (c = docA.shardTarget().compareTo(docB.shardTarget())) == 0) {
            return docA.doc > docB.doc;
        }
        return c > 0;
    }
}

