/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedCallable;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;

public class PrioritizedEsThreadPoolExecutor
extends EsThreadPoolExecutor {
    private AtomicLong tieBreaker = new AtomicLong(Long.MIN_VALUE);

    public PrioritizedEsThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory);
    }

    public PrioritizedEsThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory, handler);
    }

    public PrioritizedEsThreadPoolExecutor(int corePoolSize, int initialWorkQueuSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(initialWorkQueuSize), threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof PrioritizedRunnable) {
            super.execute(new TieBreakingPrioritizedRunnable((PrioritizedRunnable)command, this.tieBreaker.incrementAndGet()));
            return;
        }
        if (!(command instanceof Comparable)) {
            command = new TieBreakingPrioritizedRunnable(command, Priority.NORMAL, this.tieBreaker.incrementAndGet());
        }
        super.execute(command);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (!(runnable instanceof PrioritizedRunnable)) {
            runnable = PrioritizedRunnable.wrap(runnable, Priority.NORMAL);
        }
        return new PrioritizedFutureTask<T>((PrioritizedRunnable)runnable, value, this.tieBreaker.incrementAndGet());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (!(callable instanceof PrioritizedCallable)) {
            callable = PrioritizedCallable.wrap(callable, Priority.NORMAL);
        }
        return new PrioritizedFutureTask((PrioritizedCallable)callable, this.tieBreaker.incrementAndGet());
    }

    static class PrioritizedFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PrioritizedFutureTask> {
        private final Priority priority;
        private final long tieBreaker;

        public PrioritizedFutureTask(PrioritizedRunnable runnable, T value, long tieBreaker) {
            super(runnable, value);
            this.priority = runnable.priority();
            this.tieBreaker = tieBreaker;
        }

        public PrioritizedFutureTask(PrioritizedCallable<T> callable, long tieBreaker) {
            super(callable);
            this.priority = callable.priority();
            this.tieBreaker = tieBreaker;
        }

        @Override
        public int compareTo(PrioritizedFutureTask pft) {
            int res = this.priority.compareTo(pft.priority);
            if (res != 0) {
                return res;
            }
            return this.tieBreaker < pft.tieBreaker ? -1 : 1;
        }
    }

    static class TieBreakingPrioritizedRunnable
    extends PrioritizedRunnable {
        private final Runnable runnable;
        private final long tieBreaker;

        TieBreakingPrioritizedRunnable(PrioritizedRunnable runnable, long tieBreaker) {
            this(runnable, runnable.priority(), tieBreaker);
        }

        TieBreakingPrioritizedRunnable(Runnable runnable, Priority priority, long tieBreaker) {
            super(priority);
            this.runnable = runnable;
            this.tieBreaker = tieBreaker;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public int compareTo(PrioritizedRunnable pr) {
            int res = super.compareTo(pr);
            if (res != 0 || !(pr instanceof TieBreakingPrioritizedRunnable)) {
                return res;
            }
            return this.tieBreaker < ((TieBreakingPrioritizedRunnable)pr).tieBreaker ? -1 : 1;
        }
    }
}

