/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapConverter;

public final class XContentBuilder
implements BytesStream {
    public static final DateTimeFormatter defaultDatePrinter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    protected static FieldCaseConversion globalFieldCaseConversion = FieldCaseConversion.NONE;
    private XContentGenerator generator;
    private final OutputStream bos;
    private final Object payload;
    private FieldCaseConversion fieldCaseConversion = globalFieldCaseConversion;
    private StringBuilder cachedStringBuilder;

    public static void globalFieldCaseConversion(FieldCaseConversion globalFieldCaseConversion) {
        XContentBuilder.globalFieldCaseConversion = globalFieldCaseConversion;
    }

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new FastByteArrayOutputStream());
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, null);
    }

    public XContentBuilder(XContent xContent, OutputStream bos, @Nullable Object payload) throws IOException {
        this.bos = bos;
        this.generator = xContent.createGenerator(bos);
        this.payload = payload;
    }

    public XContentBuilder fieldCaseConversion(FieldCaseConversion fieldCaseConversion) {
        this.fieldCaseConversion = fieldCaseConversion;
        return this;
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public XContentBuilder field(String name, ToXContent xContent) throws IOException {
        this.field(name);
        xContent.toXContent(this, ToXContent.EMPTY_PARAMS);
        return this;
    }

    public XContentBuilder field(String name, ToXContent xContent, ToXContent.Params params) throws IOException {
        this.field(name);
        xContent.toXContent(this, params);
        return this;
    }

    public XContentBuilder startObject(String name) throws IOException {
        this.field(name);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(String name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name) throws IOException {
        this.field(name);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder array(String name, String ... values) throws IOException {
        this.startArray(name);
        for (String value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name, String ... values) throws IOException {
        this.startArray(name);
        for (String value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(String name, Object ... values) throws IOException {
        this.startArray(name);
        for (Object value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name, Object ... values) throws IOException {
        this.startArray(name);
        for (Object value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder startArray(String name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(String name) throws IOException {
        this.field(name);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(XContentBuilderString name) throws IOException {
        this.field(name);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name) throws IOException {
        if (this.fieldCaseConversion == FieldCaseConversion.UNDERSCORE) {
            this.generator.writeFieldName(name.underscore());
        } else if (this.fieldCaseConversion == FieldCaseConversion.CAMELCASE) {
            this.generator.writeFieldName(name.camelCase());
        } else {
            this.generator.writeFieldName(name.underscore());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, FieldCaseConversion conversion) throws IOException {
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            this.generator.writeFieldName(name.underscore());
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            this.generator.writeFieldName(name.camelCase());
        } else {
            this.generator.writeFieldName(name.underscore());
        }
        return this;
    }

    public XContentBuilder field(String name) throws IOException {
        if (this.fieldCaseConversion == FieldCaseConversion.UNDERSCORE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toUnderscoreCase(name, this.cachedStringBuilder);
        } else if (this.fieldCaseConversion == FieldCaseConversion.CAMELCASE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toCamelCase(name, this.cachedStringBuilder);
        }
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder field(String name, FieldCaseConversion conversion) throws IOException {
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toUnderscoreCase(name, this.cachedStringBuilder);
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toCamelCase(name, this.cachedStringBuilder);
        }
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder field(String name, char[] value, int offset, int length) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value, offset, length);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, char[] value, int offset, int length) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value, offset, length);
        }
        return this;
    }

    public XContentBuilder field(String name, String value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(String name, String value, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String value, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(String name, Integer value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Integer value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, int value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, int value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Long value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Long value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, long value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, long value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Float value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value.floatValue());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Float value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value.floatValue());
        }
        return this;
    }

    public XContentBuilder field(String name, float value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, float value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Double value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Double value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, double value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, double value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, BigDecimal value) throws IOException {
        return this.field(name, value, value.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(XContentBuilderString name, BigDecimal value) throws IOException {
        return this.field(name, value, value.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(String name, BigDecimal value, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name);
        if (toDouble) {
            try {
                this.generator.writeNumber(value.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value.toEngineeringString());
            }
        } else {
            this.generator.writeString(value.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BigDecimal value, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name);
        if (toDouble) {
            try {
                this.generator.writeNumber(value.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value.toEngineeringString());
            }
        } else {
            this.generator.writeString(value.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(String name, BytesReference value) throws IOException {
        this.field(name);
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BytesReference value) throws IOException {
        this.field(name);
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BytesRef value) throws IOException {
        this.field(name);
        this.generator.writeUTF8String(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder field(String name, Text value) throws IOException {
        this.field(name);
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Text value) throws IOException {
        this.field(name);
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(String name, byte[] value, int offset, int length) throws IOException {
        this.field(name);
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder field(String name, Map<String, Object> value) throws IOException {
        this.field(name);
        this.value(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Map<String, Object> value) throws IOException {
        this.field(name);
        this.value(value);
        return this;
    }

    public XContentBuilder field(String name, Iterable value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Iterable value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, String ... value) throws IOException {
        this.startArray(name);
        for (String o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String ... value) throws IOException {
        this.startArray(name);
        for (String o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, Object ... value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Object ... value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, int ... value) throws IOException {
        this.startArray(name);
        int[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, int ... value) throws IOException {
        this.startArray(name);
        int[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, long ... value) throws IOException {
        this.startArray(name);
        long[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, long ... value) throws IOException {
        this.startArray(name);
        long[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, float ... value) throws IOException {
        this.startArray(name);
        float[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, float ... value) throws IOException {
        this.startArray(name);
        float[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, double ... value) throws IOException {
        this.startArray(name);
        double[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, double ... value) throws IOException {
        this.startArray(name);
        double[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, Object value) throws IOException {
        if (value == null) {
            this.nullField(name);
            return this;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.field(name, (String)value);
        } else if (type == Float.class) {
            this.field(name, ((Float)value).floatValue());
        } else if (type == Double.class) {
            this.field(name, (double)((Double)value));
        } else if (type == Integer.class) {
            this.field(name, (int)((Integer)value));
        } else if (type == Long.class) {
            this.field(name, (long)((Long)value));
        } else if (type == Short.class) {
            this.field(name, (int)((Short)value).shortValue());
        } else if (type == Byte.class) {
            this.field(name, (int)((Byte)value).byteValue());
        } else if (type == Boolean.class) {
            this.field(name, (boolean)((Boolean)value));
        } else if (value instanceof Date) {
            this.field(name, (Date)value);
        } else if (value instanceof Calendar) {
            this.field(name, this.convertCalendar((Calendar)value));
        } else if (type == byte[].class) {
            this.field(name, (byte[])value);
        } else if (value instanceof ReadableInstant) {
            this.field(name, (ReadableInstant)value);
        } else if (value instanceof Map) {
            this.field(name, (Map<String, Object>)((Map)value));
        } else if (value instanceof Iterable) {
            this.field(name, (Iterable)value);
        } else if (value instanceof Object[]) {
            this.field(name, (Object[])value);
        } else if (value instanceof int[]) {
            this.field(name, (int[])value);
        } else if (value instanceof long[]) {
            this.field(name, (long[])value);
        } else if (value instanceof float[]) {
            this.field(name, (float[])value);
        } else if (value instanceof double[]) {
            this.field(name, (double[])value);
        } else if (value instanceof BytesReference) {
            this.field(name, (BytesReference)value);
        } else if (value instanceof Text) {
            this.field(name, (Text)value);
        } else if (value instanceof ToXContent) {
            this.field(name, (ToXContent)value);
        } else {
            this.field(name, value.toString());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Object value) throws IOException {
        if (value == null) {
            this.nullField(name);
            return this;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.field(name, (String)value);
        } else if (type == Float.class) {
            this.field(name, ((Float)value).floatValue());
        } else if (type == Double.class) {
            this.field(name, (double)((Double)value));
        } else if (type == Integer.class) {
            this.field(name, (int)((Integer)value));
        } else if (type == Long.class) {
            this.field(name, (long)((Long)value));
        } else if (type == Short.class) {
            this.field(name, (int)((Short)value).shortValue());
        } else if (type == Byte.class) {
            this.field(name, (int)((Byte)value).byteValue());
        } else if (type == Boolean.class) {
            this.field(name, (boolean)((Boolean)value));
        } else if (value instanceof Date) {
            this.field(name, (Date)value);
        } else if (type == byte[].class) {
            this.field(name, (byte[])value);
        } else if (value instanceof ReadableInstant) {
            this.field(name, (ReadableInstant)value);
        } else if (value instanceof Map) {
            this.field(name, (Map<String, Object>)((Map)value));
        } else if (value instanceof Iterable) {
            this.field(name, (Iterable)value);
        } else if (value instanceof Object[]) {
            this.field(name, (Object[])value);
        } else if (value instanceof int[]) {
            this.field(name, (int[])value);
        } else if (value instanceof long[]) {
            this.field(name, (long[])value);
        } else if (value instanceof float[]) {
            this.field(name, (float[])value);
        } else if (value instanceof double[]) {
            this.field(name, (double[])value);
        } else if (value instanceof BytesReference) {
            this.field(name, (BytesReference)value);
        } else if (value instanceof Text) {
            this.field(name, (Text)value);
        } else {
            this.field(name, value.toString());
        }
        return this;
    }

    public XContentBuilder value(Object value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.value((String)value);
        } else if (type == Float.class) {
            this.value(((Float)value).floatValue());
        } else if (type == Double.class) {
            this.value((double)((Double)value));
        } else if (type == Integer.class) {
            this.value((int)((Integer)value));
        } else if (type == Long.class) {
            this.value((long)((Long)value));
        } else if (type == Short.class) {
            this.value(((Short)value).shortValue());
        } else if (type == Byte.class) {
            this.value(((Byte)value).byteValue());
        } else if (type == Boolean.class) {
            this.value((Boolean)value);
        } else if (type == byte[].class) {
            this.value((byte[])value);
        } else if (value instanceof Date) {
            this.value((Date)value);
        } else if (value instanceof Calendar) {
            this.value(this.convertCalendar((Calendar)value));
        } else if (value instanceof ReadableInstant) {
            this.value((ReadableInstant)value);
        } else if (value instanceof BytesReference) {
            this.value((BytesReference)value);
        } else if (value instanceof Text) {
            this.value((Text)value);
        } else if (value instanceof Map) {
            this.value((Map)value);
        } else if (value instanceof Iterable) {
            this.value((Iterable)value);
        } else {
            throw new IOException("Type not allowed [" + type + "]");
        }
        return this;
    }

    private Date convertCalendar(Calendar value) {
        return value.getTime();
    }

    public XContentBuilder field(String name, boolean value) throws IOException {
        this.field(name);
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, boolean value) throws IOException {
        this.field(name);
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, byte[] value) throws IOException {
        this.field(name);
        return this.value(value);
    }

    public XContentBuilder field(String name, ReadableInstant date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name, ReadableInstant date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(String name, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(String name, Date date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name, Date date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(String name, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder nullField(String name) throws IOException {
        this.generator.writeNullField(name);
        return this;
    }

    public XContentBuilder nullField(XContentBuilderString name) throws IOException {
        this.field(name);
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder rawField(String fieldName, byte[] content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, byte[] content, int offset, int length) throws IOException {
        this.generator.writeRawField(fieldName, content, offset, length, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, InputStream content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, BytesReference content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder value(Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((boolean)value);
    }

    public XContentBuilder value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder value(ReadableInstant date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(ReadableInstant date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date));
    }

    public XContentBuilder value(Date date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(Date date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date.getTime()));
    }

    public XContentBuilder value(Integer value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((int)value);
    }

    public XContentBuilder value(int value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Long value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((long)value);
    }

    public XContentBuilder value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Float value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(value.floatValue());
    }

    public XContentBuilder value(float value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Double value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((double)value);
    }

    public XContentBuilder value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeString(value);
        return this;
    }

    public XContentBuilder value(byte[] value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value);
        return this;
    }

    public XContentBuilder value(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder value(BytesReference value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder value(Text value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder map(Map<String, Object> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        XContentMapConverter.writeMap(this.generator, map);
        return this;
    }

    public XContentBuilder value(Map<String, Object> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        XContentMapConverter.writeMap(this.generator, map);
        return this;
    }

    public XContentBuilder value(Iterable value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.startArray();
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser) throws IOException {
        this.generator.copyCurrentStructure(parser);
        return this;
    }

    public XContentBuilder flush() throws IOException {
        this.generator.flush();
        return this;
    }

    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public Object payload() {
        return this.payload;
    }

    public OutputStream stream() {
        return this.bos;
    }

    @Override
    public BytesReference bytes() {
        this.close();
        return ((BytesStream)((Object)this.bos)).bytes();
    }

    public BytesStream bytesStream() throws IOException {
        this.close();
        return (BytesStream)((Object)this.bos);
    }

    public String string() throws IOException {
        this.close();
        BytesArray bytesArray = this.bytes().toBytesArray();
        return new String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length(), Charsets.UTF_8);
    }

    public static enum FieldCaseConversion {
        NONE,
        UNDERSCORE,
        CAMELCASE;

    }
}

