/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapConverter;

public abstract class AbstractXContentParser
implements XContentParser {
    @Override
    public boolean booleanValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return this.intValue() != 0;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBoolean(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    protected abstract boolean doBooleanValue() throws IOException;

    @Override
    public short shortValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Short.parseShort(this.text());
        }
        return this.doShortValue();
    }

    protected abstract short doShortValue() throws IOException;

    @Override
    public int intValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Integer.parseInt(this.text());
        }
        return this.doIntValue();
    }

    protected abstract int doIntValue() throws IOException;

    @Override
    public long longValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Long.parseLong(this.text());
        }
        return this.doLongValue();
    }

    protected abstract long doLongValue() throws IOException;

    @Override
    public float floatValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Float.parseFloat(this.text());
        }
        return this.doFloatValue();
    }

    protected abstract float doFloatValue() throws IOException;

    @Override
    public double doubleValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Double.parseDouble(this.text());
        }
        return this.doDoubleValue();
    }

    protected abstract double doDoubleValue() throws IOException;

    @Override
    public String textOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public BytesRef bytesOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.bytes();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return XContentMapConverter.readMap(this);
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return XContentMapConverter.readOrderedMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> mapAndClose() throws IOException {
        try {
            Map<String, Object> map = this.map();
            return map;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> mapOrderedAndClose() throws IOException {
        try {
            Map<String, Object> map = this.mapOrdered();
            return map;
        }
        finally {
            this.close();
        }
    }
}

