/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.elasticsearch.common.collect.ImmutableMap;

public final class FieldNameAnalyzer
extends AnalyzerWrapper {
    private final ImmutableMap<String, Analyzer> analyzers;
    private final Analyzer defaultAnalyzer;

    public FieldNameAnalyzer(Map<String, Analyzer> analyzers, Analyzer defaultAnalyzer) {
        this.analyzers = ImmutableMap.copyOf(analyzers);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public ImmutableMap<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getAnalyzer(fieldName);
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return components;
    }

    private Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }
}

