/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;

public abstract class NumericTokenizer
extends Tokenizer {
    private final NumericTokenStream numericTokenStream;
    private final char[] buffer;
    protected final Object extra;

    protected NumericTokenizer(Reader reader, NumericTokenStream numericTokenStream, Object extra) throws IOException {
        this(reader, numericTokenStream, new char[32], extra);
    }

    protected NumericTokenizer(Reader reader, NumericTokenStream numericTokenStream, char[] buffer, Object extra) throws IOException {
        super(reader);
        this.numericTokenStream = numericTokenStream;
        this.extra = extra;
        this.buffer = buffer;
    }

    public void reset() throws IOException {
        this.reset(this.buffer);
    }

    public void reset(char[] buffer) throws IOException {
        int len = this.input.read(buffer);
        String value = new String(buffer, 0, len);
        this.setValue(this.numericTokenStream, value);
        this.numericTokenStream.reset();
    }

    public final boolean incrementToken() throws IOException {
        return this.numericTokenStream.incrementToken();
    }

    protected abstract void setValue(NumericTokenStream var1, String var2);
}

