/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene42.Lucene42Codec;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene42Codec {
    private final ESLogger logger;
    private final MapperService mapperService;
    private final PostingsFormat defaultPostingFormat;

    public PerFieldMappingPostingFormatCodec(MapperService mapperService, PostingsFormat defaultPostingFormat, ESLogger logger) {
        this.mapperService = mapperService;
        this.logger = logger;
        this.defaultPostingFormat = defaultPostingFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        FieldMappers indexName = this.mapperService.indexName(field);
        if (indexName == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", field);
            return this.defaultPostingFormat;
        }
        PostingsFormatProvider postingsFormat = indexName.mapper().postingsFormatProvider();
        return postingsFormat != null ? postingsFormat.get() : this.defaultPostingFormat;
    }
}

